/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.bankint;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.IntObjectTypeEnum;
import kd.tmc.ifm.helper.InterestCalcHelper;

public abstract class AbstractBankIntNavigatePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit intObjectF7 = (BasedataEdit)this.getControl("intobject");
        intObjectF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        DateEdit endIntDateControl = (DateEdit)this.getControl("endintdate");
        endIntDateControl.setMaxDate(DateUtils.getCurrentDate());
        this.addClickListeners(new String[]{"next"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "company": 
            case "currency": 
            case "intsource": {
                this.getModel().setValue("intobject", null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)property, (CharSequence)"intobject")) {
            this.initIntObjectFilter(evt);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate.getOperateKey().equals("next")) {
            Map<Object, IntBillInfo> calcInterests = this.calcInterest();
            this.validateIntInfo(args, calcInterests);
            if (!args.isCancel()) {
                this.getPageCache().put("calcIntResult", JSON.toJSONString(calcInterests));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evtArgs) {
        if (StringUtils.equals((CharSequence)"next", (CharSequence)evtArgs.getOperateKey()) && evtArgs.getOperationResult().isSuccess()) {
            this.getView().returnDataToParent(this.getNavFilterMap());
            this.getView().close();
        }
    }

    private List<DynamicObject> getIntObjects() {
        ArrayList<DynamicObject> intObjects = new ArrayList<DynamicObject>(16);
        List<Object> intObjectIds = this.getMultiBaseDataIds("intobject");
        QFilter qfilter = CollectionUtils.isEmpty(intObjectIds) ? this.getIntObjectFilter() : new QFilter("id", "in", intObjectIds);
        Map intObjectMap = TmcDataServiceHelper.loadFromCache((String)"ifm_bankacctintobject", (QFilter[])qfilter.toArray());
        if (EmptyUtil.isNoEmpty((Object)intObjectMap)) {
            intObjects.addAll(intObjectMap.values());
        }
        return intObjects;
    }

    private void validateIntInfo(BeforeDoOperationEventArgs args, Map<Object, IntBillInfo> calcInterests) {
        List<DynamicObject> intObjects = this.getIntObjects();
        if (EmptyUtil.isEmpty(intObjects)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u8981\u6c42\u7684\u8ba1\u606f\u5bf9\u8c61\u3002", (String)"AbstractBankIntNavigatePlugin_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (CollectionUtils.isEmpty(calcInterests)) {
            this.getView().showErrorNotification(this.getNoIntTip());
            args.setCancel(true);
            return;
        }
        this.validateOnWayBill(args, calcInterests);
    }

    private QFilter getIntObjectFilter() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        List<Object> companyIds = this.getMultiBaseDataIds("company");
        List<Object> currencyIds = this.getMultiBaseDataIds("currency");
        if (EmptyUtil.isNoEmpty(companyIds)) {
            qFilter.and(new QFilter("intobject.company.id", "in", companyIds));
        }
        if (EmptyUtil.isNoEmpty(currencyIds)) {
            qFilter.and(new QFilter("currency", "in", currencyIds));
        }
        qFilter.and(new QFilter("biztype", "=", (Object)IntObjectTypeEnum.BANKACCT.getValue()));
        this.addExtendFilter(qFilter);
        return qFilter;
    }

    private Map<String, Object> getNavFilterMap() {
        DynamicObjectCollection currency;
        IDataModel model = this.getModel();
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        DynamicObjectCollection company = (DynamicObjectCollection)model.getValue("company");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)company)) {
            dataMap.put("company", company);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(currency = (DynamicObjectCollection)model.getValue("currency")))) {
            dataMap.put("currency", currency);
        }
        dataMap.put("biztype", this.getBizType());
        Date endDate = (Date)model.getValue("endintdate");
        dataMap.put("endintdate", DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd"));
        String intSource = (String)model.getValue("intsource");
        dataMap.put("intsource", intSource);
        dataMap.put("objecttype", "ifm_bankacctintobject");
        List<DynamicObject> intObjects = this.getIntObjects();
        dataMap.put("intObjects", DynamicObjectSerializeUtil.serialize((Object[])intObjects.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_bankacctintobject")));
        dataMap.put("calcIntResult", this.getPageCache().get("calcIntResult"));
        return dataMap;
    }

    private void initIntObjectFilter(BeforeF7SelectEvent evt) {
        QFilter filter = this.getIntObjectFilter();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        Object objectIds = this.getView().getFormShowParameter().getCustomParams().get("loanIds");
        if (EmptyUtil.isNoEmpty(objectIds)) {
            filter.and("id", "not in", objectIds);
        }
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private List<Object> getMultiBaseDataIds(String fieldName) {
        DynamicObjectCollection baseData = (DynamicObjectCollection)this.getModel().getValue(fieldName);
        return baseData.stream().filter(EmptyUtil::isNoEmpty).map(v -> v.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).collect(Collectors.toList());
    }

    private Map<Object, IntBillInfo> calcInterest() {
        HashMap<Object, IntBillInfo> currentInt = new HashMap<Object, IntBillInfo>(16);
        Date endIntDate = (Date)this.getModel().getValue("endintdate");
        for (DynamicObject intObject : this.getIntObjects()) {
            Date beginDate = this.getStartDate(intObject);
            boolean isCalOverInt = intObject.getBoolean("iscaloverint");
            String intSource = intObject.getString("datasource");
            IntBillInfo callInt = InterestCalcHelper.callBankInt((DynamicObject)intObject, (Date)beginDate, (Date)endIntDate, (boolean)isCalOverInt, (boolean)this.isPreInt(), (String)intSource);
            if (!EmptyUtil.isNoEmpty((Object)callInt) || !EmptyUtil.isNoEmpty((BigDecimal)callInt.getAmount())) continue;
            currentInt.put(intObject.getPkValue(), callInt);
        }
        return currentInt;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFilterView();
    }

    public void initFilterView() {
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        Object initParams = customParam.get("initParams");
        if (EmptyUtil.isNoEmpty(initParams)) {
            Map params = (Map)initParams;
            if (params.containsKey("endintdate")) {
                this.getModel().setValue("endintdate", (Object)DateUtils.stringToDate((String)((String)params.get("endintdate")), (String)"yyyy-MM-dd"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"endintdate"});
                this.getView().updateView("endintdate");
            }
            if (params.containsKey("orgs")) {
                Set orgs = (Set)SerializationUtils.fromJsonString((String)params.get("orgs").toString(), Set.class);
                this.getModel().setValue("company", (Object)orgs.stream().map(s -> Long.parseLong(s.toString())).toArray());
                this.getView().updateView("company");
            }
            if (params.containsKey("currencys")) {
                Set currencys = (Set)SerializationUtils.fromJsonString((String)params.get("currencys").toString(), Set.class);
                this.getModel().setValue("currency", (Object)currencys.stream().map(s -> Long.parseLong(s.toString())).toArray());
                this.getView().updateView("currency");
            }
        }
    }

    private void validateOnWayBill(BeforeDoOperationEventArgs args, Map<Object, IntBillInfo> calcInterests) {
        Set<Object> intObjectIds = calcInterests.keySet();
        Map onWayBillMap = TmcDataServiceHelper.loadFromCache((String)"ifm_intbill_batch_bank", (QFilter[])new QFilter[]{new QFilter("entry.intobject", "in", intObjectIds), new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("biztype", "=", (Object)this.getBizType())});
        if (onWayBillMap.size() > 0) {
            StringJoiner intObjectNumbers = new StringJoiner(",");
            for (Map.Entry entry : onWayBillMap.entrySet()) {
                DynamicObject onWayBill = (DynamicObject)entry.getValue();
                DynamicObjectCollection rows = onWayBill.getDynamicObjectCollection("entry");
                rows.stream().map(v -> v.getDynamicObject("intobject")).filter(v -> intObjectIds.contains(v.getPkValue())).forEach(v -> intObjectNumbers.add(v.getString("number")));
            }
            this.getView().showErrorNotification(this.getExistIntBillTip(intObjectNumbers.toString()));
            args.setCancel(true);
        }
    }

    protected abstract boolean isPreInt();

    protected abstract Date getStartDate(DynamicObject var1);

    protected abstract void addExtendFilter(QFilter var1);

    protected abstract String getNoIntTip();

    protected abstract String getExistIntBillTip(String var1);

    protected abstract String getBizType();
}

