/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.bankint.settle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.BatchIntHelper;

public class BankIntBillBatchEdit
extends AbstractFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private JSONObject navParam = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"entry", (CharSequence)entryGrid.getKey())) {
            int index = evt.getRow();
            if (index < 0) {
                return;
            }
            this.loanIntEntry(index);
        }
    }

    private void loanIntEntry(int index) {
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", index);
        if (EmptyUtil.isNoEmpty((DynamicObject)entry)) {
            this.getModel().setValue("intnum", (Object)entry.getString("intdetailnum"));
            this.getModel().setValue("preloannum", entry.getDynamicObject("intobject").get("name"));
            BatchIntHelper.loanIntDetailInfo((DynamicObject)entry, (AbstractFormPlugin)this, (IDataModel)this.getModel());
        }
    }

    public void afterBindData(EventObject e) {
        this.loanIntEntry(0);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject navParam = this.getNavParam();
        String bizType = navParam.getString("biztype");
        this.getModel().setValue("biztype", (Object)bizType);
        Date endDate = DateUtils.stringToDate((String)((String)navParam.get((Object)"endintdate")), (String)"yyyy-MM-dd");
        this.getModel().setValue("bizdate", (Object)endDate);
        this.loadIntDetail();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "deleteentryloans": {
                String errMsg = this.checkLoansEntry();
                if (EmptyUtil.isNoEmpty((String)errMsg)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(errMsg);
                    return;
                }
                this.dealInterest();
                break;
            }
            case "addentryloans": {
                args.setCancel(true);
                this.openAddNewNavigateForm(this.initParams());
                break;
            }
        }
    }

    private void openAddNewNavigateForm(FormShowParameter showParameter) {
        String formid = "ifm_navigate_bank_addnew";
        if ("ifm_intbill_batch_bank".equals(this.getView().getEntityId())) {
            formid = "ifm_naviacctbank_addnew";
        }
        showParameter.setFormId(formid);
        showParameter.getCustomParams().put("entity", this.getView().getEntityId());
        showParameter.getCustomParams().put("formid", this.getView().getEntityId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_FILTER"));
        this.getView().showForm(showParameter);
    }

    private FormShowParameter initParams() {
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        List loanIds = entrys.stream().map(dny -> dny.getDynamicObject("intobject").getPkValue()).collect(Collectors.toList());
        showParameter.getCustomParams().put("loanIds", loanIds);
        if (StringUtils.equals((CharSequence)"ifm_intbill_batch_bank", (CharSequence)this.getView().getEntityId())) {
            initParams.put("endintdate", this.getModel().getValue("bizdate"));
        } else {
            initParams.put("endintdate", this.getModel().getValue("preintdate"));
        }
        HashSet<String> orgIds = new HashSet<String>(entrys.size());
        HashSet<String> currenyIds = new HashSet<String>(entrys.size());
        for (DynamicObject dyn : entrys) {
            orgIds.add(dyn.getDynamicObject("company").getPkValue().toString());
            currenyIds.add(dyn.getDynamicObject("currency").getPkValue().toString());
        }
        initParams.put("orgs", orgIds);
        initParams.put("currencys", currenyIds);
        showParameter.getCustomParams().put("initParams", initParams);
        return showParameter;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_FILTER", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            Map navparam = (Map)evt.getReturnData();
            String intObjectStr = navparam.get("intObjects").toString();
            Object[] intObjects = DynamicObjectSerializeUtil.deserialize((String)intObjectStr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_bankacctintobject"));
            Map calcIntResult = (Map)JSON.parseObject((String)navparam.get("calcIntResult").toString(), (TypeReference)new TypeReference<Map<Object, IntBillInfo>>(){}, (Feature[])new Feature[0]);
            ArrayList<Map<String, Object>> dataMap = new ArrayList<Map<String, Object>>(intObjects.length);
            for (Object obj : intObjects) {
                DynamicObject intObject = (DynamicObject)obj;
                IntBillInfo intBill = (IntBillInfo)calcIntResult.get(intObject.getPkValue());
                if (EmptyUtil.isEmpty((Object)intBill)) continue;
                this.fillIntDetail(dataMap, intBill, intObject);
            }
            TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataMap, (boolean)false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey)) {
            this.getView().updateView();
        } else if ("deleteentryloans".equals(operateKey)) {
            this.getView().invokeOperation("save");
        }
        this.loanIntEntry(0);
    }

    private void dealInterest() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        for (int i = 0; i < indexs.length; ++i) {
            Long id = ((DynamicObject)cl.get(indexs[i])).getLong("intbillid");
            if (!EmptyUtil.isNoEmpty((Long)id) || !TmcDataServiceHelper.exists((Object)id, (String)"ifm_currentintbill_bank")) continue;
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"ifm_currentintbill_bank", (Object[])new Object[]{((DynamicObject)cl.get(indexs[i])).getLong("intbillid")}, (OperateOption)operateOption, (boolean)true);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_currentintbill_bank", (Object[])new Object[]{((DynamicObject)cl.get(indexs[i])).getLong("intbillid")}, (OperateOption)operateOption, (boolean)true);
        }
    }

    private String checkLoansEntry() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        if (cl.size() == indexs.length) {
            return ResManager.loadKDString((String)"\u81f3\u5c11\u6709\u4e00\u6761\u5206\u5f55", (String)"CurrentPreIntBillBatchEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private void loadIntDetail() {
        JSONObject navParam = this.getNavParam();
        String intObjectStr = navParam.getString("intObjects");
        Object[] intObjects = DynamicObjectSerializeUtil.deserialize((String)intObjectStr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_bankacctintobject"));
        Map calcIntResult = (Map)JSON.parseObject((String)navParam.getString("calcIntResult"), (TypeReference)new TypeReference<Map<Object, IntBillInfo>>(){}, (Feature[])new Feature[0]);
        ArrayList<Map<String, Object>> dataMap = new ArrayList<Map<String, Object>>(intObjects.length);
        for (Object obj : intObjects) {
            DynamicObject intObject = (DynamicObject)obj;
            IntBillInfo intBill = (IntBillInfo)calcIntResult.get(intObject.getPkValue());
            if (EmptyUtil.isEmpty((Object)intBill)) continue;
            this.fillIntDetail(dataMap, intBill, intObject);
        }
        TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataMap);
    }

    private void fillIntDetail(List<Map<String, Object>> dataMap, IntBillInfo intBill, DynamicObject intObject) {
        HashMap<String, Object> detailMap = new HashMap<String, Object>(16);
        detailMap.put("company", intObject.getDynamicObject("org"));
        detailMap.put("intobject", intObject.getPkValue());
        DynamicObject currency = intObject.getDynamicObject("currency");
        detailMap.put("currency", currency);
        Date beginDate = intBill.getBeginDate();
        detailMap.put("startdate", beginDate);
        Date endDate = intBill.getEndDate();
        detailMap.put("enddate", endDate);
        if (beginDate != null && endDate != null) {
            detailMap.put("intdays", TermHelper.getDiffDays((Date)beginDate, (Date)endDate) + 1);
        }
        detailMap.put("company", intObject.getDynamicObject("org"));
        currency = intObject.getDynamicObject("currency");
        detailMap.put("currency", currency);
        String intObjectName = intObject.getString("name");
        detailMap.put("intcomment", this.genIntComment(intObjectName, intBill.getBizDate(), currency, intBill.getAmount()));
        List details = intBill.getDetails();
        details.sort((arg0, arg1) -> arg1.getEndDate().compareTo(arg0.getEndDate()));
        detailMap.put("interestamt", intBill.getAmount());
        detailMap.put("actualinstamt", intBill.getAmount());
        detailMap.put("intdetail_tag", SerializationUtils.toJsonString((Object)intBill));
        dataMap.add(detailMap);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (StringUtils.equals((CharSequence)"actualinstamt", (CharSequence)e.getProperty().getName())) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject currentEntry = this.getModel().getEntryRowEntity("entry", entryCurrentRowIndex);
            QFilter filter = new QFilter("id", "=", currentEntry.getDynamicObject("intobject").getPkValue());
            DynamicObject intObject = TmcDataServiceHelper.loadSingle((String)"ifm_bankacctintobject", (String)"intobject,name", (QFilter[])filter.toArray());
            String intObjectName = intObject.getString("name");
            DynamicObject currency = currentEntry.getDynamicObject("currency");
            Date bizDate = (Date)this.getModel().getValue("bizDate");
            BigDecimal intAmt = currentEntry.getBigDecimal("actualinstamt");
            this.getModel().setValue("intcomment", (Object)this.genIntComment(intObjectName, bizDate, currency, intAmt), entryCurrentRowIndex);
        }
    }

    private String genIntComment(String intObjectName, Date bizDate, DynamicObject currency, BigDecimal intAmt) {
        String intComment = String.format(ResManager.loadKDString((String)"%1$s\uff0c%2$s\u6536\u606f%3$s%4$s", (String)"BankIntBillBatchEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), intObjectName, DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"), currency.getString("name"), intAmt);
        return intComment;
    }

    private JSONObject getNavParam() {
        if (EmptyUtil.isEmpty((Object)this.navParam)) {
            Map param = this.getView().getFormShowParameter().getCustomParams();
            this.navParam = (JSONObject)param.get("navparam");
        }
        return this.navParam;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (fieldName.equals("interestamt")) {
            this.showIntDetailForm(evt.getRowIndex());
        } else if (fieldName.equals("intdetailnum")) {
            this.showIntBillForm(evt.getRowIndex());
        }
    }

    private void showIntDetailForm(int index) {
        FormShowParameter parameter = new FormShowParameter();
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", index);
        String callIntStr = entry.getString("intdetail_tag");
        parameter.getCustomParams().put("intdetail", callIntStr);
        parameter.getCustomParams().put("currency", entry.getDynamicObject("currency").getPkValue());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId("ifm_intbill_detail");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void showIntBillForm(int index) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setPkId(this.getModel().getValue("intbillid", index));
        String formId = this.isPreInt() ? "ifm_preintbill_bank" : "ifm_currentintbill_bank";
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private boolean isPreInt() {
        String formId = this.getView().getFormShowParameter().getFormId();
        return formId.equals("ifm_accrual_batch_bank");
    }
}

