/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.bizdeal;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.ifm.helper.BizDealHelper;
import kd.tmc.ifm.resource.IfmBizResource;

public class BizDealApplyEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bankAcct = (BasedataEdit)this.getControl("accountbank");
        bankAcct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit finproduct = (BasedataEdit)this.getControl("finproduct");
        finproduct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterLoadData(EventObject e) {
        this.setContractEndDate(this.getModel().getDataEntity().getDate("startdate"));
    }

    private void financingTypeF7Evt(BeforeF7SelectEvent evt) {
        IDataModel model = this.getModel();
        DynamicObject center = (DynamicObject)model.getValue("creditor");
        if (center == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u503a\u6743\u4eba\u3002", (String)"BizDealApplyEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        sp.getCustomParams().put("containDefault", "true");
        Object pkValue = center.getPkValue();
        sp.getListFilterParameter().getQFilters().add(new QFilter("center.id", "=", pkValue));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (field) {
            case "startdate": {
                this.calcTerm();
                this.getModel().setValue("rateadjustdate", (Object)(newValue != null ? (Date)newValue : null));
                break;
            }
            case "enddate": {
                this.calcTerm();
                break;
            }
            case "term": {
                this.calcEndDate();
                break;
            }
            case "rateadjuststyle": {
                this.registerMustInputByAdustStyle();
                break;
            }
            case "repaymentway": {
                this.setSettleIntModeByRepayWay();
                this.registerMustInputByRepaymentway();
                break;
            }
            case "finproduct": {
                this.finProductChgEvt(e);
                break;
            }
            case "creditor": {
                this.getModel().setValue("finproduct", null);
                break;
            }
            case "issyncdraw": {
                this.syncdrawChangedEvent();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "audit": {
                this.afterAuditOperation(args);
                break;
            }
        }
    }

    public void finProductChgEvt(PropertyChangedArgs e) {
        DynamicObject finproduct = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (finproduct == null) {
            return;
        }
        DynamicObject ldProduct = QueryServiceHelper.queryOne((String)"ifm_ldproduct", (String)"id,ratetype,basis,floatrate,productprice,referrate,ratesignbp,ratefloatpoints", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finproduct.getLong("id"))});
        if (ldProduct == null) {
            return;
        }
        String ratetype = ldProduct.getString("ratetype");
        boolean isFloatRate = InterestTypeEnum.FLOAT.getValue().equals(ratetype);
        this.getModel().setValue("interesttype", (Object)ratetype);
        this.getModel().setValue("basis", (Object)ldProduct.getString("basis"));
        BigDecimal productRate = ldProduct.getBigDecimal("productprice");
        if (isFloatRate) {
            this.getModel().setValue("ratetype", (Object)ldProduct.getLong("referrate"));
            this.getModel().setValue("ratesign", (Object)ldProduct.getString("ratesignbp"));
            this.getModel().setValue("ratefloatpoint", ldProduct.get("ratefloatpoints"));
            this.getModel().setValue("loanrate", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"ratesign", "ratefloatpoint"});
        } else {
            this.getModel().setValue("loanrate", (Object)productRate);
            this.getModel().setValue("ratetype", null);
            this.getModel().setValue("ratesign", null);
            this.getModel().setValue("ratefloatpoint", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"loanrate"});
        }
    }

    private void calcTerm() {
        DynamicObject scheme = this.getModel().getDataEntity();
        Date startdate = scheme.getDate("startdate");
        Date endDate = scheme.getDate("enddate");
        if (null == startdate || null == endDate) {
            return;
        }
        String term = DateUtils.getDiff_ymd((Date)startdate, (Date)endDate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)term);
    }

    private void calcEndDate() {
        DynamicObject scheme = this.getModel().getDataEntity();
        Date startDate = scheme.getDate("startdate");
        String termStr = scheme.getString("term");
        if (null == startDate || EmptyUtil.isEmpty((String)termStr)) {
            return;
        }
        Date endDate = TermHelper.getDateByTerm((String)termStr, (Date)startDate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)endDate);
    }

    private void setContractEndDate(Date startDate) {
        if (startDate == null) {
            return;
        }
        String term = (String)this.getModel().getValue("term");
        if (EmptyUtil.isEmpty((String)term)) {
            return;
        }
        Date endDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)startDate);
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("enddate"))) {
            this.getModel().setValue("enddate", (Object)endDate);
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("rateadjustdate"))) {
            this.getModel().setValue("rateadjustdate", (Object)startDate);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("bar_submit".equals(itemKey)) {
            QFilter qFilter;
            boolean exists;
            String contractNo;
            Date endDate;
            ILocaleString limitclauseexplain;
            IfmBizResource ifmBizResource = new IfmBizResource();
            boolean islimitclause = this.getModel().getDataEntity().getBoolean("islimitclause");
            if (islimitclause && EmptyUtil.isEmpty((String)(limitclauseexplain = this.getModel().getDataEntity().getLocaleString("limitclauseexplain")).getLocaleValue())) {
                this.getView().showTipNotification(ifmBizResource.checkLimitClauseExplain());
                evt.setCancel(true);
            }
            Date signDate = (Date)this.getModel().getValue("signdate");
            Date startDate = (Date)this.getModel().getValue("startdate");
            if (signDate != null && startDate != null && signDate.after(startDate)) {
                this.getView().showTipNotification(ifmBizResource.checkSignDateAndStartDate());
                evt.setCancel(true);
            }
            if ((endDate = (Date)this.getModel().getValue("enddate")) != null && startDate != null && startDate.after(endDate)) {
                this.getView().showTipNotification(ifmBizResource.checkEndDateAndStartDate());
                evt.setCancel(true);
            }
            if (EmptyUtil.isNoEmpty((String)(contractNo = (String)this.getModel().getValue("contractno"))) && (exists = QueryServiceHelper.exists((String)"ifm_loancontractbill", (QFilter[])(qFilter = new QFilter("contractno", "=", (Object)contractNo)).toArray()))) {
                this.getView().showTipNotification(ifmBizResource.checkContractNo());
                evt.setCancel(true);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setControlMustInput();
        this.registerMustInputByInterestType();
        this.setSettleIntModeByRepayWay();
        this.registerMustInputByRepaymentway();
    }

    private void registerMustInputByInterestType() {
        String intRateType = (String)this.getModel().getValue("interesttype");
        if (InterestTypeEnum.FIXED.getValue().equals(intRateType) || InterestTypeEnum.AGREE.getValue().equals(intRateType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"loanrate"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"ratetype", "ratesign", "ratefloatpoint", "rateadjuststyle"});
        } else if (InterestTypeEnum.FLOAT.getValue().equals(intRateType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"ratetype", "ratesign", "ratefloatpoint", "rateadjuststyle"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"loanrate"});
        }
        this.registerMustInputByAdustStyle();
    }

    private void setSettleIntModeByRepayWay() {
        String repayWay = (String)this.getModel().getValue("repaymentway");
        HashSet<String> repayWayLSBQ = new HashSet<String>(5);
        repayWayLSBQ.add(RepaymentWayEnum.bqhblsbq.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dqhblsbq.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debx.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debj.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dbdx.getValue());
        HashSet<String> repayWayFIX = new HashSet<String>(2);
        repayWayFIX.add(RepaymentWayEnum.dqhbdqhx.getValue());
        repayWayFIX.add(RepaymentWayEnum.bqhbdqhx.getValue());
        if (repayWayLSBQ.contains(repayWay)) {
            this.getModel().setValue("settleintmode", (Object)SettleIntModeEnum.lsbq.getValue());
        } else if (repayWayFIX.contains(repayWay)) {
            this.getModel().setValue("settleintmode", (Object)SettleIntModeEnum.gdpljx.getValue());
        }
    }

    private void registerMustInputByRepaymentway() {
        String repayWay = (String)this.getModel().getValue("repaymentway");
        HashSet<String> repayWaysShowIntSettlePlan = new HashSet<String>(16);
        repayWaysShowIntSettlePlan.add(RepaymentWayEnum.bqhbdqhx.getValue());
        repayWaysShowIntSettlePlan.add(RepaymentWayEnum.dqhbdqhx.getValue());
        repayWaysShowIntSettlePlan.add(RepaymentWayEnum.zdyhk.getValue());
        HashSet<String> repayWaysShowStageplan = new HashSet<String>(16);
        repayWaysShowStageplan.add(RepaymentWayEnum.dqhblsbq.getValue());
        repayWaysShowStageplan.add(RepaymentWayEnum.dqhbdqhx.getValue());
        repayWaysShowStageplan.add(RepaymentWayEnum.debx.getValue());
        repayWaysShowStageplan.add(RepaymentWayEnum.debj.getValue());
        repayWaysShowStageplan.add(RepaymentWayEnum.dbdx.getValue());
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)repayWaysShowIntSettlePlan.contains(repayWay), (String[])new String[]{"interestsettledplan"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)repayWaysShowStageplan.contains(repayWay), (String[])new String[]{"stageplan"});
    }

    private void registerMustInputByAdustStyle() {
        String intRateType = (String)this.getModel().getValue("interesttype");
        String adjustStyle = (String)this.getModel().getValue("rateadjuststyle");
        if ("cycle".equals(adjustStyle) && InterestTypeEnum.FLOAT.getValue().equals(intRateType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"rateadjustcycletype", "rateadjustcycle", "rateadjustdate"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"rateadjustcycletype", "rateadjustcycle", "rateadjustdate"});
        }
    }

    private void setControlMustInput() {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"signdate", "startdate", "term", "enddate", "accountbank", "repaymentway", "finproduct", "amount", "basis"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String field = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter lsp = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = lsp.getListFilterParameter().getQFilters();
        switch (field) {
            case "accountbank": {
                BizDealHelper.setBankAccountF7((IDataModel)this.getModel(), (List)qFilters);
                break;
            }
            case "finproduct": {
                this.financingTypeF7Evt(beforeF7SelectEvent);
                break;
            }
        }
    }

    private void syncdrawChangedEvent() {
        String formId;
        Boolean issyncdraw = (Boolean)this.getModel().getValue("issyncdraw");
        switch (formId = this.getView().getFormShowParameter().getFormId()) {
            case "ifm_bizdealbill_fin": {
                this.fillorClearSyncDrawInfo(issyncdraw);
            }
        }
    }

    private void fillorClearSyncDrawInfo(boolean issyncdraw) {
        IDataModel model = this.getModel();
        if (issyncdraw) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncdrawcurrency", (Object)model.getValue("currency"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncdrawamount", (Object)model.getValue("amount"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncdrawdate", (Object)model.getValue("startdate"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"startintdate", (Object)model.getValue("startdate"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)model.getValue("enddate"));
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"syncdrawcurrency", "syncdrawamount", "syncdrawdate", "startintdate", "expiredate"});
        } else {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"syncdrawcurrency", "syncdrawamount", "syncdrawdate", "startintdate", "expiredate"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"syncdrawcurrency", "syncdrawamount", "syncdrawdate", "startintdate", "expiredate"});
        }
    }

    private void afterAuditOperation(AfterDoOperationEventArgs args) {
        DynamicObject dataFromDB;
        Long pkValue;
        if (args.getOperationResult().isSuccess() && (pkValue = (Long)this.getModel().getDataEntity().getPkValue()) != null && pkValue != 0L && (dataFromDB = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)this.getModel().getDataEntityType().getName(), (String)"issyncdraw")).getBoolean("issyncdraw")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u5ba1\u6838\u786e\u8ba4\u5b8c\u6210\u540e\uff0c\u7cfb\u7edf\u5c06\u751f\u6210\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u653e\u6b3e\u5355\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"BizDealApplyEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
    }
}

