/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.bizdeal;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import org.apache.commons.lang3.tuple.Pair;

public class BizDealCenterEdit
extends AbstractTmcBillEdit {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("extend_apply".equals(this.getModel().getValue("applitype"))) {
            this.loadExtendBill();
        } else if ("repay_apply".equals(this.getModel().getValue("applitype"))) {
            this.loadRepayBillInfo();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("chargeback".equals(operateKey) && operationResult.isSuccess()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.PreOpenPageDeal(e);
    }

    private void PreOpenPageDeal(PreOpenFormEventArgs e) {
        BillShowParameter srcBillParameter = (BillShowParameter)e.getSource();
        if (EmptyUtil.isEmpty((Object)srcBillParameter)) {
            return;
        }
        Object pkId = srcBillParameter.getPkId();
        String pFormId = srcBillParameter.getParentFormId();
        String formId = srcBillParameter.getFormId();
        if ("botp_lookuptracker".equals(pFormId) && EmptyUtil.isNoEmpty((String)formId) && EmptyUtil.isNoEmpty((Object)pkId)) {
            QFilter idQFilter = new QFilter("id", "=", pkId);
            DynamicObject bizDeal = QueryServiceHelper.queryOne((String)"ifm_bizdealbill", (String)"id,applitype", (QFilter[])idQFilter.toArray());
            if (EmptyUtil.isEmpty((DynamicObject)bizDeal)) {
                return;
            }
            Pair<String, String> formPair = this.getFormIdByAppliType(bizDeal.getString("applitype"));
            if (null != formPair) {
                e.getFormShowParameter().setFormId((String)formPair.getLeft());
                e.getFormShowParameter().setCaption((String)formPair.getRight());
            }
        }
    }

    private Pair<String, String> getFormIdByAppliType(String appliType) {
        Pair pair = null;
        switch (appliType) {
            case "fin_apply": {
                pair = Pair.of((Object)"ifm_bizdealbill_fin", (Object)ResManager.loadKDString((String)"\u8d37\u6b3e\u4e1a\u52a1\u53d7\u7406", (String)"BizDealCenterEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "loan_apply": {
                pair = Pair.of((Object)"ifm_bizdealbill_loan", (Object)ResManager.loadKDString((String)"\u8d37\u6b3e\u4e1a\u52a1\u53d7\u7406", (String)"BizDealCenterEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "repay_apply": {
                pair = Pair.of((Object)"ifm_bizdealbill_repay", (Object)ResManager.loadKDString((String)"\u8d37\u6b3e\u4e1a\u52a1\u53d7\u7406", (String)"BizDealCenterEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "int_apply": {
                pair = Pair.of((Object)"ifm_bizdealbill_int", (Object)ResManager.loadKDString((String)"\u8d37\u6b3e\u4e1a\u52a1\u53d7\u7406", (String)"BizDealCenterEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "extend_apply": {
                pair = Pair.of((Object)"ifm_bizdealbill_ext", (Object)ResManager.loadKDString((String)"\u8d37\u6b3e\u4e1a\u52a1\u53d7\u7406", (String)"BizDealCenterEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        return pair;
    }

    private void loadRepayBillInfo() {
        Object sourcebillid = this.getModel().getValue("sourcebillid");
        if (EmptyUtil.isEmpty((Object)sourcebillid)) {
            return;
        }
        DynamicObject repayBill = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)"cfm_repaymentbill");
        DynamicObjectCollection entrys = repayBill.getDynamicObjectCollection("loans");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
            ArrayList billList = new ArrayList(entrys.size());
            for (DynamicObject entry : entrys) {
                HashMap<String, Object> bill = new HashMap<String, Object>(entrys.size());
                bill.put("loan_loanbill", entry.get("e_loanbill"));
                bill.put("loan_drawamount", entry.get("e_drawamount"));
                bill.put("loan_notrepayamount", entry.get("e_notrepayamount"));
                bill.put("loan_repayamount", entry.get("e_repayamount"));
                bill.put("loan_ispayinst", entry.get("e_ispayinst"));
                bill.put("loan_calintamt", entry.get("e_calintamt"));
                bill.put("loan_actintamt", entry.get("e_actintamt"));
                billList.add(bill);
            }
            TmcViewInputHelper.batchFillEntity((String)"loans", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), billList);
        }
    }

    private void loadExtendBill() {
        Object sourcebillid = this.getModel().getValue("sourcebillid");
        if (EmptyUtil.isEmpty((Object)sourcebillid)) {
            return;
        }
        DynamicObject extendBill = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)"ifm_contractextendbill");
        this.getModel().setValue("startdate", extendBill.get("startdate"));
        this.getModel().setValue("enddate", extendBill.get("enddate"));
        this.getModel().setValue("ext_drawamount", extendBill.get("drawamount"));
        this.getModel().setValue("ext_notrepayamount", extendBill.get("notrepayamount"));
        this.getModel().setValue("ext_protocolno", extendBill.get("protocolno"));
        this.getModel().setValue("ext_renewalnum", extendBill.get("renewalnum"));
        this.getModel().setValue("ext_bizdate", extendBill.get("bizdate"));
        this.getModel().setValue("ext_prevrenewalexpiredate", extendBill.get("prevrenewalexpiredate"));
        this.getModel().setValue("ext_renewalexpiredate", extendBill.get("renewalexpiredate"));
        this.getModel().setValue("ext_isadjustinterestrate", extendBill.get("isadjustinterestrate"));
        DynamicObjectCollection entrys = extendBill.getDynamicObjectCollection("loanbilllist");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
            ArrayList billList = new ArrayList(entrys.size());
            for (DynamicObject entry : entrys) {
                HashMap<String, Object> bill = new HashMap<String, Object>(entrys.size());
                bill.put("drawbillno", entry.get("drawbillno"));
                bill.put("drawcurrency", entry.get("drawcurrency"));
                bill.put("ldrawamount", entry.get("ldrawamount"));
                bill.put("e_loandate", entry.get("loandate"));
                bill.put("e_loanrate", entry.get("loanrate"));
                bill.put("e_expiredate", entry.get("expiredate"));
                bill.put("e_repayamount", entry.get("repayamount"));
                bill.put("e_isrenewal", entry.get("isrenewal"));
                bill.put("e_extendamount", entry.get("extendamount"));
                bill.put("e_prevrenewalexpiredate", entry.get("e_prevrenewalexpiredate"));
                bill.put("e_lrenewalexpiredate", entry.get("lrenewalexpiredate"));
                billList.add(bill);
            }
            TmcViewInputHelper.batchFillEntity((String)"loanbilllist", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), billList);
        }
    }
}

