/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.common;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.ifm.helper.TransDetailHelper;

public class BankCebterFilterEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        switch (field = e.getProperty().getName()) {
            case "settlecenter": {
                DynamicObject settlecenter = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.getModel().setValue("creditortype", (Object)"settlecenter");
                if (settlecenter != null) {
                    this.getModel().setValue("creditor", (Object)settlecenter.getLong("id"));
                    this.getModel().setValue("textcreditor", settlecenter.get("name"));
                    this.getModel().setValue("creditorg", (Object)settlecenter.getDynamicObject("org").getLong("id"));
                    break;
                }
                this.getModel().setValue("creditor", (Object)0L);
                this.getModel().setValue("textcreditor", null);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String field;
        switch (field = evt.getProperty().getName()) {
            case "settlecenter": {
                this.initSettleCenterFilter(evt);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        List<Long> billIds = Collections.singletonList((Long)this.getModel().getDataEntity().getPkValue());
        switch (args.getOperateKey()) {
            case "innerdetail": {
                TransDetailHelper.showInnerDetails((IFormView)this.getView(), (String)this.getModel().getDataEntityType().getName(), billIds);
            }
        }
    }

    private void initSettleCenterFilter(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        String appid = this.getView().getFormShowParameter().getAppId();
        Set bankIds = SettleCenterHelper.hasPermissionSettleCenter((String)appid, (String)this.getView().getFormShowParameter().getCustomParams().get("entity").toString(), (String)"47156aff000000ac");
        QFilter filter = new QFilter("id", "in", (Object)bankIds);
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }
}

