/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.ifm.enums.AcctClassifyEnum;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;

public class IfmInnerAccFilterPlugin
extends AbstractTmcBillBaseList {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.startsWith("company") && EmptyUtil.isNoEmpty(customParams.get("company"))) {
                filterColumn.setDefaultValue(String.valueOf(customParams.get("company")));
                continue;
            }
            if (fieldName.startsWith("bank.")) {
                this.bankFilters(commonFilterColumn, customParams.get("bank"));
                continue;
            }
            if (fieldName.startsWith("accountbank.")) {
                this.accountBankFilters(commonFilterColumn, customParams.get("accountbank"));
                continue;
            }
            if (!fieldName.startsWith("bizdate") || !EmptyUtil.isNoEmpty(customParams.get("bizdate"))) continue;
            String selDate = (String)customParams.get("bizdate");
            boolean isSameDay = DateUtils.isSameDay((Date)DateUtils.stringToDate((String)selDate, (String)"yyyy-MM-dd"), (Date)DateUtils.getCurrentDate());
            if (isSameDay) {
                filterColumn.setDefaultValue("13");
                continue;
            }
            filterColumn.setDefaultValues(Arrays.asList(selDate, selDate));
        }
    }

    private void accountBankFilters(CommonFilterColumn filterCol, Object defVal) {
        QFilter innerAccQFilter = new QFilter("acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue());
        QFilter statusQFilter = new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue());
        DynamicObjectCollection innerAccountColl = QueryServiceHelper.query((String)"am_accountbank", (String)"id,name,bankaccountnumber", (QFilter[])new QFilter[]{innerAccQFilter, statusQFilter});
        filterCol.setComboItems(this.initAccItemsList((List<DynamicObject>)innerAccountColl));
        if (EmptyUtil.isNoEmpty((Object)defVal)) {
            filterCol.setDefaultValue(String.valueOf(defVal));
        }
    }

    private void bankFilters(CommonFilterColumn filterCol, Object defVal) {
        Set settleCenters = SettleCenterHelper.getAuthorizedSettleCenters((String)"ifm", (String)"ifm_transdetail", (String)"47150e89000000ac");
        List<DynamicObject> settleCenterList = settleCenters.stream().filter(Objects::nonNull).sorted(Comparator.comparing(e -> e.getLong("id"))).collect(Collectors.toList());
        filterCol.setComboItems(this.initBankItemsList(settleCenterList));
        if (EmptyUtil.isNoEmpty((Object)defVal)) {
            filterCol.setDefaultValue(String.valueOf(defVal));
        }
    }

    private List<ComboItem> initBankItemsList(List<DynamicObject> settleCenters) {
        ArrayList<ComboItem> sCItems = new ArrayList<ComboItem>(10);
        if (!CollectionUtils.isEmpty(settleCenters)) {
            for (DynamicObject settleCenter : settleCenters) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(settleCenter.getString("name")));
                item.setValue(settleCenter.getString("id"));
                sCItems.add(item);
            }
        }
        return sCItems;
    }

    private List<ComboItem> initAccItemsList(List<DynamicObject> innerAccounts) {
        ArrayList<ComboItem> sCItems = new ArrayList<ComboItem>(10);
        if (!CollectionUtils.isEmpty(innerAccounts)) {
            for (DynamicObject innerAccount : innerAccounts) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(innerAccount.getString("bankaccountnumber")));
                item.setValue(innerAccount.getString("id"));
                sCItems.add(item);
            }
        }
        return sCItems;
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        CommonFilterColumn filterColumn = (CommonFilterColumn)args.getSource();
        this.setColFilters(filterColumn.getFieldName(), args.getQFilters());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        this.setColFilters(fieldName, args.getQfilters());
    }

    private void setColFilters(String fieldName, List<QFilter> filters) {
        QFilter innerAccQFilter;
        if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)"bank.")) {
            innerAccQFilter = new QFilter("finorgtype.type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
            filters.add(innerAccQFilter);
        }
        if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)"accountbank.")) {
            innerAccQFilter = new QFilter("acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue());
            innerAccQFilter.and(new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue()));
            filters.add(innerAccQFilter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("accountbank.acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue()));
        String appId = this.getView().getFormShowParameter().getAppId();
        List ids = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"ifm_transdetail", (String)"47150e89000000ac");
        qFilters.add(new QFilter("bank.id", "in", (Object)ids));
    }
}

