/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.deduction;

import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.DeductionTypeEnum;
import kd.tmc.ifm.enums.PaymentChanEnum;
import kd.tmc.ifm.helper.BankAccountBalanceHelper;
import kd.tmc.ifm.helper.DeductionBankHelper;
import kd.tmc.ifm.helper.TransBillHelper;

public class DeductionBankEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"payerlab", "payeelab"});
        BasedataEdit currency = (BasedataEdit)this.getControl("receivecurrency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPayPic();
        this.setPayeeField();
        this.setPanelText();
        this.controlCurrency();
        this.setChannelVals(false);
        DynamicObject account = (DynamicObject)this.getModel().getValue("paybankaccount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("receivecurrency");
        this.setBalanceLab(account, currency);
        ((Label)this.getControl("recaccbanknametext")).setText((String)this.getModel().getValue("recaccbankname"));
        ((Label)this.getControl("recbanknumbertext")).setText((String)this.getModel().getValue("recbanknumber"));
        this.controlByPayaccount();
        this.setPaymentIdeMustIpu();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "receivecurrency": {
                this.currencyF7Select(evt);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propKey;
        switch (propKey = e.getProperty().getName()) {
            case "deductiontype": {
                ChangeData[] changeSet = e.getChangeSet();
                String oldValue = (String)changeSet[0].getOldValue();
                this.clearPayInfo(oldValue);
                this.setPaymentIdeMustIpu();
                break;
            }
            case "payeetype": {
                this.payerTypeChange();
                break;
            }
            case "paybankaccount": {
                this.payerBankAccountChange();
                this.controlByPayaccount();
                break;
            }
            case "scorg": {
                this.scOrgChange();
                break;
            }
            case "paymentchannel": {
                this.controlByPayaccount();
                break;
            }
            case "recaccbankname": {
                ((Label)this.getControl("recaccbanknametext")).setText((String)this.getModel().getValue("recaccbankname"));
                break;
            }
            case "recbanknumber": {
                ((Label)this.getControl("recbanknumbertext")).setText((String)this.getModel().getValue("recbanknumber"));
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "payerlab": {
                this.changePayerInfo();
                break;
            }
            case "payeelab": {
                this.changePayeeInfo();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "ifm_deduction_payer": {
                this.setPayerInfo(evt);
                break;
            }
            case "ifm_deduction_payee": {
                this.setPayeeInfo(evt);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "audit": {
                    this.setBalanceLab((DynamicObject)this.getModel().getValue("paybankaccount"), (DynamicObject)this.getModel().getValue("receivecurrency"));
                }
            }
        }
    }

    private void controlCurrency() {
        DynamicObject payAcct = (DynamicObject)this.getModel().getValue("paybankaccount");
        if (payAcct != null) {
            DynamicObjectCollection currs = payAcct.getDynamicObjectCollection("currency");
            this.getView().setEnable(Boolean.valueOf(currs == null || currs.size() != 1), new String[]{"receivecurrency"});
        }
    }

    private void payerTypeChange() {
        this.getModel().setValue("payeebanknum", (Object)"");
        this.getModel().setValue("receiveaccount", null);
        this.getModel().setValue("payeebank", null);
        this.getModel().setValue("payeebankname", (Object)"");
        this.getModel().setValue("payeename", (Object)"");
        this.getModel().setValue("receivecompany", null);
        this.getModel().setValue("payee", null);
        this.getModel().setValue("payeeaccountbank", null);
        this.getModel().setValue("recaccbankname", (Object)"");
        this.getModel().setValue("recbanknumber", (Object)"");
    }

    private void scOrgChange() {
        Object orgId = this.getObjId("scorg");
        this.controlByPayaccount();
        this.payerTypeChange();
        if (EmptyUtil.isEmpty((Object)orgId)) {
            this.getModel().setValue("paybankaccount", null);
            this.getModel().setValue("paybank", null);
            this.getModel().setValue("receivecurrency", null);
            return;
        }
        String type = (String)this.getModel().getValue("deductiontype");
        if (!DeductionTypeEnum.CENTER_AGENT.getValue().equals(type)) {
            return;
        }
        DynamicObject defaultAccount = DeductionBankHelper.getDefaultAccount((Object)((Long)orgId), (String)"isdefaultpay");
        DynamicObject bank = EmptyUtil.isNoEmpty((DynamicObject)defaultAccount) ? defaultAccount.getDynamicObject("bank") : null;
        this.getModel().setValue("paybank", bank != null ? bank.getPkValue() : null);
        this.getModel().setValue("receivecurrency", defaultAccount != null ? defaultAccount.getDynamicObject("defaultcurrency").getPkValue() : null);
        this.getModel().setValue("paybankaccount", defaultAccount != null ? defaultAccount.getPkValue() : null);
        this.setBalanceLab((DynamicObject)this.getModel().getValue("paybankaccount"), (DynamicObject)this.getModel().getValue("receivecurrency"));
        DynamicObjectCollection accountCurrs = defaultAccount != null ? defaultAccount.getDynamicObjectCollection("currency") : null;
        this.getView().setEnable(Boolean.valueOf(accountCurrs == null || accountCurrs.size() > 1), new String[]{"receivecurrency"});
    }

    private void payerBankAccountChange() {
        DynamicObject account = (DynamicObject)this.getModel().getValue("paybankaccount");
        this.controlByPayaccount();
        this.setChannelVals(true);
        DynamicObject accountOpenOrg = account != null ? account.getDynamicObject("openorg") : null;
        DynamicObjectCollection accountCurrs = account != null ? account.getDynamicObjectCollection("currency") : null;
        this.getModel().setValue("receivecurrency", account != null ? account.getDynamicObject("defaultcurrency").getPkValue() : null);
        this.getView().setEnable(Boolean.valueOf(accountCurrs == null || accountCurrs.size() > 1), new String[]{"receivecurrency"});
        Object openOrg = this.getModel().getValue("openorg");
        if (openOrg == null && accountOpenOrg != null && OrgUnitServiceHelper.checkOrgFunction((Long)accountOpenOrg.getLong("id"), (String)"10")) {
            this.getModel().setValue("openorg", accountOpenOrg.get("id"));
            return;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("receivecurrency");
        this.setBalanceLab(account, currency);
    }

    private void controlByPayaccount() {
        DynamicObject account = (DynamicObject)this.getModel().getValue("paybankaccount");
        String paymentChannel = (String)this.getModel().getValue("paymentchannel");
        boolean isBeiPay = false;
        if (EmptyUtil.isNoEmpty((DynamicObject)account)) {
            boolean isBankInteFace = account.getBoolean("issetbankinterface");
            boolean isBei = PaymentChanEnum.BEI.getValue().equals(paymentChannel);
            isBeiPay = isBankInteFace && isBei;
        }
        this.getView().setVisible(Boolean.valueOf(isBeiPay), new String[]{"recaccbanknamelb", "recbanknumberlb"});
    }

    private void setChannelVals(boolean isDefault) {
        DynamicObject paymentIde = (DynamicObject)this.getModel().getValue("paymentidentify");
        if (TransBillHelper.isPassivePay((DynamicObject)paymentIde, (String)((String)this.getModel().getValue("deductiontype")))) {
            return;
        }
        DynamicObject payAccount = (DynamicObject)this.getModel().getValue("paybankaccount");
        ComboEdit paymentChannel = (ComboEdit)this.getControl("paymentchannel");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(PaymentChanEnum.COUNTER.getValue());
        comboItem.setCaption(new LocaleString(PaymentChanEnum.COUNTER.getName()));
        comboItems.add(comboItem);
        ComboItem defItem = comboItem;
        if (payAccount == null) {
            paymentChannel.setComboItems(comboItems);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"paymentchannel", (Object)defItem.getValue());
            return;
        }
        boolean isBankInteFace = payAccount.getBoolean("issetbankinterface");
        boolean isOpenBank = payAccount.getBoolean("isopenbank");
        if (isOpenBank) {
            comboItem = new ComboItem();
            comboItem.setValue(PaymentChanEnum.ONLINEBANK.getValue());
            comboItem.setCaption(new LocaleString(PaymentChanEnum.ONLINEBANK.getName()));
            comboItems.add(comboItem);
            defItem = comboItem;
        }
        if (isBankInteFace) {
            comboItem = new ComboItem();
            comboItem.setValue(PaymentChanEnum.BEI.getValue());
            comboItem.setCaption(new LocaleString(PaymentChanEnum.BEI.getName()));
            comboItems.add(comboItem);
            defItem = comboItem;
        }
        paymentChannel.setComboItems(comboItems);
        if (isDefault) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"paymentchannel", (Object)defItem.getValue());
        }
    }

    private void setBalanceLab(DynamicObject account, DynamicObject currency) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{currency, account})) {
            ((Label)this.getControl("balancev")).setText("\u00a50.00");
        } else {
            BigDecimal bankBalance;
            FormatObject fobj = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
            String labCurrencySign = currency.getString("sign");
            int currencyAmtprecision = currency.getInt("amtprecision");
            fobj.getCurrencyFormat().setCurrencySymbols(labCurrencySign);
            fobj.getCurrencyFormat().setMinimumFractionDigits(currencyAmtprecision);
            Format currencyFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
            DynamicObject scorg = (DynamicObject)this.getModel().getValue("scorg");
            if (EmptyUtil.isNoEmpty((DynamicObject)account) && EmptyUtil.isNoEmpty((DynamicObject)scorg) && EmptyUtil.isNoEmpty((DynamicObject)currency) && (bankBalance = BankAccountBalanceHelper.getBankBalance((Long)account.getLong("id"), (Long)scorg.getLong("id"), (Long)currency.getLong("id"))) != null) {
                ((Label)this.getControl("balancev")).setText(currencyFormat.format(bankBalance));
            }
        }
    }

    private void setPayeeField() {
        String deducType = (String)this.getModel().getValue("deductiontype");
        if (DeductionTypeEnum.AGENT_DEDUCTION.getValue().equals(deducType)) {
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("receivecompany", this.getModel().getValue("payee"));
            vals.put("receiveaccount", this.getModel().getValue("payeeaccountbank"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), vals);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"receivecurrency"});
            this.getModel().setDataChanged(false);
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)DeductionTypeEnum.CENTER_AGENT.getValue().equals(deducType), (String[])new String[]{"settletype", "paymentchannel"});
    }

    private void currencyF7Select(BeforeF7SelectEvent evt) {
        DynamicObject bankAccount;
        String deType = (String)this.getModel().getValue("deductiontype");
        if (DeductionTypeEnum.CENTER_AGENT.getValue().equals(deType) && (bankAccount = (DynamicObject)this.getModel().getValue("paybankaccount")) != null) {
            DynamicObjectCollection currencys = bankAccount.getDynamicObjectCollection("currency");
            Set ids = currencys.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            sp.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
        }
    }

    private void clearPayInfo(String deductionType) {
        if (DeductionTypeEnum.CENTER_AGENT.getValue().equals(deductionType)) {
            this.getModel().setValue("openorg", null);
            this.getModel().setValue("paybankaccount", null);
            this.getModel().setValue("paybank", null);
        }
        this.getModel().setValue("receiveaccount", null);
        this.getModel().setValue("receivecompany", null);
        this.getModel().setValue("payeebanknum", (Object)"");
        this.getModel().setValue("payee", (Object)0L);
        this.getModel().setValue("payeeaccountbank", (Object)0L);
        this.getModel().setValue("payeename", (Object)"");
        this.getModel().setValue("paybank", null);
        this.getModel().setValue("payeebank", null);
        this.getModel().setValue("payeebankname", (Object)"");
        this.getModel().setValue("recbanknumber", (Object)"");
        this.getModel().setValue("recaccbankname", (Object)"");
        this.getModel().setValue("payeetype", (Object)"");
        String deType = (String)this.getModel().getValue("deductiontype");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"payeetype"});
        if (DeductionTypeEnum.CENTER_AGENT.getValue().equals(deType)) {
            this.getModel().setValue("payeetype", (Object)"bd_supplier");
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"payeetype"});
            this.scOrgChange();
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)DeductionTypeEnum.CENTER_AGENT.getValue().equals(deType), (String[])new String[]{"settletype", "paymentchannel"});
        this.setPanelText();
    }

    private void setPanelText() {
        String deType = (String)this.getModel().getValue("deductiontype");
        HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
        HashMap<String, LocaleString> entryProps = new HashMap<String, LocaleString>(1);
        entryProps.put("text", new LocaleString(ResManager.loadKDString((String)"\u6263\u6b3e\u660e\u7ec6\uff08\u652f\u51fa\u65b9\uff09", (String)"DeductionBankEdit_6", (String)"tmc-ifm-formplugin", (Object[])new Object[0])));
        if (DeductionTypeEnum.CENTER_AGENT.getValue().equals(deType)) {
            props.put("text", new LocaleString(ResManager.loadKDString((String)"\u652f\u4ed8\u4fe1\u606f", (String)"DeductionBankEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0])));
        } else if (DeductionTypeEnum.CENTER_REFUND.getValue().equals(deType)) {
            props.put("text", new LocaleString(ResManager.loadKDString((String)"\u9000\u6b3e\u65b9\uff08\u652f\u51fa\u65b9\uff09", (String)"DeductionBankEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0])));
            entryProps.put("text", new LocaleString(ResManager.loadKDString((String)"\u9000\u6b3e\u660e\u7ec6\uff08\u6536\u5165\u65b9\uff09", (String)"DeductionBankEdit_7", (String)"tmc-ifm-formplugin", (Object[])new Object[0])));
        } else {
            props.put("text", new LocaleString(ResManager.loadKDString((String)"\u6263\u6b3e\u65b9\uff08\u6536\u5165\u65b9\uff09", (String)"DeductionBankEdit_5", (String)"tmc-ifm-formplugin", (Object[])new Object[0])));
        }
        this.getView().updateControlMetadata("fs_deduction", props);
        this.getView().updateControlMetadata("fs_deduction_details", entryProps);
    }

    private void setPayerInfo(ClosedCallBackEvent evt) {
        Map returnDataMap = (Map)evt.getReturnData();
        if (returnDataMap == null) {
            return;
        }
        this.getModel().setValue("paybankaccount", returnDataMap.get("paybankaccount"));
        this.getModel().setValue("paybank", returnDataMap.get("paybank"));
        this.getModel().setValue("openorg", returnDataMap.get("openorg"));
    }

    private void setPayeeInfo(ClosedCallBackEvent evt) {
        Map returnDataMap = (Map)evt.getReturnData();
        if (returnDataMap == null) {
            return;
        }
        this.getModel().setValue("payee", returnDataMap.get("payee"));
        this.getModel().setValue("payeeaccountbank", returnDataMap.get("payeeaccountbank"));
        this.getModel().setValue("payeebank", returnDataMap.get("payeebank"));
        this.getModel().setValue("payeename", returnDataMap.get("payeename"));
        this.getModel().setValue("payeebanknum", returnDataMap.get("payeebanknum"));
        this.getModel().setValue("payeebankname", returnDataMap.get("payeebankname"));
        this.getModel().setValue("recaccbankname", returnDataMap.get("recaccbankname"));
        this.getModel().setValue("recbanknumber", returnDataMap.get("recbanknumber"));
        if (this.isBeiEPay()) {
            this.getModel().setValue("reccity", returnDataMap.get("reccity"));
            boolean iscrosspay = (Boolean)this.getModel().getValue("iscrosspay");
            if (Boolean.TRUE == iscrosspay) {
                this.getModel().setValue("reccountry", returnDataMap.get("reccountry"));
                this.getModel().setValue("recbankaddress", returnDataMap.get("recbankaddress"));
                this.getModel().setValue("recswiftcode", returnDataMap.get("recswiftcode"));
                this.getModel().setValue("recroutingnum", returnDataMap.get("recroutingnum"));
                this.getModel().setValue("recothercode", returnDataMap.get("recothercode"));
            } else {
                this.getModel().setValue("recprovince", returnDataMap.get("recprovince"));
            }
        }
    }

    private void changePayerInfo() {
        Object scOrg = this.getModel().getValue("scorg");
        Object center = this.getModel().getValue("center");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{scOrg, center})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"DeductionBankEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ifm_deduction_payer");
        HashMap<String, Object> payerMap = new HashMap<String, Object>(4);
        payerMap.put("scorg", this.getObjId("scorg"));
        payerMap.put("paybankaccount", this.getObjId("paybankaccount"));
        payerMap.put("paybank", this.getObjId("paybank"));
        payerMap.put("openorg", this.getObjId("openorg"));
        parameter.setCustomParams(payerMap);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ifm_deduction_payer"));
        this.getView().showForm(parameter);
    }

    private void changePayeeInfo() {
        boolean isBeiPay;
        String payeeType = (String)this.getModel().getValue("payeetype");
        if (EmptyUtil.isEmpty((String)payeeType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"DeductionBankEdit_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object payBankAccount = this.getModel().getValue("paybankaccount");
        if (EmptyUtil.isEmpty((Object)payBankAccount)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u8d26\u53f7\u3002", (String)"DeductionBankEdit_4", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ifm_deduction_payee");
        HashMap<String, Object> payeeMap = new HashMap<String, Object>(4);
        payeeMap.put("payee", this.getModel().getValue("payee"));
        payeeMap.put("payeeaccountbank", this.getModel().getValue("payeeaccountbank"));
        payeeMap.put("payeebank", this.getObjId("payeebank"));
        payeeMap.put("payeename", this.getModel().getValue("payeename"));
        payeeMap.put("payeebanknum", this.getModel().getValue("payeebanknum"));
        payeeMap.put("payeebankname", this.getModel().getValue("payeebankname"));
        payeeMap.put("payeetype", payeeType);
        payeeMap.put("recaccbankname", this.getModel().getValue("recaccbankname"));
        payeeMap.put("recbanknumber", this.getModel().getValue("recbanknumber"));
        String type = (String)this.getModel().getValue("deductiontype");
        String chanel = (String)this.getModel().getValue("paymentchannel");
        boolean bl = isBeiPay = DeductionTypeEnum.CENTER_AGENT.getValue().equals(type) && ((DynamicObject)payBankAccount).getBoolean("issetbankinterface") && PaymentChanEnum.BEI.getValue().equals(chanel);
        if (!isBeiPay) {
            this.getModel().setValue("recbanknumber", (Object)"");
            this.getModel().setValue("recaccbankname", (Object)"");
        }
        payeeMap.put("issetbankinterface", isBeiPay);
        parameter.setCustomParams(payeeMap);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ifm_deduction_payee"));
        this.getView().showForm(parameter);
    }

    private Object getObjId(String prop) {
        DynamicObject val = (DynamicObject)this.getModel().getValue(prop);
        return EmptyUtil.isNoEmpty((DynamicObject)val) ? val.getPkValue() : null;
    }

    private void setPayPic() {
        String defaultUrl = "/kingdee/tmc/images/pc/icon/entrance/sky_fkf_80_80.png";
        Image pic = (Image)this.getControl("payerpic");
        pic.setUrl(defaultUrl);
        defaultUrl = "/kingdee/tmc/images/pc/icon/entrance/sky_skf_80_80.png";
        pic = (Image)this.getControl("payeepic");
        pic.setUrl(defaultUrl);
    }

    private void setPaymentIdeMustIpu() {
        String deductionType = (String)this.getModel().getValue("deductiontype");
        FieldEdit paymentIdentity = (FieldEdit)this.getControl("paymentidentify");
        paymentIdentity.setMustInput(DeductionTypeEnum.CENTER_AGENT.getValue().equals(deductionType));
    }

    private boolean isBeiEPay() {
        String deductionType = (String)this.getModel().getValue("deductiontype");
        String paymentchannel = (String)this.getModel().getValue("paymentchannel");
        DynamicObject paymentidentify = (DynamicObject)this.getModel().getValue("paymentidentify");
        return DeductionTypeEnum.CENTER_AGENT.getValue().equals(deductionType) && PaymentChanEnum.BEI.getValue().equals(paymentchannel) && (EmptyUtil.isNoEmpty((DynamicObject)paymentidentify) || "0".equals(paymentidentify.getString("type")));
    }
}

