/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.deduction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.helper.DeductionBankHelper;

public class DeductionPayeeEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "payeename", "payeebankaccountnum"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("payee", customParams.get("payee"));
        this.getModel().setValue("payeebankaccount", customParams.get("payeeaccountbank"));
        this.getModel().setValue("payeebank", customParams.get("payeebank"));
        this.getModel().setValue("payeename", customParams.get("payeename"));
        this.getModel().setValue("payeebankaccountnum", customParams.get("payeebanknum"));
        this.getModel().setValue("recaccbankname", customParams.get("recaccbankname"));
        this.getModel().setValue("recbanknumber", customParams.get("recbanknumber"));
        this.getView().setVisible(Boolean.valueOf(this.isBeiPay()), new String[]{"recaccbankname", "recbanknumber"});
        this.getView().updateView("contentpanel");
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control con = (Control)evt.getSource();
        switch (key = con.getKey()) {
            case "btnok": {
                this.btnOkClick();
                break;
            }
            case "payeename": {
                this.payeeNameClick();
                break;
            }
            case "payeebankaccountnum": {
                this.payeeBankAccountClick();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "payeename": {
                ListSelectedRow row = this.getSelectRow(evt);
                if (row == null) break;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payee", (Object)row.getPrimaryKeyValue());
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payeename", (Object)row.getName());
                this.setDefaultAcountAndBank();
                break;
            }
            case "bos_user": {
                ListSelectedRow row = this.getSelectRow(evt);
                if (row == null) break;
                this.getModel().setValue("payeebankaccount", row.getPrimaryKeyValue());
                DynamicObject payeer = TmcDataServiceHelper.loadSingleFromCache((Object)row.getPrimaryKeyValue(), (String)"er_payeer", (String)"id,payerbank,payeraccountname");
                if (!EmptyUtil.isNoEmpty((DynamicObject)payeer)) break;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payeebankaccountnum", (Object)payeer.getString("payeraccount"));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recaccbankname", (Object)payeer.getString("payeraccountname"));
                DynamicObject payerBank = payeer.getDynamicObject("payerbank");
                HashMap<String, Object> valMap = new HashMap<String, Object>(2);
                valMap.put("payeebank", payerBank != null ? payerBank.getPkValue() : Long.valueOf(0L));
                valMap.put("recbanknumber", payerBank != null ? this.getUnionNumber(payerBank.getPkValue()) : "");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), valMap);
                break;
            }
            case "payeebankaccountnum": {
                if (this.checkPayeeType("bd_customer") || this.checkPayeeType("bd_supplier")) {
                    DynamicObject data = (DynamicObject)evt.getReturnData();
                    if (!EmptyUtil.isNoEmpty((DynamicObject)data)) break;
                    HashMap<String, Object> valMap = new HashMap<String, Object>(4);
                    valMap.put("payeebankaccount", data.getLong("id"));
                    valMap.put("payeebankaccountnum", data.getString("bankaccount"));
                    valMap.put("recaccbankname", data.getString("accountname"));
                    DynamicObject bank = data.getDynamicObject("bank");
                    valMap.put("payeebank", bank != null ? bank.getLong("id") : 0L);
                    valMap.put("recbanknumber", bank != null ? this.getUnionNumber(bank.getPkValue()) : "");
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), valMap);
                    break;
                }
                ListSelectedRow row = this.getSelectRow(evt);
                if (row == null) break;
                this.setDefaultByOrgOrUser(row);
            }
        }
    }

    private void setDefaultByOrgOrUser(ListSelectedRow row) {
        DynamicObject bank;
        boolean isOrg = this.checkPayeeType("bos_org");
        String entityName = "er_payeer";
        String fields = "id,payerbank,payeraccount";
        if (isOrg) {
            entityName = "bd_accountbanks";
            fields = "id,acctname,bankaccountnumber,bank";
        }
        DynamicObject payeer = TmcDataServiceHelper.loadSingleFromCache((Object)row.getPrimaryKeyValue(), (String)entityName, (String)fields);
        HashMap<String, Object> valMap = new HashMap<String, Object>(4);
        valMap.put("payeebankaccount", payeer != null ? payeer.getPkValue() : Long.valueOf(0L));
        valMap.put("payeebankaccountnum", payeer != null ? payeer.getString(isOrg ? "bankaccountnumber" : "payeraccount") : "");
        valMap.put("recaccbankname", payeer != null ? payeer.getString(isOrg ? "acctname" : "payeraccountname") : "");
        DynamicObject dynamicObject = payeer != null ? payeer.getDynamicObject(isOrg ? "bank" : "payerbank") : (bank = null);
        if (isOrg) {
            bank = bank != null ? bank.getDynamicObject("bebank") : null;
        }
        valMap.put("payeebank", bank != null ? bank.getLong("id") : 0L);
        valMap.put("recbanknumber", bank != null ? this.getUnionNumber(bank.getPkValue()) : "");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), valMap);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop;
        switch (prop = e.getProperty().getName()) {
            case "payeename": {
                this.payeeNameChange();
                break;
            }
            case "payee": {
                this.peyeeChange();
                break;
            }
            case "payeebankaccountnum": {
                this.payeeAccountChange();
                break;
            }
            case "payeebank": {
                this.payeeBankChange();
            }
        }
    }

    private ListSelectedRow getSelectRow(ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnDatas = (ListSelectedRowCollection)evt.getReturnData();
        if (EmptyUtil.isNoEmpty((Object)returnDatas)) {
            return returnDatas.get(0);
        }
        return null;
    }

    private void peyeeChange() {
        Object payee = this.getModel().getValue("payee");
        if (EmptyUtil.isEmpty((Object)payee)) {
            this.getModel().setValue("payeebankaccountnum", null);
            this.getModel().setValue("payeebankaccount", null);
            this.getModel().setValue("recbanknumber", (Object)"");
        } else {
            DynamicObjectCollection accountBankColls = this.getAccountBankColls(this.getType());
            this.setDefaultAccout(accountBankColls);
        }
    }

    private void setDefaultAcountAndBank() {
        String payeeType;
        switch (payeeType = this.getType()) {
            case "bd_customer": 
            case "bd_supplier": {
                DynamicObjectCollection accountBankColls = this.getAccountBankColls(payeeType);
                this.setDefaultAccout(accountBankColls);
                break;
            }
            case "bos_org": {
                Object payeeId = this.getModel().getValue("payee");
                DynamicObject defaultAccount = DeductionBankHelper.getDefaultAccount((Object)payeeId, (String)"isdefaultrec");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payeebankaccount", (Object)(defaultAccount != null ? defaultAccount.getPkValue() : Long.valueOf(0L)));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payeebankaccountnum", (Object)(defaultAccount != null ? defaultAccount.getString("bankaccountnumber") : ""));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recaccbankname", (Object)(defaultAccount != null ? defaultAccount.getString("acctname") : ""));
                DynamicObject bank = defaultAccount != null ? defaultAccount.getDynamicObject("bank") : null;
                DynamicObject bebank = bank != null ? bank.getDynamicObject("bebank") : null;
                this.setPaybankVal(bebank);
                break;
            }
            case "bos_user": {
                Object[] erPayers = this.getErPayers(true);
                Object erPayer = EmptyUtil.isNoEmpty((Object[])erPayers) ? erPayers[0] : null;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payeebankaccount", (Object)(erPayer != null ? erPayer.getPkValue() : Long.valueOf(0L)));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payeebankaccountnum", (Object)(erPayer != null ? erPayer.getString("payeraccount") : ""));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recaccbankname", (Object)(erPayer != null ? erPayer.getString("payeraccountname") : ""));
                DynamicObject bank = erPayer != null ? erPayer.getDynamicObject("payerbank") : null;
                this.setPaybankVal(bank);
            }
        }
    }

    private void setPaybankVal(DynamicObject bebank) {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payeebank", (Object)(bebank != null ? bebank.getPkValue() : Long.valueOf(0L)));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recbanknumber", (Object)(bebank != null ? this.getUnionNumber(bebank.getPkValue()) : ""));
    }

    private void payeeNameChange() {
        Object payeeName = this.getModel().getValue("payeename");
        this.getModel().setValue("payee", (Object)0L);
        if (EmptyUtil.isEmpty((Object)payeeName)) {
            this.getModel().setValue("payeebankaccountnum", null);
            this.getModel().setValue("payeebankaccount", null);
            this.getModel().setValue("recaccbankname", null);
        } else if (!this.checkPayeeType("other")) {
            DynamicObject data = this.getDataBase(this.getType());
            if (data == null) {
                this.getModel().setValue("payeebankaccountnum", null);
                return;
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payee", (Object)data.getPkValue());
            this.setDefaultAcountAndBank();
        }
    }

    private void setDefaultAccout(DynamicObjectCollection accountBankColls) {
        DynamicObject accountBank = null;
        if (accountBankColls != null && accountBankColls.size() > 0) {
            accountBank = accountBankColls.stream().filter(o -> o.getBoolean("isdefault_bank")).findFirst().orElseGet(() -> (DynamicObject)accountBankColls.get(0));
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payeebankaccountnum", (Object)(accountBank != null ? accountBank.getString("bankaccount") : ""));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payeebankaccount", (Object)(accountBank != null ? accountBank.getPkValue() : Long.valueOf(0L)));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recaccbankname", (Object)(accountBank != null ? accountBank.getString("accountname") : ""));
        DynamicObject bank = accountBank != null ? accountBank.getDynamicObject("bank") : null;
        this.setPaybankVal(bank);
    }

    private void payeeAccountChange() {
        this.getModel().setValue("payeebankaccount", (Object)0L);
        this.getModel().setValue("payeebank", (Object)0L);
        this.getModel().setValue("recaccbankname", (Object)"");
    }

    private void payeeBankChange() {
        DynamicObject payeeBank = (DynamicObject)this.getModel().getValue("payeebank");
        if (payeeBank != null) {
            this.getModel().setValue("recbanknumber", (Object)payeeBank.getString("union_number"));
        }
    }

    private void payeeBankAccountClick() {
        String payeeType;
        switch (payeeType = this.getType()) {
            case "bd_supplier": 
            case "bd_customer": {
                Object payeeName = this.getModel().getValue("payeename");
                if (!this.checkPayee()) {
                    return;
                }
                List<Map<String, Object>> accountList = this.getAccountBanks(payeeType);
                if (EmptyUtil.isEmpty(accountList)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4[%s]\u5bf9\u5e94\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"DeductionPayeeEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), payeeName));
                    return;
                }
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("ifm_deduction_accounts");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("accounts", accountList);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "payeebankaccountnum"));
                this.getView().showForm(parameter);
                break;
            }
            case "bos_user": {
                if (!this.checkPayee()) {
                    return;
                }
                ListShowParameter sp = ShowFormHelper.createShowListForm((String)"er_payeer", (boolean)false, (int)2);
                sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bos_user"));
                sp.getListFilterParameter().getQFilters().add(this.getErPayerFilter());
                this.getView().showForm((FormShowParameter)sp);
                break;
            }
            case "bos_org": {
                if (!this.checkPayee()) {
                    return;
                }
                ListShowParameter sp = ShowFormHelper.createShowListForm((String)"bd_accountbanks", (boolean)false, (int)2);
                sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "payeebankaccountnum"));
                Long payeeId = (Long)this.getModel().getValue("payee");
                sp.getListFilterParameter().getQFilters().add(this.getAccoutFilter(payeeId));
                this.getView().showForm((FormShowParameter)sp);
                break;
            }
            case "other": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u7c7b\u578b\u4e3a[\u5176\u4ed6],\u8bf7\u624b\u5de5\u8f93\u5165\u3002", (String)"DeductionPayeeEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean checkPayee() {
        Object payeeName = this.getModel().getValue("payeename");
        if (EmptyUtil.isEmpty((Object)payeeName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"DeductionPayeeEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long payeeId = (Long)this.getModel().getValue("payee");
        if (EmptyUtil.isEmpty((Long)payeeId)) {
            payeeName = (String)this.getModel().getValue("payeename");
            Object[] datas = TmcDataServiceHelper.load((String)this.getType(), (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", payeeName)});
            if (EmptyUtil.isNoEmpty((Object[])datas)) {
                payeeId = datas[0].getLong("id");
                this.getModel().setValue("payee", (Object)payeeId);
            }
        }
        if (EmptyUtil.isEmpty((Long)payeeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u6536\u6b3e\u4eba\uff0c\u8bf7\u624b\u5de5\u8f93\u5165\u3002", (String)"DeductionPayeeEdit_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<Map<String, Object>> getAccountBanks(String payeeType) {
        DynamicObjectCollection bankColls = this.getAccountBankColls(payeeType);
        ArrayList<Map<String, Object>> accountList = new ArrayList<Map<String, Object>>(16);
        if (bankColls != null) {
            bankColls.forEach(o -> {
                HashMap<String, Object> accountMaps = new HashMap<String, Object>(6);
                accountMaps.put("bankaccount", o.getString("bankaccount"));
                accountMaps.put("accountname", o.getString("accountname"));
                accountMaps.put("bank", o.getDynamicObject("bank").getPkValue());
                accountMaps.put("currency", o.getDynamicObject("currency").getPkValue());
                accountMaps.put("isdefault", o.getBoolean("isdefault_bank"));
                accountMaps.put("id", o.get("id"));
                accountList.add(accountMaps);
            });
        }
        return accountList;
    }

    private DynamicObjectCollection getAccountBankColls(String payeeType) {
        DynamicObject payee;
        if (("bd_supplier".equals(payeeType) || "bd_customer".equals(payeeType)) && (payee = this.getDataBase(payeeType)) != null) {
            return payee.getDynamicObjectCollection("entry_bank");
        }
        return null;
    }

    private DynamicObject getDataBase(String payeeType) {
        Object payeeId = this.getModel().getValue("payee");
        DynamicObject payee = null;
        if (EmptyUtil.isNoEmpty((Object)payeeId)) {
            payee = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeId, (String)payeeType);
        }
        Object payeename = this.getModel().getValue("payeename");
        if (payee == null && EmptyUtil.isNoEmpty((Object)payeename)) {
            payee = BusinessDataServiceHelper.loadSingleFromCache((String)payeeType, (QFilter[])new QFilter[]{new QFilter("name", "=", payeename)});
        }
        return payee;
    }

    private void payeeNameClick() {
        String payeeType = this.getType();
        if ("other".equals(payeeType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u7c7b\u578b\u4e3a[\u5176\u4ed6],\u8bf7\u624b\u5de5\u8f93\u5165\u3002", (String)"DeductionPayeeEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        } else {
            ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)payeeType, (boolean)false);
            QFilter filter = new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            showListForm.getListFilterParameter().getQFilters().add(filter);
            showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "payeename"));
            this.getView().showForm((FormShowParameter)showListForm);
        }
    }

    private void btnOkClick() {
        HashMap<String, Object> payMap = new HashMap<String, Object>(8);
        payMap.put("payee", this.getModel().getValue("payee"));
        payMap.put("payeeaccountbank", this.getModel().getValue("payeebankaccount"));
        DynamicObject payeeBank = (DynamicObject)this.getModel().getValue("payeebank");
        payMap.put("payeebank", payeeBank != null ? payeeBank.getPkValue() : Long.valueOf(0L));
        payMap.put("payeename", this.getModel().getValue("payeename"));
        payMap.put("payeebanknum", this.getModel().getValue("payeebankaccountnum"));
        payMap.put("payeebankname", payeeBank != null ? payeeBank.getString("name") : "");
        boolean isBeiPay = this.isBeiPay();
        payMap.put("recaccbankname", isBeiPay ? this.getModel().getValue("recaccbankname") : "");
        payMap.put("recbanknumber", isBeiPay ? this.getModel().getValue("recbanknumber") : "");
        if (payeeBank != null) {
            DynamicObject country = payeeBank.getDynamicObject("country");
            payMap.put("reccountry", country != null ? country.getPkValue() : Long.valueOf(0L));
            payMap.put("recprovince", payeeBank.getString("provincetxt"));
            payMap.put("reccity", payeeBank.getString("citytxt"));
            payMap.put("recbankaddress", payeeBank.getString("address_eng"));
            payMap.put("recswiftcode", payeeBank.getString("swift_code"));
            payMap.put("recroutingnum", payeeBank.getString("routingnum"));
            payMap.put("recothercode", payeeBank.getString("other_code"));
        }
        this.getView().returnDataToParent(payMap);
        this.getView().close();
    }

    private QFilter getAccoutFilter(Long payeeId) {
        return TmcAccountHelper.getAccountBankFilterByOrg((Long)payeeId).and(new QFilter("acctstatus", "=", (Object)"normal"));
    }

    private QFilter getErPayerFilter() {
        Object[] query = this.getErPayers(false);
        QFilter uFilter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("isemployee", "=", (Object)Character.valueOf('1')));
        if (EmptyUtil.isNoEmpty((Object[])query)) {
            Object payeeName = this.getModel().getValue("payeename");
            uFilter = uFilter.and(new QFilter("name", "=", payeeName));
        } else {
            uFilter = new QFilter("id", "in", (Object)Arrays.stream(query).map(dy -> dy.get("id")).toArray());
        }
        return uFilter;
    }

    private DynamicObject[] getErPayers(boolean isDefault) {
        Object payeeId = this.getModel().getValue("payee");
        QFilter uFilter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("isemployee", "=", (Object)Character.valueOf('1'))).and(new QFilter("payer", "=", payeeId));
        if (isDefault) {
            uFilter.and("isdefault", "=", (Object)"1");
        }
        return TmcDataServiceHelper.load((String)"er_payeer", (String)"id,payerbank,payeraccount,payeraccountname", (QFilter[])new QFilter[]{uFilter});
    }

    private boolean checkPayeeType(String type) {
        return type.equals(this.getType());
    }

    private String getType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (String)customParams.get("payeetype");
    }

    private boolean isBeiPay() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return customParams.getOrDefault("issetbankinterface", Boolean.FALSE);
    }

    private String getUnionNumber(Object id) {
        DynamicObject beBank = TmcDataServiceHelper.loadSingleFromCache((Object)id, (String)"bd_bebank", (String)"id,union_number");
        return beBank != null ? beBank.getString("union_number") : "";
    }
}

