/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.deposit.bizdeal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BizDealDepositEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit finAccountF7 = (BasedataEdit)this.getControl("finaccountf7");
        finAccountF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit settleAccountF7 = (BasedataEdit)this.getControl("settleaccount");
        settleAccountF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit finAccount = (TextEdit)this.getControl("finaccount");
        finAccount.addButtonClickListener((ClickListener)this);
        this.setDateSection("applydate", "intdate", true);
        this.setDateSection("intdate", "expiredate", false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initViewInfo();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String fieldName = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"finaccount")) {
            ((BasedataEdit)this.getControl("finaccountf7")).click();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)"finaccountf7", (CharSequence)actionId) && EmptyUtil.isNoEmpty((Object)returnData)) {
            this.getModel().setValue("finaccount", (Object)returnData.get(0).getNumber());
            this.getModel().setValue("finaccountf7", returnData.get(0).getPrimaryKeyValue());
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String fieldName = source.getKey();
        Object value = e.getValue();
        if (EmptyUtil.isEmpty((Object)value)) {
            return;
        }
        switch (fieldName) {
            case "term": {
                boolean rightFormat = TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString());
                if (rightFormat) break;
                e.setCancel(true);
                this.getView().updateView(fieldName);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"finaccountf7") || StringUtils.equals((CharSequence)fieldName, (CharSequence)"settleaccount")) {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"finaccountf7")) {
                listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldName));
            }
            listShowParameter.setMultiSelect(false);
            listShowParameter.getListFilterParameter().getQFilters().add(this.getAccountFilter(fieldName));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "term": 
            case "intdate": {
                this.calExpireDate();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ((operateKey.equals("chargeback") || operateKey.equals("unchargeback")) && args.getOperationResult().isSuccess()) {
            this.getView().updateView();
        }
    }

    private QFilter getAccountFilter(String feildName) {
        DynamicObject finOrg = (DynamicObject)this.getModel().getValue("finorginfo");
        QFilter qFilter = new QFilter("bank", "=", finOrg.getPkValue());
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        qFilter.and(new QFilter("company", "=", org.getPkValue()));
        qFilter.and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        qFilter.and(new QFilter("currency.fbasedataid.id", "=", currency.getPkValue()));
        DynamicObject extAccount = StringUtils.equals((CharSequence)feildName, (CharSequence)"settleaccount") ? (DynamicObject)this.getModel().getValue("finaccountf7") : (DynamicObject)this.getModel().getValue("settleaccount");
        if (EmptyUtil.isNoEmpty((DynamicObject)extAccount)) {
            qFilter.and(new QFilter("id", "!=", extAccount.getPkValue()));
        }
        return qFilter;
    }

    private void setDateSection(String referDateField, String targetDateField, boolean canEquals) {
        Date referDate = (Date)this.getModel().getValue(referDateField);
        if (EmptyUtil.isEmpty((Object)referDate)) {
            return;
        }
        if (!canEquals) {
            referDate = DateUtils.getNextDay((Date)referDate, (int)1);
        }
        DateEdit targetDate = (DateEdit)this.getControl(targetDateField);
        targetDate.setMinDate(referDate);
    }

    private void calExpireDate() {
        String term = (String)this.getModel().getValue("term");
        Date intDate = (Date)this.getModel().getValue("intdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, term})) {
            this.getModel().setValue("expiredate", null);
            return;
        }
        Date expireDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)intDate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)expireDate);
        this.setDateSection("intdate", "expiredate", false);
    }

    private void initViewInfo() {
        DynamicObject investVarieties = (DynamicObject)this.getModel().getValue("investvarieties");
        boolean isFixed = InvestTypeEnum.isFixed((String)investVarieties.getString("investtype"));
        this.initMustInputView(isFixed);
        this.initBasisComb(isFixed);
    }

    private void initMustInputView(boolean isFixed) {
        ArrayList<String> mustInputFields = new ArrayList<String>(16);
        mustInputFields.addAll(Arrays.asList("settleaccount", "finaccount", "intdate", "demandrate", "basis", "revenuesche"));
        if (isFixed) {
            mustInputFields.addAll(Arrays.asList("expireredeposit", "term", "expiredate"));
        } else {
            mustInputFields.add("prenoticeday");
        }
        String interestType = (String)this.getModel().getValue("interesttype");
        if (StringUtils.equals((CharSequence)interestType, (CharSequence)"fixed")) {
            mustInputFields.add("interestrate");
        } else {
            mustInputFields.addAll(Arrays.asList("referencerate", "ratesign", "ratefloatpoint", "rateadjuststyle"));
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])mustInputFields.toArray(new String[0]));
    }

    private void initBasisComb(boolean isFixed) {
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDynamicObjectType().getProperties();
        ComboProp basisProp = (ComboProp)properties.stream().filter(v -> v.getName().equals("basis")).findFirst().orElseGet(null);
        if (null == basisProp) {
            return;
        }
        List valueMapItems = basisProp.getComboItems();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        for (ValueMapItem valueMapItem : valueMapItems) {
            String value = valueMapItem.getValue();
            if ("DEP_30_360".equals(value) && !isFixed) continue;
            comboItems.add(new ComboItem(valueMapItem.getName(), value));
        }
        ((ComboEdit)this.getControl("basis")).setComboItems(comboItems);
    }
}

