/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.deposit.bizdeal;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.ReleaseTypeEnum;
import kd.tmc.ifm.helper.DepositHelper;

public class BizDealReleaseEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setRedeemDateSection();
        this.setReleaseTypeComboItem();
        this.initViewInfo();
        this.setAmountView(true);
        this.initExpirereDptComb();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "redeemdate": {
                this.redeemDateChgEvt();
                break;
            }
            case "amount": {
                this.amountChgEvt(e.getChangeSet()[0].getOldValue());
                break;
            }
            case "releasetype": {
                this.releaseTypeChgEvt();
                break;
            }
            case "expireredeposit": {
                this.expirereDepositChgEvt();
                break;
            }
            case "isrevenue": {
                this.initViewInfo();
                this.reCalInterest();
                break;
            }
            case "realrevenue": {
                this.realRevenueChgEvt();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ((operateKey.equals("chargeback") || operateKey.equals("unchargeback")) && args.getOperationResult().isSuccess()) {
            this.getView().updateView();
        }
    }

    private void setRedeemDateSection() {
        DynamicObject depositBill = (DynamicObject)this.getModel().getValue("finbillno");
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return;
        }
        Date intDate = depositBill.getDate("intdate");
        Date lastRedeemDate = depositBill.getDate("lastredeemdate");
        Date minDate = EmptyUtil.isEmpty((Object)lastRedeemDate) ? intDate : (intDate.compareTo(lastRedeemDate) > 0 ? intDate : lastRedeemDate);
        DateEdit redeemDateEdit = (DateEdit)this.getControl("redeemdate");
        redeemDateEdit.setMinDate(DateUtils.getNextDay((Date)minDate, (int)1));
    }

    private void setReleaseTypeComboItem() {
        DynamicObject investvarieties = (DynamicObject)this.getModel().getValue("investvarieties");
        boolean isNotice = InvestTypeEnum.isNotice((String)investvarieties.getString("investtype"));
        ArrayList<ComboItem> releaseTypeList = new ArrayList<ComboItem>(2);
        if (isNotice) {
            releaseTypeList.add(new ComboItem(new LocaleString(ReleaseTypeEnum.agreeon.getName()), ReleaseTypeEnum.agreeon.getValue()));
            releaseTypeList.add(new ComboItem(new LocaleString(ReleaseTypeEnum.temporary.getName()), ReleaseTypeEnum.temporary.getValue()));
        } else {
            releaseTypeList.add(new ComboItem(new LocaleString(ReleaseTypeEnum.inadvance.getName()), ReleaseTypeEnum.inadvance.getValue()));
            releaseTypeList.add(new ComboItem(new LocaleString(ReleaseTypeEnum.expire.getName()), ReleaseTypeEnum.expire.getValue()));
        }
        ((ComboEdit)this.getControl("releasetype")).setComboItems(releaseTypeList);
        this.getView().setEnable(Boolean.valueOf(isNotice), new String[]{"releasetype"});
    }

    private boolean redeemDateChgEvt() {
        DynamicObject depositF7 = (DynamicObject)this.getModel().getValue("finbillno");
        DynamicObject investVar = (DynamicObject)this.getModel().getValue("investvarieties");
        Date redeemDate = (Date)this.getModel().getValue("redeemdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{depositF7, investVar, redeemDate})) {
            return false;
        }
        if (InvestTypeEnum.isFixed((String)investVar.getString("investtype"))) {
            Date expireDate = depositF7.getDate("expiredate");
            if (redeemDate.compareTo(expireDate) < 0) {
                this.getModel().setValue("releasetype", (Object)ReleaseTypeEnum.inadvance.getValue());
            } else {
                this.getModel().setValue("releasetype", (Object)ReleaseTypeEnum.expire.getValue());
            }
        }
        this.reCalInterest();
        return true;
    }

    private void reCalInterest() {
        Date redeemDate;
        if (!((Boolean)this.getModel().getValue("isrevenue")).booleanValue()) {
            this.getModel().setValue("predictinstamt", null);
            this.getModel().setValue("totalamount", this.getModel().getValue("amount"));
            this.getModel().deleteEntryData("entrys");
            return;
        }
        DynamicObject depositF7 = (DynamicObject)this.getModel().getValue("finbillno");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{depositF7, redeemDate = (Date)this.getModel().getValue("redeemdate")})) {
            return;
        }
        String releaseType = (String)this.getModel().getValue("releasetype");
        boolean useDemandRate = DepositHelper.judgeUseDemandRate((DynamicObject)depositF7, (String)releaseType, (Date)redeemDate);
        boolean isRevenue = (Boolean)this.getModel().getValue("isrevenue");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isRevenue, (String[])new String[]{"realrevenue"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (isRevenue && useDemandRate ? 1 : 0) != 0, (String[])new String[]{"demandrate"});
        IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt((DynamicObject)this.getModel().getDataEntity(true));
        BigDecimal rateAmt = intBillInfo.getAmount().setScale(((DynamicObject)this.getModel().getValue("currency")).getInt("amtprecision"), RoundingMode.HALF_UP);
        this.getModel().setValue("predictinstamt", (Object)rateAmt);
        this.getModel().setValue("realrevenue", (Object)rateAmt);
        this.getModel().setValue("totalamount", (Object)((BigDecimal)this.getModel().getValue("amount")).add(rateAmt));
        DepositHelper.addRevenueCalDetailEntry((DynamicObjectCollection)this.getModel().getEntryEntity("entrys"), (List)intBillInfo.getDetails());
        this.getView().updateView("entrys");
        this.setRedepositAmount(depositF7);
    }

    private void amountChgEvt(Object oldValue) {
        BigDecimal surPlusAmount;
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        if (amount.compareTo(surPlusAmount = (BigDecimal)this.getModel().getValue("surplusamount")) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89e3\u6d3b\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53ef\u89e3\u6d3b\u91d1\u989d\u3002", (String)"BizDealReleaseEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount", (Object)oldValue);
            return;
        }
        this.reCalInterest();
    }

    private void setRedepositAmount(DynamicObject depositBill) {
        String expireRedeposit = (String)this.getModel().getValue("expireredeposit");
        BigDecimal depositSurplusAmt = depositBill.getBigDecimal("surplusamount");
        BigDecimal reDepositAmt = BigDecimal.ZERO;
        if ("principalredeposit".equals(expireRedeposit)) {
            reDepositAmt = depositSurplusAmt;
        } else if ("principalintredeposit".equals(expireRedeposit)) {
            reDepositAmt = depositSurplusAmt.add((BigDecimal)this.getModel().getValue("realrevenue"));
        }
        this.getModel().setValue("redepositamount", (Object)reDepositAmt);
    }

    private void expirereDepositChgEvt() {
        this.reCalInterest();
        this.initViewInfo();
    }

    private void realRevenueChgEvt() {
        BigDecimal realRevenue = (BigDecimal)this.getModel().getValue("realrevenue");
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        this.getModel().setValue("totalamount", (Object)realRevenue.add(amount));
    }

    private void initViewInfo() {
        ArrayList<String> mustInputFeilds = new ArrayList<String>(16);
        mustInputFeilds.add("amount");
        mustInputFeilds.add("redeemdate");
        mustInputFeilds.add("releasetype");
        mustInputFeilds.add("isrevenue");
        String applyType = (String)this.getModel().getValue("applytype");
        String releaseType = (String)this.getModel().getValue("releasetype");
        if (StringUtils.equals((CharSequence)applyType, (CharSequence)"release") && StringUtils.equals((CharSequence)releaseType, (CharSequence)"expire")) {
            mustInputFeilds.add("expireredeposit");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"expireredeposit", "redepositamount"});
        } else {
            this.getModel().setValue("expireredeposit", null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"expireredeposit", "redepositamount"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"expireredeposit"});
        }
        boolean isRevenue = (Boolean)this.getModel().getValue("isrevenue");
        if (isRevenue) {
            mustInputFeilds.add("demandrate");
            mustInputFeilds.add("predictinstamt");
            mustInputFeilds.add("realrevenue");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"fs_revenue", "demandrate", "predictinstamt", "realrevenue"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fs_revenue", "demandrate", "predictinstamt", "realrevenue"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"demandrate", "predictinstamt", "realrevenue"});
        }
        String expireRedeposit = (String)this.getModel().getValue("expireredeposit");
        if (StringUtils.equals((CharSequence)expireRedeposit, (CharSequence)"principalredeposit") || StringUtils.equals((CharSequence)expireRedeposit, (CharSequence)"principalintredeposit")) {
            mustInputFeilds.add("redepositamount");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"redepositamount"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"redepositamount"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"redepositamount"});
            this.getModel().setValue("redepositamount", (Object)0);
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])mustInputFeilds.toArray(new String[0]));
    }

    private void releaseTypeChgEvt() {
        this.reCalInterest();
        this.initViewInfo();
        this.setAmountView(false);
    }

    private void setAmountView(boolean isFirstLoad) {
        String releaseType = (String)this.getModel().getValue("releasetype");
        boolean isExpireType = StringUtils.equals((CharSequence)releaseType, (CharSequence)ReleaseTypeEnum.expire.getValue());
        this.getView().setEnable(Boolean.valueOf(!isExpireType), new String[]{"amount"});
        if (isExpireType && !isFirstLoad) {
            DynamicObject deposit = (DynamicObject)this.getModel().getValue("finbillno");
            deposit = TmcDataServiceHelper.loadSingle((String)"ifm_deposit", (String)"surplusamount", (QFilter[])new QFilter[]{new QFilter("id", "=", deposit.getPkValue())});
            this.getModel().setValue("amount", (Object)deposit.getBigDecimal("surplusamount"));
        }
    }

    private void initExpirereDptComb() {
        ComboEdit expirereDptComb = (ComboEdit)this.getControl("expireredeposit");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(4);
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u7eed\u5b58", (String)"BizDealDepositEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0])), "noredeposit"));
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u672c\u91d1\u7eed\u5b58", (String)"BizDealDepositEdit_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0])), "principalredeposit"));
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u672c\u606f\u7eed\u5b58", (String)"BizDealDepositEdit_4", (String)"tmc-ifm-formplugin", (Object[])new Object[0])), "principalintredeposit"));
        expirereDptComb.setComboItems(comboItems);
    }
}

