/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.deposit.bizdeal;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.DepositHelper;

public class BizDealReveneEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"realrevenue"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "revenuedate": {
                this.reSetRevenueEntry();
                this.getView().setVisible(Boolean.valueOf(this.getDemandRateBoolean()), new String[]{"demandrate"});
                this.calRealRate();
                break;
            }
            case "realrevenue": {
                this.calRealRate();
                break;
            }
        }
    }

    private void reSetRevenueEntry() {
        Date endDate = (Date)this.getModel().getValue("revenuedate");
        Date startDate = (Date)this.getModel().getValue("prestartdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate})) {
            return;
        }
        DynamicObject finBillno = (DynamicObject)this.getModel().getValue("finbillno");
        if (null == finBillno) {
            return;
        }
        DynamicObject depositBill = TmcDataServiceHelper.loadSingleFromCache((String)"cim_deposit", (QFilter[])new QFilter[]{new QFilter("id", "=", finBillno.getPkValue())});
        IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt((DynamicObject)depositBill, (Date)startDate, (Date)endDate);
        this.resetRevenueEntry(intBillInfo);
    }

    private void resetRevenueEntry(IntBillInfo intBillInfo) {
        if (EmptyUtil.isEmpty((Object)intBillInfo)) {
            return;
        }
        this.getModel().setValue("prestartdate", (Object)intBillInfo.getBeginDate());
        this.getModel().setValue("prestenddate", (Object)intBillInfo.getEndDate());
        this.getModel().setValue("predictinstamt", (Object)intBillInfo.getAmount());
        this.getModel().setValue("realrevenue", (Object)intBillInfo.getAmount());
        DepositHelper.setRevenueEntry((DynamicObject)this.getModel().getDataEntity(true), (IntBillInfo)intBillInfo);
        this.getView().updateView("entrys");
    }

    private boolean getDemandRateBoolean() {
        String revenueSort = (String)this.getModel().getValue("revenuesort");
        boolean scene1 = StringUtils.equals((CharSequence)"redeem_revenue", (CharSequence)revenueSort);
        Date bizDate = (Date)this.getModel().getValue("revenuedate");
        if (EmptyUtil.isEmpty((Object)bizDate)) {
            return scene1;
        }
        DynamicObject depositBill = (DynamicObject)this.getModel().getValue("finbillno");
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return scene1;
        }
        depositBill = TmcDataServiceHelper.loadSingleFromCache((String)"cim_deposit", (QFilter[])new QFilter[]{new QFilter("id", "=", depositBill.getPkValue())});
        String investType = Optional.ofNullable(depositBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        boolean scene2 = StringUtils.equals((CharSequence)"revenue", (CharSequence)revenueSort) && InvestTypeEnum.isFixed((String)investType) && bizDate.compareTo(depositBill.getDate("expiredate")) > 0;
        return scene1 || scene2;
    }

    private void calRealRate() {
        BigDecimal revenueAmt = (BigDecimal)this.getModel().getValue("realrevenue");
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entrys");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{revenueAmt, rows})) {
            this.getModel().setValue("revenuerate", null);
            return;
        }
        this.getModel().setValue("revenuerate", (Object)DepositHelper.calcRealRate((DynamicObjectCollection)rows, (BigDecimal)revenueAmt));
    }
}

