/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.deposit.bizdeal;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.ifm.enums.DepositBizDealType;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;

public class DepositBizDealList
extends AbstractTmcListPlugin {
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        this.initFormId(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"beforeback", (CharSequence)operateKey)) {
            Long selectedId = this.getSelectedId();
            if (EmptyUtil.isEmpty((Long)selectedId)) {
                args.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)"pushbizbill", (CharSequence)operateKey)) {
            this.doValidatorBeforPushBizBill(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"beforeback") && evt.getOperationResult().isSuccess()) {
            this.doBeforeChargeBack(evt.getOperationResult().getSuccessPkIds().get(0));
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"beforeback")) {
            ((BillList)this.getControl("billlistap")).refreshData();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        HashMap returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"closecallback_chargeback") && EmptyUtil.isNoEmpty((Object)(returnData = (HashMap)event.getReturnData()))) {
            String backDescr = (String)returnData.get("reason");
            this.chargeBack(backDescr);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        DynamicObject defaultSettleCenter = this.getDefaultSettleCenter();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (fieldName.startsWith("finorginfo.")) {
                if (null == defaultSettleCenter) continue;
                commonFilter.setDefaultValue(defaultSettleCenter.getString("id"));
                continue;
            }
            if (!fieldName.startsWith("org.")) continue;
            commonFilter.setDefaultValue(null);
        }
    }

    protected List<QFilter> addCustomFilterForFilterCol(String fieldName) {
        if (StringUtils.equals((CharSequence)"product.name", (CharSequence)fieldName)) {
            return Collections.singletonList(new QFilter("servicecategory", "in", (Object)new String[]{"A", "C"}));
        }
        return super.addCustomFilterForFilterCol(fieldName);
    }

    private void doBeforeChargeBack(Object selectId) {
        if (this.volidateBeforeChargeBack(selectId)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ifm_chargeback_comments");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "closecallback_chargeback");
            formShowParameter.setCloseCallBack(callBack);
            this.getView().showForm(formShowParameter);
        }
    }

    private void chargeBack(String backDescr) {
        DynamicObject[] bizDeals;
        List selectIds = this.getSelectedIdList();
        QFilter filter = new QFilter("id", "in", (Object)selectIds);
        for (DynamicObject bizDeal : bizDeals = BusinessDataServiceHelper.load((String)"ifm_bizdealbill_deposit", (String)"id,billno,billstatus,sourcebillno,bizstatus,dealopinion,dealuser,dealdate,apply,applybillno", (QFilter[])filter.toArray())) {
            bizDeal.set("dealopinion", (Object)backDescr);
        }
        OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"chargeback", (String)"ifm_bizdealbill_deposit", (DynamicObject[])bizDeals, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u5355\u6210\u529f\u3002", (String)"PayAcceptanceBillListPlugin_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9000\u5355\u5931\u8d25\u3002", (String)"PayAcceptanceBillListPlugin_4", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
        ((BillList)this.getControl("billlistap")).refreshData();
    }

    private boolean volidateBeforeChargeBack(Object selectId) {
        DynamicObject bizDeal = TmcDataServiceHelper.loadSingle((String)"ifm_bizdealbill_deposit", (String)"billstatus,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", selectId)});
        if (!StringUtils.equals((CharSequence)bizDeal.getString("billstatus"), (CharSequence)BillStatusEnum.SAVE.getValue())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u5141\u8bb8\u9000\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"DepositBizDealList_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!StringUtils.equals((CharSequence)bizDeal.getString("bizstatus"), (CharSequence)"A")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5185\u90e8\u5b58\u6b3e\u53d7\u7406\u5df2\u9000\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"DepositBizDealList_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void doValidatorBeforPushBizBill(BeforeDoOperationEventArgs args) {
        DynamicObject finBill;
        Long selectedId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)selectedId)) {
            args.setCancel(true);
            return;
        }
        Long bizDealId = (Long)this.getSelectedIdList().get(0);
        DynamicObject bizDealBill = TmcDataServiceHelper.loadSingle((String)"ifm_bizdealbill_deposit", (String)"finbillno,amount,billstatus,", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizDealId)});
        if (!StringUtils.equals((CharSequence)bizDealBill.getString("billstatus"), (CharSequence)BillStatusEnum.AUDIT.getValue())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u7684\u5185\u90e8\u5b58\u6b3e\u53d7\u7406\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"DepositBizDealList_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        BigDecimal amount = bizDealBill.getBigDecimal("amount");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, finBill = bizDealBill.getDynamicObject("finbillno")})) {
            return;
        }
        BigDecimal surplusAmount = finBill.getBigDecimal("surplusamount");
        if (null != amount && null != surplusAmount && amount.compareTo(surplusAmount) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5185\u90e8\u5b58\u6b3e\u53d7\u7406\u7684\u89e3\u6d3b\u91d1\u989d\u5927\u4e8e\u53ef\u89e3\u6d3b\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"DepositBizDealList_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void initFormId(BeforeShowBillFormEvent e) {
        BillList billListAp = (BillList)this.getView().getControl("billlistap");
        Object pkValue = billListAp.getFocusRowPkId();
        if (EmptyUtil.isEmpty((Object)pkValue)) {
            return;
        }
        DynamicObject bizDeal = TmcDataServiceHelper.loadSingle((String)"ifm_bizdealbill_deposit", (String)"applytype", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
        String applyType = bizDeal.getString("applytype");
        String formId = "ifm_bizdealbill_deposit";
        if (StringUtils.equals((CharSequence)DepositBizDealType.DEPOSIT.getValue(), (CharSequence)applyType)) {
            formId = "ifm_bizdealbill_dpt";
        } else if (StringUtils.equals((CharSequence)DepositBizDealType.RELEASE.getValue(), (CharSequence)applyType)) {
            formId = "ifm_bizdealbill_rel";
        } else if (StringUtils.equals((CharSequence)DepositBizDealType.REVENUE.getValue(), (CharSequence)applyType)) {
            formId = "ifm_bizdealbill_rev";
        }
        e.getParameter().setFormId(formId);
    }

    private DynamicObject getDefaultSettleCenter() {
        QFilter qFilter = new QFilter("scorg.id", "=", (Object)RequestContext.get().getOrgId());
        Object[] settleCenters = TmcDataServiceHelper.load((String)"ifm_settcentersetting", (String)"settlecenter", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty((Object[])settleCenters)) {
            return settleCenters[0].getDynamicObject("settlecenter");
        }
        List settleCenterIds = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)RequestContext.get().getCurrUserId(), (String)TmcAppEnum.IFM.getValue(), (String)"ifm_subsidiaryledger", (String)"47150e89000000ac");
        if (EmptyUtil.isNoEmpty((Object)settleCenterIds)) {
            return TmcDataServiceHelper.loadSingleFromCache(settleCenterIds.get(0), (String)"bd_finorginfo");
        }
        return null;
    }
}

