/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.deposit.deal;

import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.enums.BalanceTypeEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.BizBalanceModelHelper;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.DepositHelper;

public class InnerDepositDealEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit settleAccount = (BasedataEdit)this.getControl("settleaccount");
        if (EmptyUtil.isNoEmpty((Object)settleAccount)) {
            settleAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit finOrgInfo = (BasedataEdit)this.getControl("finorginfo");
        finOrgInfo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit product = (BasedataEdit)this.getControl("product");
        product.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit finAccountF7 = (BasedataEdit)this.getControl("finaccountf7");
        finAccountF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldName;
        switch (fieldName = event.getProperty().getName()) {
            case "settleaccount": {
                this.setAccountFilter(event);
                break;
            }
            case "finorginfo": {
                this.setFinOrgFilter(event);
                break;
            }
            case "product": {
                this.setProductFilter(event);
                break;
            }
            case "finaccountf7": {
                this.setFinAccountF7Filter(event);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "product": {
                this.productChgEvt();
                break;
            }
            case "finorginfo": {
                this.finOrgInfoChgEvt();
                break;
            }
            case "currency": {
                this.currencyChgEvt();
                this.setBankBalance();
                break;
            }
            case "finaccount": {
                this.finAccountChgEvt();
                break;
            }
            case "org": {
                this.orgChgEvt();
                this.setBankBalance();
                break;
            }
            case "settleaccount": {
                this.settleaccountChgEvt();
                this.setBankBalance();
                break;
            }
        }
    }

    private void settleaccountChgEvt() {
        DynamicObject settleaccount = (DynamicObject)this.getModel().getValue("settleaccount");
        if (EmptyUtil.isEmpty((DynamicObject)settleaccount)) {
            return;
        }
        DynamicObject accountbank = TmcDataServiceHelper.loadSingle((Object)settleaccount.getPkValue(), (String)"bd_accountbanks");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            DynamicObject openorg = accountbank.getDynamicObject("openorg");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"org", (Object)openorg);
        }
    }

    private void orgChgEvt() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settleaccount", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"finaccount", null);
    }

    private void productChgEvt() {
        DynamicObject product = (DynamicObject)this.getModel().getValue("product");
        if (EmptyUtil.isEmpty((DynamicObject)product)) {
            this.getModel().setValue("investvarieties", null);
            this.clearAccountProp();
            return;
        }
        String rateType = product.getString("ratetype");
        this.getModel().setValue("interesttype", (Object)rateType);
        if (StringUtils.equals((CharSequence)rateType, (CharSequence)"fixed")) {
            this.getModel().setValue("interestrate", (Object)product.getBigDecimal("productprice"));
        } else if (StringUtils.equals((CharSequence)rateType, (CharSequence)"float")) {
            this.getModel().setValue("referencerate", (Object)product.getDynamicObject("referrate"));
            this.getModel().setValue("ratesign", (Object)product.getString("ratesignbp"));
            this.getModel().setValue("ratefloatpoint", (Object)product.getBigDecimal("ratefloatpoints"));
        }
        DynamicObject currency = product.getDynamicObject("currency");
        this.getModel().setValue("currency", (Object)currency);
        DynamicObject investVarieties = TmcDataServiceHelper.loadSingleFromCache((String)"cim_investvarieties", (QFilter[])new QFilter("number", "=", (Object)product.getString("number")).toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)investVarieties)) {
            this.getModel().setValue("investvarieties", investVarieties.getPkValue());
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("finorginfo"))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"finorginfo", (Object)product.getDynamicObject("center"));
        }
    }

    private void finOrgInfoChgEvt() {
        this.clearAccountProp();
        this.getModel().setValue("product", null);
        this.setScOrg();
    }

    private static boolean isScFinOrg(DynamicObject finOrgInfo) {
        if (null == finOrgInfo) {
            return false;
        }
        finOrgInfo = QueryServiceHelper.queryOne((String)"bd_finorginfo", (String)"finorgtype.type", (QFilter[])new QFilter[]{new QFilter("id", "=", finOrgInfo.get("id"))});
        return StringUtils.equals((CharSequence)finOrgInfo.getString("finorgtype.type"), (CharSequence)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
    }

    private void currencyChgEvt() {
        DynamicObject finAccount;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            return;
        }
        long currencyId = currency.getLong("id");
        DynamicObject settleAccount = (DynamicObject)this.getModel().getValue("settleaccount");
        if (!DepositHelper.isContainCurrency((DynamicObject)settleAccount, (long)currencyId)) {
            this.getModel().setValue("settleaccount", null);
        }
        if (!DepositHelper.isContainCurrency((DynamicObject)(finAccount = (DynamicObject)this.getModel().getValue("finaccountf7")), (long)currencyId)) {
            this.getModel().setValue("finaccountf7", null);
            this.getModel().setValue("finaccount", null);
        }
    }

    private void finAccountChgEvt() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("finaccount"))) {
            this.getModel().setValue("finaccountf7", null);
        }
    }

    private void setAccountFilter(BeforeF7SelectEvent event) {
        DynamicObject finAccount;
        if (event.isCancel()) {
            return;
        }
        QFilter qFilter = new QFilter("acctstatus", "=", (Object)"normal");
        qFilter.and(new QFilter("acctclassify", "=", (Object)"I"));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!("ifm_deposit".equals(formId) || "ifm_deposit_init".equals(formId) || "ifm_notice_deposit".equals(formId) || "ifm_noticedeposit_init".equals(formId) || !EmptyUtil.isEmpty((DynamicObject)org))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b58\u6b3e\u7ec4\u7ec7\u201d\u3002", (String)"InnerDepositDealEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("product"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b58\u6b3e\u4ea7\u54c1\u201d\u3002", (String)"InnerDepositDealEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        DynamicObject finOrg = (DynamicObject)this.getModel().getValue("finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)finOrg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b58\u6b3e\u673a\u6784\u201d\u3002", (String)"InnerDepositDealEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        qFilter.and(new QFilter("bank", "=", finOrg.getPkValue()));
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            qFilter.and(new QFilter("currency.fbasedataid.id", "=", currency.getPkValue()));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(finAccount = (DynamicObject)this.getModel().getValue("finaccountf7")))) {
            qFilter.and(new QFilter("id", "!=", finAccount.getPkValue()));
        }
        if (!EmptyUtil.isEmpty((DynamicObject)org)) {
            qFilter.and(new QFilter("openorg", "=", org.getPkValue()));
        }
        ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    private void setFinOrgFilter(BeforeF7SelectEvent event) {
        String appId = this.getView().getFormShowParameter().getAppId();
        String entity = this.getModel().getDataEntityType().getName();
        Set bankIds = SettleCenterHelper.hasPermissionSettleCenter((String)appId, (String)entity, (String)"47156aff000000ac");
        QFilter qFilter = new QFilter("id", "in", (Object)bankIds);
        ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    private void setProductFilter(BeforeF7SelectEvent event) {
        DynamicObject finOrgInfo = (DynamicObject)this.getModel().getValue("finorginfo");
        if (EmptyUtil.isNoEmpty((DynamicObject)finOrgInfo)) {
            QFilter filter = new QFilter("center", "=", finOrgInfo.getPkValue());
            ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters().add(filter);
        }
    }

    private void setFinAccountF7Filter(BeforeF7SelectEvent event) {
        if (event.isCancel()) {
            return;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("product"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b58\u6b3e\u4ea7\u54c1\u201d\u3002", (String)"InnerDepositDealEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        QFilter qFilter = new QFilter("currency.fbasedataid.id", "=", currency.getPkValue());
        DynamicObject settleAccount = (DynamicObject)this.getModel().getValue("settleaccount");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleAccount)) {
            qFilter.and(new QFilter("id", "!=", settleAccount.getPkValue()));
        }
        ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    private void clearAccountProp() {
        this.getModel().setValue("currency", null);
        this.getModel().setValue("settleaccount", null);
        this.getModel().setValue("finaccount", null);
        this.getModel().setValue("finaccountf7", null);
    }

    public void afterCreateNewData(EventObject e) {
        this.setDefaultCenter();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setScOrg();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBankBalance();
    }

    private void setScOrg() {
        DynamicObject finOrgInfo = (DynamicObject)this.getModel().getValue("finorginfo");
        if (InnerDepositDealEdit.isScFinOrg(finOrgInfo)) {
            DynamicObject scOrg = finOrgInfo.getDynamicObject("org");
            if (null != scOrg) {
                this.getModel().setValue("scorg", (Object)scOrg);
            }
        } else {
            this.getModel().setValue("scorg", null);
        }
    }

    private void setDefaultCenter() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!(formId.equals("ifm_deposit") || formId.equals("ifm_deposit_init") || "ifm_notice_deposit".equals(formId) || "ifm_noticedeposit_init".equals(formId))) {
            return;
        }
        long orgId = RequestContext.get().getOrgId();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"id,number,name,org,finorgtype.type", (QFilter[])new QFilter[]{orgFilter});
        if (!EmptyUtil.isEmpty((DynamicObject)org) && FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(org.getString("finorgtype.type"))) {
            this.getModel().setValue("finorginfo", (Object)org);
            this.getModel().setValue("org", null);
        } else {
            this.getModel().setValue("org", (Object)orgId);
            this.getModel().setValue("finorginfo", null);
        }
    }

    private void setBankBalance() {
        if (this.getView().getControl("curbalance") == null) {
            return;
        }
        DynamicObject bankAccount = (DynamicObject)this.getModel().getValue("settleaccount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)bankAccount) && EmptyUtil.isNoEmpty((DynamicObject)currency) && this.getView().getControl("curbalance") != null) {
            Long acctBankId = bankAccount.getLong("id");
            Long currencyId = currency.getLong("id");
            BizBalanceModelBean balance = BizBalanceModelHelper.getRunningBalance((String)BalanceTypeEnum.BALANCE.getValue(), (long)acctBankId, (long)currencyId);
            if (balance != null && balance.getAmount() != null) {
                this.getModel().setValue("curbalance", (Object)balance.getAmount());
            } else {
                this.getModel().setValue("curbalance", null);
            }
        }
    }
}

