/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.extintobject;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.formplugin.intobject.IntObjectBaseEdit;

public class ExtIntBeaObjectEdit
extends IntObjectBaseEdit
implements BeforeF7SelectListener,
ClickListener {
    public static final String CHANGE_INTOBJECT_CALLBACK = "change_intobject_callback";
    public static final String BATCHSAVE_CALLBACK = "batchsave_callback";
    public static final String CHANGE_INTOBJECT_OLD = "change_intobjectold";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBeforeF7SelectListener("org", "intobject", "referrate", "accountorg");
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("accountorg", null);
        this.setDefaultOrg();
        this.setCurrency();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initModelView();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "intobject": {
                this.intobjectChgEvt(e);
                break;
            }
            case "org": {
                this.orgChgEvt();
                break;
            }
            case "accountorg": {
                this.AccountOrgChgEvt();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (callBackId.equals(CHANGE_INTOBJECT_CALLBACK)) {
            if (result == MessageBoxResult.Yes) {
                String newValue = this.getPageCache().get(CHANGE_INTOBJECT_CALLBACK);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intobject", (Object)newValue);
                this.getPageCache().remove(CHANGE_INTOBJECT_CALLBACK);
            } else {
                String oldData = this.getPageCache().get(CHANGE_INTOBJECT_OLD);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intobject", (Object)oldData);
                this.getPageCache().remove(CHANGE_INTOBJECT_OLD);
            }
        } else if (callBackId.equals(BATCHSAVE_CALLBACK) && result == MessageBoxResult.Yes) {
            this.getView().invokeOperation("batchsave");
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    private void orgChgEvt() {
        Set<Long> accountOrgs;
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"accountorg", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intobject", null);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org) && EmptyUtil.isNoEmpty(accountOrgs = this.getAccountOrgIds(org)) && accountOrgs.size() == 1) {
            this.getModel().setValue("accountorg", (Object)accountOrgs.iterator().next());
        }
        this.setCurrency();
    }

    private void AccountOrgChgEvt() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intobject", null);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName;
        switch (propName = evt.getProperty().getName()) {
            case "intobject": {
                this.initAcctControlEvi(evt);
                break;
            }
            case "referrate": {
                this.initReferRateControlEvi(evt);
                break;
            }
            case "accountorg": {
                this.initAccountOrgControlEvi(evt);
                break;
            }
            case "org": {
                this.initCompanyControlEvi(evt);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        OperationResult result = evt.getOperationResult();
        if (null != result && result.isSuccess()) {
            switch (operateKey) {
                case "disable": {
                    this.getModel().setValue("status", (Object)BillStatusEnum.SAVE.getValue());
                    this.getView().setEnable(Boolean.TRUE, ENABLE_KEYS);
                    this.getView().setVisible(Boolean.TRUE, VISIBLE_KEYS);
                    break;
                }
                case "enable": {
                    this.getModel().setValue("status", (Object)BillStatusEnum.AUDIT.getValue());
                    this.getView().setEnable(Boolean.FALSE, ENABLE_KEYS);
                    this.getView().setVisible(Boolean.FALSE, VISIBLE_KEYS);
                    break;
                }
                case "save": {
                    String enable = (String)this.getModel().getValue("enable");
                    this.getView().setVisible(Boolean.valueOf("0".equals(enable)), VISIBLE_KEYS);
                    break;
                }
                case "batchsave": {
                    String isAllLegal = this.getPageCache().get("isAllLegal");
                    if (StringUtils.equals((CharSequence)"false", (CharSequence)isAllLegal)) {
                        this.getView().returnDataToParent((Object)"partsave");
                        break;
                    }
                    this.getView().returnDataToParent((Object)"allsave");
                }
            }
        }
    }

    private void addBeforeF7SelectListener(String ... controls) {
        for (String controlName : controls) {
            BasedataEdit controlF7 = (BasedataEdit)this.getControl(controlName);
            controlF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void initAcctControlEvi(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        qFilters.clear();
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
        if (EmptyUtil.isEmpty((DynamicObject)accountorg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ExtIntObjectEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        qFilters.add(TmcAccountHelper.getAccountBankFilterByOrg((Long)accountorg.getLong("id")));
        qFilters.add(new QFilter("acctclassify", "=", (Object)"B"));
    }

    private void initReferRateControlEvi(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        DynamicObject intCurrency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isEmpty((DynamicObject)intCurrency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"ExtIntObjectEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"startintdate")) {
            evt.setCancel(true);
            return;
        }
        QFilter qfilter = new QFilter("currency", "=", intCurrency.getPkValue());
        qFilters.add(qfilter);
    }

    private void initAccountOrgControlEvi(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            qFilters.add(new QFilter("id", "=", (Object)0));
            return;
        }
        Set<Long> accountOrgIds = this.getAccountOrgIds(org);
        if (EmptyUtil.isEmpty(accountOrgIds)) {
            qFilters.add(new QFilter("id", "=", (Object)0));
            return;
        }
        qFilters.add(new QFilter("id", "in", accountOrgIds));
    }

    private void initCompanyControlEvi(BeforeF7SelectEvent evt) {
        Long userPK = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authorizedBankOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)"ifm_extintobject", (String)"47156aff000000ac");
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)authorizedBankOrgIds));
    }

    private void intobjectChgEvt(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        if (oldValue == null) {
            this.getPageCache().put(CHANGE_INTOBJECT_OLD, null);
            this.getModel().setValue("intinneracct", changeData.getNewValue());
            return;
        }
        this.getModel().setValue("intinneracct", changeData.getNewValue());
        this.getPageCache().put(CHANGE_INTOBJECT_OLD, ((DynamicObject)oldValue).getPkValue().toString());
        Object propValue = changeData.getNewValue();
        if (propValue == null) {
            this.getPageCache().put(CHANGE_INTOBJECT_CALLBACK, null);
            return;
        }
        this.getPageCache().put(CHANGE_INTOBJECT_CALLBACK, ((DynamicObject)propValue).getPkValue().toString());
        ConfirmCallBackListener listener = new ConfirmCallBackListener(CHANGE_INTOBJECT_CALLBACK, (IFormPlugin)this);
        String confirmMsg = ResManager.loadKDString((String)"\u8ba1\u606f\u5bf9\u8c61\u5207\u6362\uff0c\u5c06\u6e05\u9664\u90e8\u5206\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"ExtIntBeaObjectEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, ConfirmTypes.Default, listener);
    }

    private void setDefaultOrg() {
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("org"))) {
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        DynamicObject currentPermOrg = TmcOrgDataHelper.getCurrentPermOrg((String)appId, (String)"ifm_extintobject", (String)"47156aff000000ac");
        this.getModel().setValue("org", (Object)currentPermOrg);
    }

    private void setCurrency() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)org.getLong("id"));
        this.getModel().setValue("currency", (Object)baseCurrency);
    }

    private Set<Long> getAccountOrgIds(DynamicObject org) {
        HashSet accountId = new HashSet(16);
        Long orgId = org.getLong("id");
        List accountOrgIds = OrgUnitServiceHelper.getFromOrgs((String)"08", (Long)orgId, (String)"10");
        if (org.getBoolean("fisaccounting")) {
            accountOrgIds.add(orgId);
        }
        Set<Long> collect = accountOrgIds.stream().filter(accountId::add).collect(Collectors.toSet());
        return collect;
    }

    private void initModelView() {
        boolean isSingle = "ifm_extintobject".equals(this.getView().getFormShowParameter().getFormId());
        if (isSingle && this.checkupdate()) {
            String enable = (String)this.getModel().getValue("enable");
            boolean isDisable = "0".equals(enable);
            this.getView().setVisible(Boolean.valueOf(isDisable), VISIBLE_KEYS);
            this.getView().setEnable(Boolean.valueOf(isDisable), ENABLE_KEYS);
        }
    }

    private boolean checkupdate() {
        DynamicObject exitIntObject = BusinessDataServiceHelper.loadSingle((String)"ifm_extintobject", (String)"id,lastintdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getModel().getDataEntity().getLong("id"))});
        return EmptyUtil.isNoEmpty((DynamicObject)exitIntObject);
    }
}

