/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.home;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.format.FormatObject;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.InnerAcctStatusEnum;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;
import kd.tmc.ifm.helper.LspWapper;
import org.apache.commons.lang.StringUtils;

public class DepositsCardPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private String labCurrencySign;
    private int currencyAmtprecision;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"refresh_btn", "refreshall_btn", "lookupjournal_btn", "lookuptransaction_btn", "addaccountbank_btn", "closeup_btn", "open_btn"});
        this.addClickListeners(new String[]{"add_pic", "add_label", "delete"});
        BasedataEdit accountF7 = (BasedataEdit)this.getControl("accountbankf7");
        accountF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<DynamicObject> userSettings = this.getUserSetting();
        ArrayList<Long> acctBankIds = new ArrayList<Long>(userSettings.size());
        for (DynamicObject userSetting : userSettings) {
            Long acctBankId = userSetting.getLong("accountbank.id");
            acctBankIds.add(acctBankId);
        }
        this.addAttentionCard(acctBankIds);
        this.getView().setVisible(Boolean.FALSE, new String[]{"lastupdatetime", "open_btn"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "addaccountbank_btn": 
            case "add_pic": 
            case "add_label": {
                BasedataEdit acctBankF7 = (BasedataEdit)this.getControl("accountbankf7");
                acctBankF7.click();
                break;
            }
            case "refresh_btn": {
                this.refreshSingle();
                break;
            }
            case "refreshall_btn": {
                this.refreshAll();
                break;
            }
            case "delete": {
                this.confirmBeforeDelete();
                break;
            }
            case "lookupjournal_btn": {
                this.lookUpJournal();
                break;
            }
            case "lookuptransaction_btn": {
                this.lookUpTransDetail();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && "delete".equals(callBackId)) {
            this.deleteAttentionItem();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if ("accountbankf7".equals(key)) {
            this.acctBankChanged(newValue);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (propName) {
            case "accountbankf7": {
                List qFilters = formShowParameter.getListFilterParameter().getQFilters();
                String appId = this.getView().getFormShowParameter().getAppId();
                List settleIds = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"ifm_inneracct", (String)"47150e89000000ac");
                QFilter settleFilter = new QFilter("finorg", "in", (Object)settleIds);
                qFilters.add(settleFilter);
                QFilter acctStatusFilter = new QFilter("acctstatus", "=", (Object)InnerAcctStatusEnum.NORMAL.getValue());
                qFilters.add(acctStatusFilter);
                break;
            }
        }
    }

    private List<DynamicObject> getUserSetting() {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject[] userSettings = BusinessDataServiceHelper.load((String)"ifm_deposits_setting", (String)"user,accountbank,currency,order", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
        ArrayList<DynamicObject> attentionSettings = new ArrayList<DynamicObject>(userSettings.length);
        attentionSettings.addAll(Arrays.asList(userSettings));
        return attentionSettings;
    }

    private void acctBankChanged(Object newValue) {
        if (newValue != null) {
            DynamicObjectCollection acctBanks = (DynamicObjectCollection)newValue;
            ArrayList<Long> acctBankIds = new ArrayList<Long>(acctBanks.size());
            for (DynamicObject row : acctBanks) {
                row = row.getDynamicObject("fbasedataid");
                this.saveAttentionSetting(row);
                acctBankIds.add(row.getLong("id"));
            }
            this.addAttentionCard(acctBankIds);
            this.getModel().setValue("accountbankf7", (Object)new Object[0]);
        }
    }

    private void addAttentionCard(List<Long> acctBankIds) {
        DynamicObjectCollection acctBanks = QueryServiceHelper.query((String)"ifm_inneracct", (String)"id,finorg,currency_dflt", (QFilter[])new QFilter[]{new QFilter("id", "in", acctBankIds)});
        if (acctBanks != null && !acctBanks.isEmpty()) {
            Set bankIds = acctBanks.stream().map(o -> o.getLong("finorg")).collect(Collectors.toSet());
            DynamicObjectCollection banks = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,bank_cate", (QFilter[])new QFilter[]{new QFilter("id", "in", bankIds)});
            Map<Long, DynamicObject> idToBankMap = banks.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o, (a, b) -> a));
            QFilter[] filters = new QFilter[]{new QFilter("type", "=", (Object)"finorgimg")};
            DynamicObjectCollection finOrgImgs = QueryServiceHelper.query((String)"cas_settingmapper", (String)"type,key,value", (QFilter[])filters);
            Map<String, DynamicObject> idToFinOrgImgMap = finOrgImgs.stream().collect(Collectors.toMap(o -> o.getString("key"), o -> o, (a, b) -> a));
            for (DynamicObject acctBank : acctBanks) {
                DynamicObject finOrgImg;
                DynamicObject bank = idToBankMap.get(acctBank.getLong("finorg"));
                String url = null;
                if (bank != null && (finOrgImg = idToFinOrgImgMap.get(bank.getString("bank_cate"))) != null) {
                    url = finOrgImg.getString("value");
                }
                this.addAttentionCard(acctBank.getLong("id"), bank, url);
            }
        }
    }

    private void addAttentionCard(Object accountBank, DynamicObject bank, String url) {
        if (accountBank != null && !this.existCard(accountBank)) {
            int newIndex = this.getModel().createNewEntryRow("acctbankcardentry");
            this.getModel().setValue("accountbank", accountBank, newIndex);
            DynamicObject acctBank = null;
            if (accountBank instanceof DynamicObject) {
                acctBank = (DynamicObject)accountBank;
            } else if (accountBank instanceof Long) {
                acctBank = (DynamicObject)this.getModel().getValue("accountbank", newIndex);
            }
            if (acctBank == null) {
                this.getModel().deleteEntryRow("acctbankcardentry", newIndex);
            } else {
                String acctBankNumber;
                this.getModel().setValue("currency", (Object)acctBank.getLong("currency_dflt.id"), newIndex);
                String bankName = acctBank.getString("name");
                this.getModel().setValue("bankname", (Object)bankName, newIndex);
                if (bank != null) {
                    acctBankNumber = url != null ? url : "/images/pc/cardbackground/card_otherbank_280_150.png";
                    String rootUrl = UrlService.getDomainContextUrl();
                    if (rootUrl.endsWith("/")) {
                        rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
                    }
                    this.getModel().setValue("backgroundimg", (Object)(rootUrl + acctBankNumber), newIndex);
                }
                if ((acctBankNumber = acctBank.getString("number")).length() > 4) {
                    acctBankNumber = acctBankNumber.substring(acctBankNumber.length() - 4);
                }
                acctBankNumber = String.format("(%s)", acctBankNumber);
                this.getModel().setValue("banknumber", (Object)acctBankNumber, newIndex);
                DynamicObject bankOrg = acctBank.getDynamicObject("finorg");
                String bankOrgName = null;
                if (EmptyUtil.isNoEmpty((DynamicObject)bankOrg)) {
                    bankOrgName = bankOrg.getLocaleString("name").toString();
                }
                this.getModel().setValue("bankorg", (Object)bankOrgName, newIndex);
                Long currencyId = (Long)((DynamicObject)this.getModel().getValue("currency", newIndex)).getPkValue();
                DynamicObject bdAcctBank = this.getBdIdByInner(acctBank);
                QFilter qFilter = new QFilter("accountbank.id", "=", bdAcctBank.getPkValue()).and("currency", "=", (Object)currencyId).and("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)DateUtils.getCurrentDate(), (boolean)false));
                DynamicObjectCollection balanceInquires = QueryServiceHelper.query((String)"getLastestBalanceInquire", (String)"ifm_accountbalance", (String)"amount,bizdate,modifytime", (QFilter[])qFilter.toArray(), (String)"bizdate desc, modifytime desc", (int)1);
                DynamicObject lastestBalanceInquire = balanceInquires.isEmpty() ? null : (DynamicObject)balanceInquires.get(0);
                this.showBalance(newIndex, lastestBalanceInquire);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"add_card"});
            }
        }
    }

    private DynamicObject getBdIdByInner(DynamicObject innerAcct) {
        QFilter qFilter = new QFilter("inneracct", "=", innerAcct.getPkValue()).and("acctclassify", "=", (Object)"I");
        DynamicObject innerAcctBank = TmcDataServiceHelper.loadSingle((String)"am_accountbank", (String)"id", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObject)innerAcctBank)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u4e0d\u5b58\u5728", (String)"DepositsCardPlugin_5", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
        return innerAcctBank;
    }

    private boolean existCard(Object acctBank) {
        int rowCount = this.getModel().getEntryRowCount("acctbankcardentry");
        Long acctBankId = null;
        if (acctBank instanceof DynamicObject) {
            acctBankId = Long.valueOf(((DynamicObject)acctBank).getPkValue().toString());
        } else if (acctBank instanceof Long) {
            acctBankId = (Long)acctBank;
        }
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject entryAccountBank = (DynamicObject)this.getModel().getValue("accountbank", i);
            if (entryAccountBank == null || acctBankId == null || !acctBankId.equals(entryAccountBank.getLong("id"))) continue;
            return true;
        }
        return false;
    }

    private void showBalance(int newIndex, DynamicObject lastestBalanceInquire) {
        if (lastestBalanceInquire != null) {
            BigDecimal balance = lastestBalanceInquire.getBigDecimal("amount");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", newIndex);
            String balanceStr = this.formatAmount(balance, currency);
            this.getModel().setValue("balance", (Object)balanceStr, newIndex);
            this.initFormat();
            Date lastUpdateTime = lastestBalanceInquire.getDate("modifytime");
            this.getModel().setValue("updatetime", (Object)lastUpdateTime, newIndex);
        }
    }

    private void saveAttentionSetting(DynamicObject acctBank) {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection userSettings = QueryServiceHelper.query((String)"ifm_deposits_setting", (String)"order", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)}, (String)"order");
        int order = 0;
        if (!userSettings.isEmpty()) {
            order = ((DynamicObject)userSettings.get(userSettings.size() - 1)).getInt("order") + 1;
        }
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"ifm_deposits_setting");
        DynamicObject attentionItem = new DynamicObject((DynamicObjectType)dt);
        attentionItem.set("user", (Object)userId);
        attentionItem.set("accountbank", acctBank.getPkValue());
        attentionItem.set("currency", (Object)acctBank.getLong("currency_dflt.id"));
        attentionItem.set("order", (Object)order);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attentionItem});
    }

    private void initFormat() {
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
        fobj.getCurrencyFormat().setCurrencySymbols(this.labCurrencySign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(this.currencyAmtprecision);
    }

    private String formatAmount(BigDecimal amount, DynamicObject currency) {
        amount = amount == null ? new BigDecimal("0") : amount;
        String currencySign = "";
        int amountPrecition = 4;
        if (currency != null) {
            currencySign = currency.getString("sign");
            amountPrecition = currency.getInt("amtprecision");
            amount = amount.setScale(amountPrecition, RoundingMode.HALF_UP);
            this.labCurrencySign = currency.getString("sign");
            this.currencyAmtprecision = amountPrecition;
        }
        String formatStr = "###,##0." + StringUtils.repeat((String)"0", (int)amountPrecition);
        DecimalFormat decimalFormat = new DecimalFormat(formatStr);
        String amountStr = decimalFormat.format(amount);
        return currencySign + amountStr;
    }

    private void refreshSingle() {
        int index = this.getModel().getEntryCurrentRowIndex("acctbankcardentry");
        this.refreshBalance(new int[]{index});
    }

    private void refreshAll() {
        int rowCount = this.getModel().getEntryRowCount("acctbankcardentry");
        if (rowCount == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6210\u5458\u5355\u4f4d\u5b58\u6b3e\u8d26\u6237\uff0c\u8bf7\u6dfb\u52a0\u6210\u5458\u5355\u4f4d\u5b58\u6b3e\u8d26\u6237", (String)"DepositsCardPlugin_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] indexArr = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            indexArr[i] = i;
        }
        this.refreshBalance(indexArr);
        this.getView().setVisible(Boolean.TRUE, new String[]{"lastupdatetime"});
        this.getModel().setValue("lastupdatetime", (Object)new Date());
        String msg = ResManager.loadKDString((String)"\u66f4\u65b0\u4e8e", (String)"DepositsCardPlugin_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
        ((Label)this.getView().getControl("premsg")).setText(msg);
    }

    private void refreshBalance(int[] rowIndexs) {
        LinkedHashMap<String, String> accountCurrencyIdMap = new LinkedHashMap<String, String>();
        for (int rowIndex : rowIndexs) {
            DynamicObject acctBank = (DynamicObject)this.getModel().getValue("accountbank", rowIndex);
            if (!acctBank.getBoolean("beiinterf")) continue;
            Long currencyId = (Long)this.getModel().getValue("currency.id", rowIndex);
            accountCurrencyIdMap.put(acctBank.getString("number"), currencyId + "_" + rowIndex);
        }
        for (Map.Entry entry : accountCurrencyIdMap.entrySet()) {
            int rowIndex;
            Long currencyId = Long.valueOf(((String)entry.getValue()).split("_")[0]);
            rowIndex = Integer.parseInt(((String)entry.getValue()).split("_")[1]);
            QFilter[] filters = new QFilter[]{new QFilter("accountbank.bankaccountnumber", "=", entry.getKey()), new QFilter("currency", "=", (Object)currencyId)};
            DynamicObjectCollection balanceInquires = QueryServiceHelper.query((String)"getLastestBalanceInquire", (String)"ifm_accountbalance", (String)"amount,bizdate,modifytime", (QFilter[])filters, (String)"bizdate desc, modifytime desc", (int)1);
            DynamicObject lastestBeBalance = balanceInquires.isEmpty() ? null : (DynamicObject)balanceInquires.get(0);
            this.showBalance(rowIndex, lastestBeBalance);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8054\u673a\u67e5\u8be2\u6210\u529f", (String)"DepositsCardPlugin_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
    }

    private void confirmBeforeDelete() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("acctbankcardentry");
        String bankNumber = (String)this.getModel().getValue("banknumber", rowIndex);
        String confirmMessage = ResManager.loadKDString((String)"\u786e\u8ba4\u4e0d\u518d\u5173\u6ce8\u5c3e\u53f7\u4e3a%s\u7684\u5185\u90e8\u8d26\u6237\uff1f", (String)"DepositsCardPlugin_0", (String)"tmc-ifm-formplugin", (Object[])new Object[]{bankNumber});
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("delete", (IFormPlugin)this);
        this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    private void deleteAttentionItem() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("acctbankcardentry");
        DynamicObject acctBank = (DynamicObject)this.getModel().getValue("accountbank", rowIndex);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", rowIndex);
        Long userId = RequestContext.get().getCurrUserId();
        QFilter acctBankFilter = new QFilter("accountbank", "=", acctBank.getPkValue());
        QFilter currencyFilter = new QFilter("currency", "=", currency.getPkValue());
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        DeleteServiceHelper.delete((String)"ifm_deposits_setting", (QFilter[])new QFilter[]{userFilter, acctBankFilter, currencyFilter});
        this.getModel().deleteEntryRow("acctbankcardentry", rowIndex);
        int rowCount = this.getModel().getEntryRowCount("acctbankcardentry");
        if (rowCount == 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"add_card"});
        }
    }

    private void lookUpJournal() {
        int index = this.getModel().getEntryCurrentRowIndex("acctbankcardentry");
        DynamicObject acctBank = (DynamicObject)this.getModel().getValue("accountbank", index);
        DynamicObject bdAcctBank = this.getBdIdByInner(acctBank);
        Long orgId = acctBank.getLong("company.id");
        Long scOrgId = acctBank.getLong("finorg.id");
        DynamicObject period = this.getPeriodByDate(orgId, DateUtils.getCurrentDate());
        if (EmptyUtil.isEmpty((DynamicObject)period)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s:\u6ca1\u6709\u7ef4\u62a4\u5f53\u524d\u65e5\u671f\u4f1a\u8ba1\u671f\u95f4", (String)"DepositsCardPlugin_6", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), acctBank.getString("name")));
        }
        ReportShowParameter fsp = new ReportShowParameter();
        fsp.setFormId("ifm_subsidiaryledger");
        fsp.setCustomParam("setDefaultFilters", (Object)Boolean.TRUE);
        fsp.setCustomParam("filter_company", JSONArray.toJSON((Object)new Long[]{orgId}));
        fsp.setCustomParam("filter_settlementcenter", (Object)scOrgId);
        fsp.setCustomParam("filter_close", (Object)false);
        fsp.setCustomParam("filter_bankaccount", JSONArray.toJSON((Object)new Long[]{bdAcctBank.getLong("id")}));
        fsp.setCustomParam("filter_orgcurrency", (Object)acctBank.getLong("currency_dflt.id"));
        fsp.setCustomParam("filter_beginperiod", period.getPkValue());
        fsp.setCustomParam("filter_endperiod", period.getPkValue());
        fsp.setCustomParam("filter_querytype", (Object)"period");
        fsp.setCustomParam("filter_begindate", null);
        fsp.setCustomParam("filter_enddate", null);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        fsp.setOpenStyle(openStyle);
        this.getView().showForm((FormShowParameter)fsp);
    }

    private DynamicObject getPeriodByDate(Long orgId, Date date) {
        DynamicObject periodType;
        Long periodTypeId = 0L;
        DynamicObject casInit = TmcBusinessBaseHelper.getSystemStatusCtrol((long)orgId);
        if (casInit != null && (periodType = casInit.getDynamicObject("periodtype")) != null) {
            periodTypeId = periodType.getLong("id");
        }
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("periodtype", "=", (Object)periodTypeId), new QFilter("isadjustperiod", "=", (Object)"0")};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    private void lookUpTransDetail() {
        int index = this.getModel().getEntryCurrentRowIndex("acctbankcardentry");
        DynamicObject acctBank = (DynamicObject)this.getModel().getValue("accountbank", index);
        Long orgId = acctBank.getLong("company.id");
        ListShowParameter fsp = new ListShowParameter();
        fsp.setBillFormId("ifm_transdetail");
        fsp.setCustomParam("setDefaultFilters", (Object)Boolean.TRUE);
        fsp.setCustomParam("company.id", Collections.singletonList(orgId));
        fsp.setCustomParam("bank.id", Collections.singletonList(acctBank.getLong("finorg.id")));
        DynamicObject bdAcctBank = this.getBdIdByInner(acctBank);
        fsp.setCustomParam("accountbank.id", Collections.singletonList(bdAcctBank.getLong("id")));
        fsp.setCustomParam("currency.id", (Object)acctBank.getLong("currency_dflt.id"));
        LspWapper lspWapper = new LspWapper(fsp);
        lspWapper.clearPlugins();
        lspWapper.registerPlugin("kd.tmc.ifm.formplugin.home.IfmInnerHyperlinkList");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        fsp.setOpenStyle(openStyle);
        fsp.setCaption(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u5217\u8868", (String)"DepositsCardPlugin_4", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)fsp);
    }
}

