/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.init;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;

public class InitBillEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public static final Long INNER_LOAN_FIN_PRODUCT_ID = 1312902938536014848L;

    public void registerListener(EventObject e) {
        BasedataEdit loanAcctBank = (BasedataEdit)this.getControl("accountbank");
        loanAcctBank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit settleCenter = (BasedataEdit)this.getControl("settlecenter");
        settleCenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit eLoanAcctbank = (BasedataEdit)this.getControl("loadacctbank");
        eLoanAcctbank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit finProduct = (BasedataEdit)this.getControl("finproduct");
        if (finProduct != null) {
            finProduct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setProductView();
        this.setDefaultFinProduct();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "accountbank": 
            case "loadacctbank": {
                this.initLoanerAcctBankFilter(evt);
                break;
            }
            case "settlecenter": {
                this.settleCenterF7Evt(evt);
                break;
            }
            case "finproduct": {
                this.finproductF7Evt(evt);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("ifm_initbill".equals(formId)) {
            this.setDefaultCenter();
        }
    }

    private void finproductF7Evt(BeforeF7SelectEvent evt) {
        DynamicObject center = (DynamicObject)this.getModel().getValue("settlecenter");
        if (center == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u503a\u6743\u4eba\u3002", (String)"IfmLoanContractBillEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        Object pkValue = center.getPkValue();
        QFilter filter = new QFilter("enable", "=", (Object)"1").and(new QFilter("currency", ">", (Object)0).and(new QFilter("center.id", "=", pkValue)));
        sp.getCustomParams().put("containDefault", "true");
        sp.getListFilterParameter().getQFilters().add(filter);
    }

    private void settleCenterF7Evt(BeforeF7SelectEvent evt) {
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        List settleCenterIds = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)RequestContext.get().getCurrUserId(), (String)TmcAppEnum.IFM.getValue(), (String)"ifm_initbill", (String)"47150e89000000ac");
        QFilter filter = new QFilter("id", "in", (Object)settleCenterIds);
        sp.getListFilterParameter().getQFilters().add(filter);
    }

    private void initLoanerAcctBankFilter(BeforeF7SelectEvent evt) {
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"settlecenter")) {
            evt.setCancel(true);
            return;
        }
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("settlecenter");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        QFilter filter = new QFilter("bank.id", "=", settleCenter.getPkValue());
        filter.and(new QFilter("currency.fbasedataid", "=", currency.getPkValue()));
        sp.getListFilterParameter().getQFilters().add(filter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (property) {
            case "org": {
                this.orgChgEvt();
                break;
            }
            case "finproduct": {
                this.finProductChgEvt((DynamicObject)newValue);
                break;
            }
            case "settlecenter": {
                this.settleCenterChgEvt((DynamicObject)newValue);
                break;
            }
        }
    }

    private void settleCenterChgEvt(DynamicObject settleCenter) {
        if (EmptyUtil.isNoEmpty((DynamicObject)settleCenter) && "ifm_initbill".equals(this.getModel().getDataEntityType().getName())) {
            this.getModel().setValue("creditorg", (Object)settleCenter.getDynamicObject("org"));
            this.getModel().setValue("creditor", (Object)settleCenter.getLong("id"));
            this.getModel().setValue("textcreditor", settleCenter.get("name"));
            this.getModel().setValue("creditortype", (Object)"settlecenter");
        }
    }

    private void finProductChgEvt(DynamicObject finproduct) {
        this.getModel().setValue("accountbank", null);
        if (EmptyUtil.isNoEmpty((DynamicObject)finproduct) && "ifm_initbill".equals(this.getModel().getDataEntityType().getName())) {
            this.getModel().setValue("basis", (Object)finproduct.getString("basis"));
            this.getModel().setValue("currency", finproduct.getDynamicObject("currency").getPkValue());
            String rateType = finproduct.getString("ratetype");
            boolean isFloatRate = InterestTypeEnum.FLOAT.getValue().equals(rateType);
            this.getModel().setValue("interesttype", (Object)rateType);
            if (isFloatRate) {
                this.getModel().setValue("referencerate", (Object)finproduct.getDynamicObject("referrate"));
                this.getModel().setValue("ratesign", (Object)finproduct.getString("ratesignbp"));
                this.getModel().setValue("ratefloatpoint", (Object)finproduct.getBigDecimal("ratefloatpoints"));
                this.getModel().setValue("interestrate", null);
                this.getView().setEnable(Boolean.TRUE, new String[]{"ratesign", "ratefloatpoint"});
            } else {
                this.getModel().setValue("interestrate", finproduct.get("productprice"));
                this.getModel().setValue("referencerate", null);
                this.getModel().setValue("ratesign", null);
                this.getModel().setValue("ratefloatpoint", null);
                this.getView().setEnable(Boolean.TRUE, new String[]{"interestrate"});
            }
            this.setProductView();
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        JSONObject productDyn = (JSONObject)sourceData.get("finproduct");
        if (EmptyUtil.isEmpty((Object)productDyn)) {
            return;
        }
        DynamicObject product = TmcDataServiceHelper.loadSingleFromCache((String)"ifm_ldproduct", (String)"ratetype,currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)productDyn.getString("number"))});
        if (EmptyUtil.isNoEmpty((DynamicObject)product)) {
            String intType = Optional.ofNullable((String)sourceData.get("interesttype")).orElse("");
            if (!intType.equals(product.getString("ratetype"))) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5229\u7387\u7c7b\u578b\u4e0e\u7ed3\u7b97\u4e2d\u5fc3\u8d37\u6b3e\u4ea7\u54c1\u7684\u5229\u7387\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InitBillEdit_10", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONObject currencyDyn = (JSONObject)sourceData.get("currency");
            if (EmptyUtil.isEmpty((Object)currencyDyn)) {
                return;
            }
            String currencyNum = Optional.ofNullable(currencyDyn.getString("number")).orElse("");
            if (!currencyNum.equals(product.getString("currency.number"))) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5e01\u79cd\u4e0e\u7ed3\u7b97\u4e2d\u5fc3\u8d37\u6b3e\u4ea7\u54c1\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InitBillEdit_11", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        DynamicObject sc = (DynamicObject)this.getModel().getValue("settlecenter");
        if (sc != null) {
            this.getModel().setValue("textcreditor", (Object)sc.getString("name"));
            this.getModel().setValue("creditor", (Object)sc.getLong("id"));
        } else {
            this.getModel().setValue("textcreditor", null);
            this.getModel().setValue("creditor", null);
        }
        this.setTermByImport();
        this.setGuaranteeEntryField();
    }

    private void setProductView() {
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        boolean isEnable = EmptyUtil.isNoEmpty((DynamicObject)finProduct) && finProduct.getPkValue().equals(INNER_LOAN_FIN_PRODUCT_ID);
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"interesttype", "basis", "referencerate"});
    }

    private void orgChgEvt() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("ifm_initbill".equals(formId)) {
            this.getModel().setValue("accountbank", null);
        }
    }

    private void setDefaultCenter() {
        long orgId = RequestContext.get().getOrgId();
        QFilter clearinghouseFilter = new QFilter("finorgtype.type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] qFilters = new QFilter[]{clearinghouseFilter, orgFilter};
        DynamicObject clearinghouse = BusinessDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"id,number,name,org", (QFilter[])qFilters);
        if (clearinghouse != null) {
            this.getModel().setValue("settlecenter", (Object)clearinghouse);
            this.getModel().setValue("textcreditor", (Object)clearinghouse.getString("name"));
            this.getModel().setValue("creditorg", (Object)clearinghouse.getDynamicObject("org").getLong("id"));
            this.getModel().setValue("creditor", (Object)clearinghouse.getLong("id"));
        }
    }

    private void setDefaultFinProduct() {
        String formId = this.getView().getFormShowParameter().getFormId();
        DynamicObject finproduct = (DynamicObject)this.getModel().getValue("finproduct");
        if ("ifm_initbill".equals(formId) && EmptyUtil.isEmpty((DynamicObject)finproduct)) {
            this.getModel().setValue("finproduct", (Object)INNER_LOAN_FIN_PRODUCT_ID);
        }
    }

    private void setTermByImport() {
        DynamicObjectCollection loanEntry;
        Date endDate = (Date)this.getModel().getValue("enddate");
        Date startDate = (Date)this.getModel().getValue("startdate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate})) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"term", (Object)DateUtils.getDiff_ymd((Date)startDate, (Date)endDate));
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)(loanEntry = this.getModel().getEntryEntity("loanentry")))) {
            return;
        }
        for (DynamicObject row : loanEntry) {
            Date loanStartDate = row.getDate("startinstdate");
            Date loanEndDate = row.getDate("expiredate");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{loanStartDate, loanEndDate})) continue;
            row.set("loanterm", (Object)DateUtils.getDiff_ymd((Date)loanStartDate, (Date)loanEndDate));
        }
    }

    private void setGuaranteeEntryField() {
        DynamicObjectCollection loanEntry = this.getModel().getEntryEntity("loanentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loanEntry)) {
            return;
        }
        for (DynamicObject parentRow : loanEntry) {
            DynamicObjectCollection subEntry = parentRow.getDynamicObjectCollection("gmsubentry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)subEntry)) continue;
            for (DynamicObject subRow : subEntry) {
                boolean diffCurrency;
                DynamicObject gContract = subRow.getDynamicObject("gcontract");
                if (EmptyUtil.isEmpty((DynamicObject)gContract)) continue;
                subRow.set("gcontractcurrency", (Object)gContract.getDynamicObject("currency"));
                subRow.set("gcontractamount", (Object)gContract.getBigDecimal("amount"));
                long gVarieId = gContract.getLong("guaranteevarieties.id");
                DynamicObject guaranteeVar = TmcDataServiceHelper.loadSingleFromCache((String)"gm_guaranteevarieties", (String)"id,creditguarantee", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)gVarieId)});
                if (EmptyUtil.isEmpty((DynamicObject)guaranteeVar)) continue;
                subRow.set("gcreditguarantee", (Object)guaranteeVar.getBoolean("creditguarantee"));
                DynamicObject gCcy = gContract.getDynamicObject("currency");
                DynamicObject bizCCy = (DynamicObject)this.getModel().getValue("currency");
                BigDecimal rate = BigDecimal.ONE;
                boolean bl = diffCurrency = bizCCy != null && !gCcy.getPkValue().equals(bizCCy.getPkValue());
                if (diffCurrency) {
                    DynamicObject company = (DynamicObject)this.getModel().getValue("org");
                    rate = TmcBusinessBaseHelper.getExchangeRate((long)bizCCy.getLong("id"), (long)gCcy.getLong("id"), (long)company.getLong("id"), (Date)DateUtils.getCurrentDate());
                }
                subRow.set("gexchrate", (Object)rate);
            }
        }
    }
}

