/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.inneracct;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.AttachmentMarkEvent;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOpLogShowHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.formplugin.inneracct.FilterBankAccountsUtil;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;

public class InnerAcctEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
UploadListener,
AttachmentMarkListener {
    private static final Log LOGGER = LogFactory.getLog(InnerAcctEdit.class);
    private static final String F_BASE_DATA_ID = "fbasedataid";
    private static final String AFTER_SAVE = "aftersave";
    private static final String OPERATE = "operate";
    private static final String ATTACHMENT_LIST = "attachmentList";
    private static final String MARK_MAP = "markMap";
    private static final String UID = "uid";
    private static final String SEPARATOR = "/";
    private int count = 0;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setRelationship();
        this.setFinOrgF7Filter();
        this.setRelationAccF7Filter();
        this.setStrategyF7Filter();
        BasedataEdit currencyDataEdit = (BasedataEdit)this.getView().getControl("currency");
        currencyDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit finOrgDataEdit = (BasedataEdit)this.getView().getControl("finorg");
        finOrgDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        panel.addUploadListener((UploadListener)this);
        panel.addMarkListener((AttachmentMarkListener)this);
    }

    public void upload(UploadEvent evt) {
        List attachments;
        String cache = this.getPageCache().get(ATTACHMENT_LIST);
        if (StringUtils.isEmpty((CharSequence)cache)) {
            attachments = Arrays.stream(evt.getUrls()).collect(Collectors.toList());
        } else {
            attachments = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(ATTACHMENT_LIST), List.class);
            attachments.addAll(Arrays.stream(evt.getUrls()).collect(Collectors.toList()));
        }
        this.getPageCache().put(ATTACHMENT_LIST, SerializationUtils.toJsonString((Object)attachments));
    }

    public void mark(AttachmentMarkEvent evt) {
        String cache = this.getPageCache().get(MARK_MAP);
        Map<String, String> markMap = StringUtils.isEmpty((CharSequence)cache) ? new HashMap<String, String>() : (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(MARK_MAP), Map.class);
        markMap.put(evt.getUid(), evt.getDescription());
        this.getPageCache().put(MARK_MAP, SerializationUtils.toJsonString(markMap));
    }

    public void remove(UploadEvent evt) {
        String marksCache;
        ArrayList removeAttachment = new ArrayList(Arrays.stream(evt.getUrls()).collect(Collectors.toList()));
        String attachmentsCache = this.getPageCache().get(ATTACHMENT_LIST);
        if (!StringUtils.isEmpty((CharSequence)attachmentsCache)) {
            List cacheAttachments = (List)SerializationUtils.fromJsonString((String)attachmentsCache, List.class);
            cacheAttachments.removeIf(atta -> Objects.equals(((Map)removeAttachment.get(0)).get(UID), atta.get(UID)));
            this.getPageCache().put(ATTACHMENT_LIST, SerializationUtils.toJsonString((Object)cacheAttachments));
        }
        if (!StringUtils.isEmpty((CharSequence)(marksCache = this.getPageCache().get(MARK_MAP)))) {
            Map cacheMarkMap = (Map)SerializationUtils.fromJsonString((String)marksCache, Map.class);
            cacheMarkMap.entrySet().removeIf(next -> Objects.equals(next.getKey(), ((Map)removeAttachment.get(0)).get(UID)));
            this.getPageCache().put(MARK_MAP, SerializationUtils.toJsonString((Object)cacheMarkMap));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (Objects.equals(evt.getItemKey(), "bar_save")) {
            String attachmentCache = this.getPageCache().get(ATTACHMENT_LIST);
            if (StringUtils.isEmpty((CharSequence)attachmentCache)) {
                return;
            }
            List attachments = (List)SerializationUtils.fromJsonString((String)attachmentCache, List.class);
            if (CollectionUtils.isEmpty((Collection)attachments)) {
                return;
            }
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            for (Map attachment : attachments) {
                InputStream ins = tempFileCache.getInputStream((String)attachment.get("url"));
                String path = DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd") + SEPARATOR + this.getView().getFormShowParameter().getAppId() + SEPARATOR + this.getModel().getDataEntityType().getName() + SEPARATOR + this.getId() + SEPARATOR + "attachments" + SEPARATOR + attachment.get("name");
                FileItem fi = new FileItem((String)attachment.get("name"), path, ins);
                FileService fs = FileServiceFactory.getAttachmentFileService();
                String upload = fs.upload(fi);
                attachment.put("url", upload);
            }
            this.getPageCache().put(ATTACHMENT_LIST, SerializationUtils.toJsonString((Object)attachments));
        }
    }

    private long getId() {
        return DB.genLongId((String)"ifm_inneracct");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        OperationStatus status = showParameter.getStatus();
        if (OperationStatus.EDIT == status) {
            Map paraMap = showParameter.getCustomParams();
            if (!paraMap.containsKey("fromchange")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_update"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_change", "close"});
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (Objects.equals(AFTER_SAVE, this.getView().getFormShowParameter().getCustomParam(OPERATE))) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"InnerAcctEdit_4", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
        DateEdit openDate = (DateEdit)this.getControl("open_date");
        openDate.setMaxDate(new Date());
        this.handleStatus();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW == status) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"closedate", "close"});
            this.refreshAcctName();
            SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
            control.hidePanel(SplitDirection.right, true);
        } else {
            DynamicObject bankAccount = BusinessDataServiceHelper.loadSingle((String)"am_accountbank", (String)String.join((CharSequence)",", "id", "bankaccountnumber"), (QFilter[])new QFilter("bankaccountnumber", "=", this.getModel().getValue("number")).toArray());
            if (bankAccount != null) {
                this.getRelations(bankAccount);
            }
            this.enableOpenDate();
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"number"});
    }

    private void enableOpenDate() {
        boolean init;
        DynamicObject innerAccountInit = BusinessDataServiceHelper.loadSingle((String)"ifm_inneraccountinit", (String)"isinit", (QFilter[])new QFilter("inneraccount", "=", this.getModel().getValue("id")).toArray());
        if (innerAccountInit != null && (init = innerAccountInit.getBoolean("isinit"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"open_date"});
        }
    }

    private void getRelations(DynamicObject bankAcct) {
        boolean dataChanged = this.getModel().getDataChanged();
        List<Map<String, Object>> billMap = this.getInfoObject(bankAcct);
        IDataModel model = this.getModel();
        TmcViewInputHelper.batchFillEntity((String)"relationentry", (AbstractFormDataModel)((AbstractFormDataModel)model), billMap);
        this.getModel().setDataChanged(dataChanged);
    }

    private List<Map<String, Object>> getInfoObject(DynamicObject bankAcct) {
        HashMap<String, Object> bill;
        String bankNum = bankAcct.getString("bankaccountnumber");
        if (EmptyUtil.isEmpty((String)bankNum)) {
            return new ArrayList<Map<String, Object>>();
        }
        Object bankAcctId = bankAcct.getPkValue();
        QFilter numFilter = new QFilter("bankaccountnumber", "in", (Object)bankNum);
        DynamicObjectCollection openBills = QueryServiceHelper.query((String)"am_accopenbill", (String)"id,createtime,applier,applier.name", (QFilter[])new QFilter[]{numFilter});
        QFilter bankFilter = new QFilter("accountbank", "in", bankAcctId);
        DynamicObjectCollection closeBills = QueryServiceHelper.query((String)"am_acctclosebill", (String)"id,createtime,applier,applier.name", (QFilter[])new QFilter[]{bankFilter});
        ArrayList<Map<String, Object>> billList = new ArrayList<Map<String, Object>>(openBills.size() + closeBills.size());
        for (DynamicObject openBill : openBills) {
            bill = new HashMap<String, Object>();
            bill.put("billname", ResManager.loadKDString((String)"%s\u63d0\u4ea4\u94f6\u884c\u8d26\u6237\u5f00\u6237\u7533\u8bf7\u5355", (String)"InnerAcctEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[]{openBill.get("applier.name")}));
            bill.put("billtype", "am_accopenbill");
            bill.put("createdate", DateUtils.formatString((Date)openBill.getDate("createtime"), (String)"yyyy-MM-dd HH:mm:ss"));
            bill.put("relationbillid", openBill.get("id"));
            billList.add(bill);
        }
        for (DynamicObject closeBill : closeBills) {
            bill = new HashMap();
            bill.put("billname", ResManager.loadKDString((String)"%s\u63d0\u4ea4\u94f6\u884c\u8d26\u6237\u9500\u6237\u7533\u8bf7\u5355", (String)"InnerAcctEdit_6", (String)"tmc-ifm-formplugin", (Object[])new Object[]{closeBill.get("applier.name")}));
            bill.put("billtype", "am_acctclosebill");
            bill.put("createdate", DateUtils.formatString((Date)closeBill.getDate("createtime"), (String)"yyyy-MM-dd HH:mm:ss"));
            bill.put("relationbillid", closeBill.get("id"));
            billList.add(bill);
        }
        return billList;
    }

    private void refreshAcctName() {
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company != null) {
            this.getModel().setValue("name", (Object)company.getString("name"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW == status) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"close"});
        }
        if (Objects.equals(operateKey = afterDoOperationEventArgs.getOperateKey(), "preclose")) {
            this.showInnerAccountCloseDetail();
        } else if (Objects.equals(operateKey, "dosave")) {
            this.doIfSuccess(afterDoOperationEventArgs);
        } else if (Objects.equals(operateKey, "update")) {
            boolean isInterest = (Boolean)this.getModel().getValue("interest");
            DynamicObject innerAcct = TmcDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)this.getView().getFormShowParameter().getFormId(), (String)"isdrawobject");
            if (isInterest && EmptyUtil.isNoEmpty((DynamicObject)innerAcct) && !innerAcct.getBoolean("isdrawobject")) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirm_bindintobject_update", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u5185\u90e8\u8d26\u6237\u9700\u8981\u8ba1\u606f\uff0c\u662f\u5426\u65b0\u589e\u8ba1\u606f\u5bf9\u8c61?", (String)"InnerAcctEdit_5", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
            }
        }
    }

    private void doIfSuccess(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult.isSuccess()) {
            Long successPkId = (Long)operationResult.getSuccessPkIds().get(0);
            if (((Boolean)this.getModel().getValue("interest")).booleanValue()) {
                this.getPageCache().put("successPkId", String.valueOf(successPkId));
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirm_bindintobject_add", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u5185\u90e8\u8d26\u6237\u9700\u8981\u8ba1\u606f\uff0c\u662f\u5426\u65b0\u589e\u8ba1\u606f\u5bf9\u8c61?", (String)"InnerAcctEdit_5", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
            } else {
                this.reLoadBill(successPkId);
            }
        }
    }

    private void updateAttachments(Long successPkId) {
        String markMapCache;
        List attachments;
        String attachmentCache = this.getPageCache().get(ATTACHMENT_LIST);
        List<Object> uids = null;
        if (!StringUtils.isEmpty((CharSequence)attachmentCache) && !CollectionUtils.isEmpty((Collection)(attachments = (List)SerializationUtils.fromJsonString((String)attachmentCache, List.class)))) {
            AttachmentServiceHelper.upload((String)"ifm_inneracct", (Object)successPkId, (String)"attachmentpanelap", (List)attachments);
            uids = attachments.stream().map(m -> m.get(UID)).collect(Collectors.toList());
        }
        if (!StringUtils.isEmpty((CharSequence)(markMapCache = this.getPageCache().get(MARK_MAP)))) {
            Map markMap = (Map)SerializationUtils.fromJsonString((String)markMapCache, Map.class);
            if (uids != null && !uids.isEmpty()) {
                InnerAcctEdit.marks(uids, markMap);
            }
        }
    }

    public static void marks(List<Object> uids, Map<String, String> markMap) {
        QFilter[] filters = new QFilter[]{new QFilter("fnumber", "in", uids)};
        Map attachmentMap = BusinessDataServiceHelper.loadFromCache((String)"bos_attachment", (QFilter[])filters);
        Collection attachmentCollection = attachmentMap.values();
        for (DynamicObject dynamicObject : attachmentCollection) {
            for (Map.Entry<String, String> markEntry : markMap.entrySet()) {
                if (!Objects.equals(dynamicObject.get("fnumber"), markEntry.getKey())) continue;
                dynamicObject.set("fdescription", (Object)markEntry.getValue());
            }
        }
        SaveServiceHelper.save((DynamicObject[])attachmentCollection.toArray(new DynamicObject[0]));
    }

    private void showCloneEditPage(Long successPkId) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        parameter.setAppId("ifm");
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId("ifm_inneracct");
        parameter.setPkId((Object)successPkId);
        parameter.setCustomParam(OPERATE, (Object)AFTER_SAVE);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map data;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Objects.equals(actionId, "close_inner_account") && (data = (Map)closedCallBackEvent.getReturnData()) != null) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("closereason", (String)data.get("closereason"));
            option.setVariableValue("closedate", DateUtils.formatString((Date)((Date)data.get("closedate")), (String)"yyyy-MM-dd HH:mm:ss"));
            this.getView().invokeOperation("closeacc", option);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (Objects.equals(callBackId, "confirm_bindintobject_add")) {
            String sucPkId = this.getPageCache().get("successPkId");
            if (EmptyUtil.isEmpty((String)sucPkId)) {
                return;
            }
            Long successPkId = Long.valueOf(sucPkId);
            this.reLoadBill(successPkId);
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.showIntObjectBill(successPkId);
            }
        } else if (Objects.equals(callBackId, "confirm_bindintobject_update") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.showIntObjectBill((Long)this.getModel().getValue("id"));
        }
    }

    private void reLoadBill(Long successPkId) {
        this.showCloneEditPage(successPkId);
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.updateAttachments(successPkId);
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                tx.markRollback();
            }
        }
    }

    private void showIntObjectBill(Long innerAcctId) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("ifm_intobject");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("innerAccountId", (Object)innerAcctId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showInnerAccountCloseDetail() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setAppId("ifm");
        parameter.setFormId("ifm_inneracctclosedetail");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_inner_account"));
        this.getView().showForm(parameter);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"barshowlog")) {
            Object number = this.getModel().getValue("number");
            FormShowParameter sp = TmcOpLogShowHelper.create((String)TmcAppEnum.IFM.getValue(), (String)"ifm_inneracct", (Object)number);
            this.getView().showForm(sp);
        }
    }

    private void setFinOrgF7Filter() {
        BasedataEdit finOrg = (BasedataEdit)this.getControl("finorg");
        finOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter typeFilter = new QFilter("finorgtype.type", "in", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            QFilter orgIdFilter = new QFilter("org", "in", (Object)orgIdList);
            showPara.getListFilterParameter().setFilter(typeFilter.and(orgIdFilter));
        });
    }

    private void setStrategyF7Filter() {
        BasedataEdit strategyF7 = (BasedataEdit)this.getControl("mgrstratg");
        strategyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Object defCurrency = this.getModel().getValue("currency_dflt");
            if (defCurrency != null) {
                QFilter qFilter = new QFilter("currency.id", "=", ((DynamicObject)defCurrency).getPkValue());
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        });
    }

    private void setRelationAccF7Filter() {
        BasedataEdit relationAcc = (BasedataEdit)this.getControl("relationacc");
        relationAcc.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject innerAccount = this.getModel().getDataEntity();
            showPara.getListFilterParameter().getQFilters().clear();
            if (EmptyUtil.isEmpty((DynamicObject)innerAccount.getDynamicObject("org"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f00\u6237\u884c\u3002", (String)"InnerAcctEdit_7", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            showPara.getListFilterParameter().setFilter(FilterBankAccountsUtil.getBankAccountsFilter(innerAccount, this.getCurrRelBankAccounts()));
            showPara.setUseOrgId(0L);
        });
    }

    private List<Long> getCurrRelBankAccounts() {
        DynamicObject[] load;
        List<Long> currentRelationBankAccounts = this.getModel().getDataEntity().getDynamicObjectCollection("relationacc").stream().map(d -> (Long)d.getDynamicObject(F_BASE_DATA_ID).getPkValue()).collect(Collectors.toList());
        if (currentRelationBankAccounts.isEmpty() && (load = BusinessDataServiceHelper.load((String)"ifm_inneracct", (String)String.join((CharSequence)",", "id", "relationacc"), (QFilter[])new QFilter("id", "=", this.getModel().getDataEntity().getPkValue()).toArray())).length > 0) {
            currentRelationBankAccounts = load[0].getDynamicObjectCollection("relationacc").stream().map(d -> (Long)d.getDynamicObject(F_BASE_DATA_ID).getPkValue()).collect(Collectors.toList());
        }
        return currentRelationBankAccounts;
    }

    private void handleStatus() {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (String[])new String[]{"number", "name", "company", "openorg", "finorg", "currency", "currency_dflt", "accttype", "acctprop", "acctuseage", "open_date", "acctstatus", "beiinterf", "onlinebank"});
        Object currStat = this.getModel().getValue("status");
        if (!BillStatusEnum.AUDIT.getValue().equals(currStat)) {
            SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
            control.hidePanel(SplitDirection.right, true);
        }
    }

    private void setRelationship() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("relationentry");
        cardEntry.addHyperClickListener(evt -> {
            int rowIndex;
            String key = evt.getFieldName();
            if ("billname".equals(key) && (rowIndex = evt.getRowIndex()) > -1) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("relationentry", rowIndex);
                Object billId = entryRowEntity.get("relationbillid");
                String entityName = (String)entryRowEntity.get("billtype");
                BillShowParameter showPara = new BillShowParameter();
                showPara.setBillTypeId(entityName);
                showPara.setFormId(entityName);
                showPara.setPkId(billId);
                showPara.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm((FormShowParameter)showPara);
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"currency", (CharSequence)name)) {
            this.fillOneCurrency(e);
            this.getModel().setValue("currency_dflt", null);
            this.refreshDefaultCurrency();
        } else if (StringUtils.equals((CharSequence)"currency_dflt", (CharSequence)name)) {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.ADDNEW == status) {
                this.refreshMgrFeeCurrency();
            }
        } else if (StringUtils.equals((CharSequence)"company", (CharSequence)name)) {
            DynamicObject currentOrg;
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.ADDNEW == status) {
                this.refreshAcctName();
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(currentOrg = (DynamicObject)this.getModel().getValue("company")))) {
                DynamicObject accountOrg = TmcOrgDataHelper.getAccountOrgByFundsOrg((DynamicObject)currentOrg);
                if (!EmptyUtil.isEmpty((DynamicObject)accountOrg)) {
                    this.getModel().setValue("openorg", accountOrg.getPkValue());
                } else {
                    this.getModel().setValue("openorg", null);
                }
            }
        } else if (StringUtils.equals((CharSequence)"finorg", (CharSequence)name) && e.getChangeSet()[0].getNewValue() != null) {
            ChangeData changeData = e.getChangeSet()[0];
            Long org = IfmSettleCenterHelper.getSettleCenterOrgIdByFinOrg((Long)((Long)((DynamicObject)changeData.getNewValue()).getPkValue()));
            this.getModel().setValue("org", (Object)org);
        }
    }

    private void fillOneCurrency(PropertyChangedArgs e) {
        if (this.count++ == 0) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObjectCollection newValue = (DynamicObjectCollection)changeData.getNewValue();
            DynamicObjectCollection oldValue = (DynamicObjectCollection)changeData.getOldValue();
            DynamicObjectCollection targetObjectCollection = this.getCurrency(newValue, oldValue);
            this.getModel().setValue("currency", (Object)targetObjectCollection);
        }
    }

    private DynamicObjectCollection getCurrency(DynamicObjectCollection newValue, DynamicObjectCollection oldValue) {
        Object newPk;
        Object oldPk;
        if (newValue.isEmpty()) {
            return null;
        }
        if (!oldValue.isEmpty() && !Objects.equals(oldPk = ((DynamicObject)oldValue.get(0)).getDynamicObject(F_BASE_DATA_ID).getPkValue(), newPk = ((DynamicObject)newValue.get(0)).getDynamicObject(F_BASE_DATA_ID).getPkValue())) {
            newValue.removeIf(n -> Objects.equals(oldPk, n.getDynamicObject(F_BASE_DATA_ID).getPkValue()));
        }
        DynamicObject[] dynamicObjects = new DynamicObject[]{((DynamicObject)newValue.get(newValue.size() - 1)).getDynamicObject(F_BASE_DATA_ID)};
        return TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"currency", (DynamicObject[])dynamicObjects);
    }

    private void refreshDefaultCurrency() {
        DynamicObjectCollection currency = (DynamicObjectCollection)this.getModel().getValue("currency");
        if (currency.size() > 0) {
            Object staCurrId;
            Object firstCurrencyId = ((DynamicObject)currency.get(0)).getDynamicObject(F_BASE_DATA_ID).getPkValue();
            this.getModel().setValue("currency_dflt", firstCurrencyId);
            DynamicObject stratg = (DynamicObject)this.getModel().getValue("mgrstratg");
            if (stratg != null && (staCurrId = stratg.getDynamicObject("currency").getPkValue()) != firstCurrencyId) {
                this.getModel().setValue("mgrstratg", null);
            }
        } else {
            this.getModel().setValue("mgrstratg", null);
        }
    }

    private void refreshMgrFeeCurrency() {
        Object defaultCurrency = this.getModel().getValue("currency_dflt");
        this.getModel().setValue("currency_mgrfee", defaultCurrency);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (Objects.equals(key, "currency")) {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            sp.setMultiSelect(false);
        } else if (Objects.equals(key, "finorg")) {
            List settleCenterIds = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)Long.valueOf(RequestContext.get().getUserId()), (String)"ifm", (String)"ifm_inneracct", (String)"47156aff000000ac");
            QFilter qFilter = new QFilter("id", "in", (Object)settleCenterIds);
            evt.setCustomQFilters(Collections.singletonList(qFilter));
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        Optional<String> acctNumsOp = Optional.ofNullable((JSONObject)sourceData.get("relationacc")).map(r -> r.getString("bankaccountnumber"));
        if (!acctNumsOp.isPresent()) {
            return;
        }
        Set acctNumSet = Arrays.stream(acctNumsOp.get().split(",")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        JSONObject finorg = (JSONObject)sourceData.get("finorg");
        if (EmptyUtil.isEmpty((Object)finorg)) {
            return;
        }
        List finOrgIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_finorginfo", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)finorg.getString("number"))}, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)finOrgIds)) {
            return;
        }
        QFilter qFilter = new QFilter("finorg", "in", (Object)finOrgIds);
        qFilter.and("id", "!=", this.getModel().getValue("id"));
        Object[] innerAccountsByOrg = BusinessDataServiceHelper.load((String)"ifm_inneracct", (String)"id, relationacc", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((Object[])innerAccountsByOrg)) {
            return;
        }
        List dbRelateAcctIds = Arrays.stream(innerAccountsByOrg).map(r -> r.getDynamicObjectCollection("relationacc")).flatMap(Collection::stream).map(r -> r.getLong("fbasedataid.id")).collect(Collectors.toList());
        List bankAcctIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "in", acctNumSet)}, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)bankAcctIds)) {
            return;
        }
        boolean flag = false;
        for (Object id : bankAcctIds) {
            if (!dbRelateAcctIds.contains(id)) continue;
            flag = true;
            break;
        }
        if (flag) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5173\u8054\u8d26\u6237\u7684\u503c\u5df2\u88ab\u5176\u4ed6\u5185\u90e8\u8d26\u6237\u5f15\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InnerAcctEdit_8", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
    }
}

