/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.inneracct;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.UseStatusEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcDataBaseList;
import kd.tmc.ifm.enums.InnerAccountFrozenTypeEnum;
import kd.tmc.ifm.enums.InnerAcctStatusEnum;
import kd.tmc.ifm.formplugin.inneracct.FilterBankAccountsUtil;

public class InnerAcctList
extends AbstractTmcDataBaseList {
    private static final String UPDATE_RELATION_BANK_ACCOUNTS = "update_relation_bank_accounts";
    private static final String TBL_FROZEN = "tblfrozen";
    private static final String TBL_THAW = "tblthaw";
    private static final String OPERATION = "operation";
    private static final String INNER_ACC_FROZEN = "inner_acc_frozen";
    private static final String INNER_ACC_THAW = "inner_acc_thaw";
    private static final String TMC_IFM_FORMPLUGIN = "tmc-ifm-formplugin";
    private static final String ACCT_STATUS = "frozen";
    private static final String SELECT_PROPERTIES = "id,acctstatus";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if ("company.name".equals(fieldName) || "finorg.name".equals(fieldName)) {
                commonFilter.setDefaultValue("");
                continue;
            }
            if (!"acctstatus".equals(fieldName)) continue;
            commonFilter.setDefaultValue(InnerAcctStatusEnum.NORMAL.getValue());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (!Objects.equals(itemKey, "tblclose")) {
            this.checkAuth();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (!"bos_listf7".equals(this.getView().getFormShowParameter().getFormId())) {
            this.checkAuth();
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setOrderBy("open_date desc");
        this.filterByFInOrg();
    }

    private void filterByFInOrg() {
        if ("bos_listf7".equals(this.getView().getFormShowParameter().getFormId())) {
            return;
        }
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        Object finOrgId = filterContainer.getSelectedValues().get("finorg.id");
        if (finOrgId == null) {
            List finOrgIdList = Stream.of(TmcDataServiceHelper.load((String)"bd_finorginfo", (String)"id", (QFilter[])this.getFinOrgFilter())).map(d -> (Long)d.getPkValue()).collect(Collectors.toList());
            QFilter qFilter = new QFilter("finorg", "in", finOrgIdList);
            BillList billList = (BillList)this.getControl("billlistap");
            billList.setFilter(qFilter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"tblopenacct", (CharSequence)itemKey)) {
            BillShowParameter showPara = new BillShowParameter();
            showPara.setFormId("ifm_inneracctapply");
            showPara.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showPara.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm((FormShowParameter)showPara);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map data;
        super.closedCallBack(evt);
        if (Objects.equals(evt.getActionId(), UPDATE_RELATION_BANK_ACCOUNTS)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
            if (returnData == null) {
                return;
            }
            A[] relationAccIds = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray(Object[]::new);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter("id", "in", relationAccIds).toArray());
            BillList list = (BillList)this.getControl("billlistap");
            Object primaryKeyValue = list.getSelectedRows().get(0).getPrimaryKeyValue();
            DynamicObject innerAcct = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"ifm_inneracct");
            DynamicObjectCollection dynamicObjectCollection = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)innerAcct, (String)"relationacc", (DynamicObject[])load);
            innerAcct.set("relationacc", (Object)dynamicObjectCollection);
            TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_inneracct", (DynamicObject[])new DynamicObject[]{innerAcct}, (OperateOption)OperateOption.create());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u8054\u94f6\u884c\u8d26\u6237\u6210\u529f\u3002", (String)"InnerAcctList_9", (String)TMC_IFM_FORMPLUGIN, (Object[])new Object[0]));
        } else if (Objects.equals(evt.getActionId(), "close_inner_account") && (data = (Map)evt.getReturnData()) != null) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("closereason", (String)data.get("closereason"));
            option.setVariableValue("closedate", DateUtils.formatString((Date)((Date)data.get("closedate")), (String)"yyyy-MM-dd HH:mm:ss"));
            this.getView().invokeOperation("closeacc", option);
        }
    }

    private void checkAuth() {
        String appId = this.getView().getFormShowParameter().getAppId();
        Set authOrgIds = SettleCenterHelper.getAuthorizedSettleCenters((String)appId, (String)"ifm_inneracct", (String)"47150e89000000ac");
        if (authOrgIds.size() <= 0) {
            QFilter[] filters = new QFilter[]{new QFilter("usestatus", "=", (Object)UseStatusEnum.STARTED.getValue())};
            if (TmcDataServiceHelper.exists((String)"ifm_settcentersetting", (QFilter[])filters)) {
                throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u67e5\u8be2\u4e3a\u5185\u90e8\u91d1\u878d\u673a\u6784\u4e13\u7528\u529f\u80fd\uff0c\u4f60\u672a\u88ab\u6388\u4e88\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650\u3002", (String)"InnerAcctList_0", (String)TMC_IFM_FORMPLUGIN, (Object[])new Object[0])});
            }
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u672a\u542f\u7528", (String)"InnerAcctList_4", (String)TMC_IFM_FORMPLUGIN, (Object[])new Object[0])});
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        CommonFilterColumn filterCol = (CommonFilterColumn)args.getSource();
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"finorg.")) {
            args.getQFilters().addAll(Arrays.asList(this.getFinOrgFilter()));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)"finorg.")) {
            args.getQfilters().addAll(Arrays.asList(this.getFinOrgFilter()));
        }
    }

    private QFilter[] getFinOrgFilter() {
        QFilter finOrgTypeFilter = new QFilter("finorgtype.type", "=", (Object)"1");
        if ("bos_listf7".equals(this.getView().getFormShowParameter().getFormId())) {
            return new QFilter[]{finOrgTypeFilter};
        }
        String entityId = ((BillList)this.getControl("billlistap")).getEntityId();
        if (entityId != null) {
            this.getPageCache().put("entityId", entityId);
        } else {
            entityId = this.getPageCache().get("entityId");
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String appId = this.getView().getFormShowParameter().getAppId();
        List authIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)entityId, (String)"47150e89000000ac");
        QFilter finOrgFilter = new QFilter("org", "in", (Object)authIdList);
        return new QFilter[]{finOrgTypeFilter, finOrgFilter};
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        OperationResult operationResult = evt.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "unclose": 
            case "auth": 
            case "unauth": {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refreshData();
                break;
            }
            case "preclose": {
                this.showInnerAccountCloseDetail();
                break;
            }
            case "relationacc": {
                this.showRelationAcctDetail();
                break;
            }
            case "changeacc": {
                this.showInnerAcctBill();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "thaw": {
                this.beforeThawOp(args);
                break;
            }
            case "frozen": {
                this.beforeFrozenOp(args);
                break;
            }
        }
    }

    private void showRelationAcctDetail() {
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{primaryKeyValue}, (String)"ifm_inneracct");
        DynamicObject innerAccount = (DynamicObject)objectDynamicObjectMap.get(primaryKeyValue);
        Object[] currRelBankAccounts = (Long[])innerAccount.getDynamicObjectCollection("relationacc").stream().map(d -> (Long)d.getDynamicObject("fbasedataid").getPkValue()).toArray(Long[]::new);
        ListShowParameter sp = ShowFormHelper.createShowListForm((String)"bd_accountbanks", (boolean)true);
        sp.setSelectedRows(currRelBankAccounts);
        sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, UPDATE_RELATION_BANK_ACCOUNTS));
        ListFilterParameter lfp = new ListFilterParameter();
        lfp.setFilter(FilterBankAccountsUtil.getBankAccountsFilter(innerAccount, Arrays.asList(currRelBankAccounts)));
        sp.setListFilterParameter(lfp);
        this.getView().showForm((FormShowParameter)sp);
    }

    private void showInnerAccountCloseDetail() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setAppId("ifm");
        parameter.setFormId("ifm_inneracctclosedetail");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_inner_account"));
        this.getView().showForm(parameter);
    }

    private void showInnerAcctBill() {
        Long selectedId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)selectedId)) {
            return;
        }
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("ifm_inneracct");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setPkId((Object)selectedId);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getCustomParams().put("fromchange", "true");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void beforeFrozenOp(BeforeDoOperationEventArgs args) {
        Long selectedId = this.getSelectedId();
        if (selectedId == null) {
            args.setCancel(true);
            return;
        }
        DynamicObject innerAcct = BusinessDataServiceHelper.loadSingleFromCache((Object)selectedId, (String)"ifm_inneracct", (String)SELECT_PROPERTIES);
        if (!InnerAcctStatusEnum.isNormal((String)innerAcct.getString("acctstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u8d26\u6237\u72b6\u6001\u4e3a\u6b63\u5e38\u7684\u5355\u636e\u624d\u80fd\u51bb\u7ed3\u3002", (String)"InnerAcctList_6", (String)TMC_IFM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.showInnerAccountFrozenPage(selectedId, InnerAccountFrozenTypeEnum.ACCOUNT_FROZEN, INNER_ACC_FROZEN);
    }

    private void beforeThawOp(BeforeDoOperationEventArgs args) {
        Long selectedId = this.getSelectedId();
        if (selectedId == null) {
            args.setCancel(true);
            return;
        }
        DynamicObject innerAcct = BusinessDataServiceHelper.loadSingleFromCache((Object)selectedId, (String)"ifm_inneracct", (String)SELECT_PROPERTIES);
        if (!InnerAcctStatusEnum.isFrozen((String)innerAcct.getString("acctstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u8d26\u6237\u72b6\u6001\u4e3a\u51bb\u7ed3\u7684\u5355\u636e\u624d\u80fd\u89e3\u51bb\u3002", (String)"InnerAcctList_7", (String)TMC_IFM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.showInnerAccountFrozenPage(selectedId, InnerAccountFrozenTypeEnum.ACCOUNT_THAW, INNER_ACC_THAW);
    }

    private void showInnerAccountFrozenPage(Long innerAcctId, InnerAccountFrozenTypeEnum frozenTypeEnum, String opration) {
        BillShowParameter showPara = new BillShowParameter();
        showPara.setCustomParam("frozentype", (Object)frozenTypeEnum.getValue());
        showPara.setCustomParam(OPERATION, (Object)opration);
        showPara.setFormId("ifm_accountfrozen");
        showPara.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showPara.setCustomParam("account", (Object)innerAcctId);
        showPara.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)showPara);
    }
}

