/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.interest;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbp.common.util.DateUtils;

public abstract class AbstractIntBillBatchEdit
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entrysGrid = (EntryGrid)this.getControl("entry");
        entrysGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (fieldName.equals("interestamt")) {
            this.showIntDetailForm(evt.getRowIndex());
        } else if (fieldName.equals("intdetailnum")) {
            this.showIntBillForm(evt.getRowIndex());
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map param = this.getView().getFormShowParameter().getCustomParams();
        if (param.containsKey("navparam")) {
            Map navParam = (Map)SerializationUtils.fromJsonString((String)param.get("navparam").toString(), Map.class);
            Date endDate = DateUtils.stringToDate((String)((String)navParam.get("endintdate")), (String)"yyyy-MM-dd");
            if (navParam.containsKey("settlecenter")) {
                Object settleCenterJson = navParam.get("settlecenter");
                Object[] settleCenters = DynamicObjectSerializeUtil.deserialize((String)((String)settleCenterJson), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_finorginfo"));
                DynamicObject settleCenter = (DynamicObject)settleCenters[0];
                this.getModel().setValue("settlecenter", (Object)settleCenter);
                this.getModel().setValue("org", (Object)settleCenter.getDynamicObject("org"));
            }
            this.getModel().setValue("bizdate", (Object)endDate);
            String intsource = navParam.getOrDefault("intsource", null);
            this.getModel().setValue("intsource", (Object)intsource);
        }
        this.loadIntDetail();
    }

    private void showIntDetailForm(int index) {
        FormShowParameter parameter = new FormShowParameter();
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", index);
        String callIntStr = entry.getString("intdetail_tag");
        parameter.getCustomParams().put("intdetail", callIntStr);
        parameter.getCustomParams().put("currency", entry.getDynamicObject("currency").getPkValue());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId("ifm_intbill_detail");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void showIntBillForm(int index) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setPkId(this.getModel().getValue("intbillid", index));
        this.initShowParameter(parameter);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void initShowParameter(BillShowParameter parameter) {
        String formid;
        switch (formid = this.getView().getFormShowParameter().getFormId()) {
            case "ifm_intbill_batch_loan": {
                parameter.setFormId("ifm_interestbill");
                break;
            }
            case "ifm_intbill_batch_current": {
                parameter.setFormId("ifm_currentintbill");
                break;
            }
            case "ifm_preintbill_batch_c": {
                parameter.setFormId("ifm_currentintbill_p");
                parameter.setCaption(ResManager.loadKDString((String)"\u6d3b\u671f\u5b58\u6b3e\u5229\u606f\u9884\u63d0\u8bb0\u8d26\u5904\u7406", (String)"AbstractIntBillBatchEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "ifm_preintbill_batch_l": {
                parameter.setFormId("ifm_preinterestbill");
                parameter.setCaption(ResManager.loadKDString((String)"\u8d37\u6b3e\u9884\u63d0\u5229\u606f\u5355", (String)"AbstractIntBillBatchEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "cfm_intbill_batch_invest": {
                parameter.setFormId("cim_invest_interestbill");
            }
        }
    }

    protected abstract void loadIntDetail();

    protected abstract String getEntityName();
}

