/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.interest;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.IntObjectTypeEnum;
import kd.tmc.ifm.enums.IntSourceEnum;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;

public abstract class AbstractNavAddNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit intObjectF7 = (BasedataEdit)this.getControl("intobject");
        intObjectF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit settleCenter = (BasedataEdit)this.getControl("settlecenter");
        settleCenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"contractbill", "contractnum", "loanbill", "next"});
    }

    public void afterBindData(EventObject e) {
        long currentOrgId;
        DynamicObject settleCenter;
        super.afterBindData(e);
        Map param = this.getView().getFormShowParameter().getCustomParams();
        Object settleCenterId = param.get("settlecenter");
        if (EmptyUtil.isEmpty(settleCenterId) && EmptyUtil.isNoEmpty((DynamicObject)(settleCenter = IfmSettleCenterHelper.getSettleFinByOrg((Long)(currentOrgId = RequestContext.get().getOrgId()))))) {
            settleCenterId = settleCenter.getPkValue();
        }
        if (EmptyUtil.isNoEmpty(settleCenterId)) {
            this.getModel().setValue("settlecenter", settleCenterId);
            this.getView().updateView("settlecenter");
        }
        this.initFilterView();
    }

    public void initFilterView() {
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        Object initParams = customParam.get("initParams");
        if (EmptyUtil.isNoEmpty(initParams)) {
            Map params = (Map)initParams;
            if (params.containsKey("intsource")) {
                this.getModel().setValue("intsource", params.get("intsource"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"intsource"});
                this.getView().updateView("intsource");
                this.getView().setVisible(Boolean.valueOf(!params.containsKey("currentInt")), new String[]{"settlecenter"});
            }
            if (params.containsKey("settlecenter")) {
                this.getModel().setValue("settlecenter", params.get("settlecenter"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"settlecenter"});
                this.getView().updateView("settlecenter");
            }
            if (params.containsKey("bizdate")) {
                this.getModel().setValue("endintdate", (Object)DateUtils.stringToDate((String)((String)params.get("bizdate")), (String)"yyyy-MM-dd"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"endintdate"});
                this.getView().updateView("endintdate");
            }
            if (params.containsKey("orgs")) {
                Set orgs = (Set)SerializationUtils.fromJsonString((String)params.get("orgs").toString(), Set.class);
                this.getModel().setValue("company", (Object)orgs.stream().map(s -> Long.parseLong(s.toString())).toArray());
                this.getView().updateView("company");
            }
            if (params.containsKey("currencys")) {
                Set currencys = (Set)SerializationUtils.fromJsonString((String)params.get("currencys").toString(), Set.class);
                this.getModel().setValue("currency", (Object)currencys.stream().map(s -> Long.parseLong(s.toString())).toArray());
                this.getView().updateView("currency");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String chgPropName;
        super.propertyChanged(e);
        switch (chgPropName = e.getProperty().getName()) {
            case "settlecenter": 
            case "company": 
            case "currency": 
            case "endintdate": {
                this.getModel().setValue("intobject", null);
                this.getModel().setValue("contractbill", null);
                this.getModel().setValue("loanbill", null);
                this.getModel().setValue("contractnum", null);
                break;
            }
            case "intsource": {
                this.getModel().setValue("intobject", null);
                break;
            }
            case "contractbill": 
            case "contractnum": {
                Object newValue = this.getModel().getValue(chgPropName);
                if (!EmptyUtil.isEmpty((Object)newValue)) break;
                this.getPageCache().remove("contractbill");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property;
        switch (property = evt.getProperty().getName()) {
            case "intobject": {
                this.initIntObjectFilter(evt);
                break;
            }
            case "settlecenter": {
                this.initSettleCenterFilter(evt);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("next")) {
            Map<Object, IntBillInfo> calcInterests = this.calcInterest();
            this.validate(args, calcInterests);
            if (!args.isCancel()) {
                this.getPageCache().put("calcIntResult", JSON.toJSONString(calcInterests));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evtArgs) {
        if (StringUtils.equals((CharSequence)"next", (CharSequence)evtArgs.getOperateKey()) && evtArgs.getOperationResult().isSuccess()) {
            Map<String, Object> valMap = this.getNavFilterMap();
            this.getView().returnDataToParent(valMap);
            this.getView().close();
        }
    }

    public List<DynamicObject> getIntObjects() {
        String intObjectEntity = this.isInnerAcctInt() ? "ifm_intobject" : "ifm_extintobject";
        List<Object> intObjects = new ArrayList<DynamicObject>(16);
        List intObjectIds = this.getModel().getDataEntity().getDynamicObjectCollection("intobject").stream().map(v -> v.getDynamicObject("fbasedataid")).filter(EmptyUtil::isNoEmpty).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter qfilter = CollectionUtils.isEmpty(intObjectIds) ? this.getIntObjectFilter() : new QFilter("id", "in", intObjectIds);
        Map intObjectMap = TmcDataServiceHelper.loadFromCache((String)intObjectEntity, (QFilter[])qfilter.toArray());
        if (EmptyUtil.isNoEmpty((Object)intObjectMap)) {
            intObjects = intObjectMap.entrySet().stream().map(v -> (DynamicObject)v.getValue()).collect(Collectors.toList());
        }
        return intObjects;
    }

    protected void validate(BeforeDoOperationEventArgs args, Map<Object, IntBillInfo> calcInterests) {
        if (null == calcInterests || calcInterests.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7ed3\u606f\u7684\u6570\u636e\u3002", (String)"NavAddNewPlugin_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    protected boolean verifyInput() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("viewparam")) {
            return true;
        }
        DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("settlecenter");
        if (EmptyUtil.isEmpty((DynamicObject)settleCenter)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"NavAddNewPlugin_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected QFilter getIntObjectFilter() {
        boolean innerAcctInt = this.isInnerAcctInt();
        DynamicObjectCollection company = (DynamicObjectCollection)this.getModel().getValue("company");
        List companyIds = company.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        DynamicObjectCollection currency = (DynamicObjectCollection)this.getModel().getValue("currency");
        List currencyIds = currency.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        QFilter qfilter = new QFilter("enable", "=", (Object)"1");
        if (innerAcctInt) {
            qfilter.and(new QFilter("biztype", "=", (Object)IntObjectTypeEnum.INTERNAL.getValue()));
            DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("settlecenter");
            if (EmptyUtil.isNoEmpty((DynamicObject)settleCenter)) {
                qfilter.and(new QFilter("intobject.bank", "=", settleCenter.getPkValue()));
            }
            if (EmptyUtil.isNoEmpty(companyIds)) {
                qfilter.and(new QFilter("intobject.company.id", "in", companyIds));
            }
            if (!CollectionUtils.isEmpty(currencyIds)) {
                qfilter.and(new QFilter("intobject.currency.fbasedataid.id", "in", currencyIds));
            }
            this.addIntDateFilter(qfilter);
        } else {
            qfilter.and(new QFilter("biztype", "=", (Object)IntObjectTypeEnum.EXTERNAL.getValue()));
            if (EmptyUtil.isNoEmpty(companyIds)) {
                qfilter.and(new QFilter("org.id", "in", companyIds));
            }
            if (!CollectionUtils.isEmpty(currencyIds)) {
                qfilter.and(new QFilter("currency.id", "in", currencyIds));
            }
        }
        Object loanIds = this.getView().getFormShowParameter().getCustomParams().get("loanIds");
        if (EmptyUtil.isNoEmpty(loanIds)) {
            qfilter.and("id", "not in", loanIds);
        }
        return qfilter;
    }

    protected Map<String, Object> getNavFilterMap() {
        DynamicObjectCollection currency;
        DynamicObjectCollection company;
        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
        DynamicObject settlecenter = (DynamicObject)this.getModel().getValue("settlecenter");
        if (EmptyUtil.isNoEmpty((DynamicObject)settlecenter)) {
            valMap.put("settlecenter", DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{settlecenter}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_finorginfo")));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(company = (DynamicObjectCollection)this.getModel().getValue("company")))) {
            valMap.put("company", company);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(currency = (DynamicObjectCollection)this.getModel().getValue("currency")))) {
            valMap.put("currency", currency);
        }
        Date endDate = (Date)this.getModel().getValue("endintdate");
        valMap.put("endintdate", DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd"));
        String intSource = (String)this.getModel().getValue("intsource");
        valMap.put("intsource", intSource);
        List<DynamicObject> intObjects = this.getIntObjects();
        if (!CollectionUtils.isEmpty(intObjects)) {
            String entityName = intObjects.get(0).getDataEntityType().getName();
            valMap.put("objecttype", entityName);
            List ids = intObjects.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            valMap.put("intObjects", SerializationUtils.toJsonString(ids));
        }
        valMap.put("calcIntResult", this.getPageCache().get("calcIntResult"));
        return valMap;
    }

    private void initIntObjectFilter(BeforeF7SelectEvent evt) {
        boolean innerAcctInt = this.isInnerAcctInt();
        if (innerAcctInt && !this.verifyInput()) {
            evt.setCancel(true);
            return;
        }
        QFilter filter = this.getIntObjectFilter();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        if (!innerAcctInt) {
            showParameter.setBillFormId("ifm_extintobject");
        }
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private void initSettleCenterFilter(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        String appid = this.getView().getFormShowParameter().getAppId();
        Set bankIds = SettleCenterHelper.hasPermissionSettleCenter((String)appid, (String)this.getView().getFormShowParameter().getCustomParams().get("entity").toString(), (String)"47156aff000000ac");
        QFilter filter = new QFilter("id", "in", (Object)bankIds);
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private boolean isInnerAcctInt() {
        String intSource = (String)this.getModel().getValue("intsource");
        return intSource.equals(IntSourceEnum.INNERACCT.getValue());
    }

    private void addIntDateFilter(QFilter qfilter) {
        String intDateField = this.getIntDateField();
        if (EmptyUtil.isEmpty((String)intDateField)) {
            return;
        }
        Date endDate = (Date)this.getModel().getValue("endintdate");
        if (EmptyUtil.isEmpty((Object)endDate)) {
            qfilter.and(new QFilter("id", "=", (Object)0));
        } else {
            qfilter.and(new QFilter(intDateField, "<", (Object)endDate));
        }
    }

    protected abstract Map<Object, IntBillInfo> calcInterest();

    protected abstract String getIntDateField();
}

