/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.interest;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.CurrentBizTypeEnum;
import kd.tmc.ifm.enums.WriteOffStatusEnum;
import kd.tmc.ifm.formplugin.interest.AbstractCurrentIntBillList;
import org.apache.commons.lang3.StringUtils;

public class CurrentIntBillList
extends AbstractCurrentIntBillList {
    @Override
    public QFilter getBizTypeFilter() {
        QFilter qFilter = new QFilter("biztype", "=", (Object)"currentint");
        IFormView listView = this.getView();
        if (listView instanceof ListView) {
            String billFormId;
            ListView view = (ListView)this.getView();
            switch (billFormId = view.getBillFormId()) {
                case "ifm_currentintbill": {
                    qFilter.and(new QFilter("intsource", "in", Arrays.asList("inneracct", "accountview")));
                    break;
                }
                case "ifm_currentintbill_bank": {
                    qFilter.and(new QFilter("intsource", "in", Arrays.asList("bankjournal", "bei")));
                    break;
                }
            }
        }
        return qFilter;
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("id", "not in", this.getIntIds()));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        String isquerydefault;
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        CommonFilterColumn bizDateFilterCol = filterColumnList.stream().filter(filterCol -> StringUtils.equals((CharSequence)filterCol.getFieldName(), (CharSequence)"interestday")).findFirst().orElse(null);
        if (bizDateFilterCol != null && null != (isquerydefault = (String)formShowParameter.getCustomParam("isquerydefault")) && isquerydefault.equals("no")) {
            bizDateFilterCol.setDefaultValue("");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"prewriteoff", "preunwriteoff", "redwriteoff", "unredwriteoff"}) && EmptyUtil.isEmpty((Long)this.getSelectedId())) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"prewriteoff", "preunwriteoff"}) && args.getOperationResult().isSuccess()) {
            List successPkIds = args.getOperationResult().getSuccessPkIds();
            this.noticeUnWriteOffBill(successPkIds, operateKey);
            this.showWriteOffDetail(successPkIds, operateKey);
        } else if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"redwriteoff", "unredwriteoff"})) {
            this.refreshList();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Map returnDataMap = (Map)event.getReturnData();
        if (EmptyUtil.isNoEmpty((Object)returnDataMap)) {
            if (StringUtils.equals((CharSequence)actionId, (CharSequence)"prewriteoff")) {
                this.executeWriteOff(returnDataMap);
            } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"preunwriteoff")) {
                this.executeUnWriteOff(returnDataMap);
            }
        }
    }

    private void executeWriteOff(Map returnDataMap) {
        List intBillIds = (List)JSON.parseObject((String)((String)returnDataMap.get("intBillIds")), List.class);
        OperateOption operate = OperateOption.create();
        operate.setVariableValue("param_writeoff", JSON.toJSONString((Object)returnDataMap));
        OperationResult result = TmcOperateServiceHelper.execOperate((String)"writeoff", (String)"ifm_currentintbill", (Object[])intBillIds.toArray(), (OperateOption)operate);
        if (result != null && result.isSuccess()) {
            this.refreshList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u51b2\u9500\u5b8c\u6210\uff0c\u9884\u63d0\u5355\u72b6\u6001\u5df2\u88ab\u51b2\u9500\u3002", (String)"CurrentIntBillList_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
    }

    private void executeUnWriteOff(Map returnDataMap) {
        List intBillIds = (List)JSON.parseObject((String)((String)returnDataMap.get("intBillIds")), List.class);
        OperationResult result = TmcOperateServiceHelper.execOperate((String)"unwriteoff", (String)"ifm_currentintbill", (Object[])intBillIds.toArray(), (OperateOption)OperateOption.create());
        if (result != null && result.isSuccess()) {
            this.refreshList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u51b2\u9500\u6210\u529f\u3002", (String)"CurrentIntBillList_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
    }

    private void refreshList() {
        this.getView().invokeOperation("refresh");
    }

    private void noticeUnWriteOffBill(List<Object> ids, String operateType) {
        if (!CollectionUtils.isEmpty(ids) && StringUtils.equals((CharSequence)operateType, (CharSequence)"prewriteoff")) {
            DynamicObject selectBill = TmcDataServiceHelper.loadSingle((String)"ifm_currentintbill", (String)"begindate,intobject", (QFilter[])new QFilter[]{new QFilter("id", "=", ids.get(0))});
            DynamicObject intObject = selectBill.getDynamicObject("intobject");
            if (null == intObject) {
                return;
            }
            Date beginDate = selectBill.getDate("begindate");
            boolean exists = TmcDataServiceHelper.exists((String)"ifm_currentintbill", (QFilter[])new QFilter[]{new QFilter("id", "!=", selectBill.getPkValue()), new QFilter("intobject", "=", intObject.getPkValue()), new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue()), new QFilter("begindate", "<", (Object)beginDate), new QFilter("biztype", "=", (Object)CurrentBizTypeEnum.CURRENTINT.getValue())});
            if (exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u524d\u5e8f\u672a\u51b2\u9500\u7684\u7ed3\u606f\u5355\u3002", (String)"CurrentIntBillList_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showWriteOffDetail(List<Object> ids, String operateType) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ifm_interestbill_writeoff");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("intBillIds", ids);
        showParameter.setCustomParam("operateType", (Object)operateType);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateType));
        this.getView().showForm(showParameter);
    }

    private Set<Long> getIntIds() {
        DynamicObjectCollection intbillentries = QueryServiceHelper.query((String)"ifm_intbill_batch_current", (String)"entry.intbillid", (QFilter[])new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{"A", "B"}), new QFilter("entry.intbillid", "!=", (Object)0L)});
        DynamicObjectCollection intbills = QueryServiceHelper.query((String)"ifm_currentintbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)intbillentries.stream().map(o -> o.get("entry.intbillid")).toArray()), new QFilter("billstatus", "=", (Object)"B")});
        HashSet<Long> intIds = new HashSet<Long>();
        intbills.stream().forEach(item -> intIds.add(item.getLong("id")));
        intIds.remove(0L);
        return intIds;
    }
}

