/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.interest;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.IntSourceEnum;
import kd.tmc.ifm.formplugin.interest.AbstractNavAddNewPlugin;
import kd.tmc.ifm.helper.InterestCalcHelper;

public class CurrentIntNavAddNewPlugin
extends AbstractNavAddNewPlugin {
    @Override
    protected Map<Object, IntBillInfo> calcInterest() {
        List<DynamicObject> intObjects = this.getIntObjects();
        HashMap<Object, IntBillInfo> currentInt = new HashMap<Object, IntBillInfo>(16);
        Date endIntDate = (Date)this.getModel().getValue("endintdate");
        String intSource = (String)this.getModel().getValue("intsource");
        if (StringUtils.equals((CharSequence)IntSourceEnum.INNERACCT.getValue(), (CharSequence)intSource)) {
            DynamicObject[] bankAccts;
            Map<Object, DynamicObject> intObjectsMap = intObjects.stream().collect(Collectors.toMap(v -> v.getDynamicObject("intobject").getPkValue(), o -> o));
            Object[] bankAcctIds = intObjects.stream().map(v -> v.getDynamicObject("intobject").getPkValue()).toArray();
            for (DynamicObject bankAcct : bankAccts = TmcDataServiceHelper.load((Object[])bankAcctIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"))) {
                DynamicObject intObject;
                Date lastIntDate;
                DynamicObject currency = ((DynamicObject)bankAcct.getDynamicObjectCollection("currency").get(0)).getDynamicObject("fbasedataid");
                IntBillInfo callInt = InterestCalcHelper.callInt((DynamicObject)bankAcct, (DynamicObject)currency, (Date)DateUtils.getNextDay((Date)(lastIntDate = (intObject = intObjectsMap.get(bankAcct.getPkValue())).getDate("lastintdate")), (int)1), (Date)endIntDate, (boolean)intObject.getBoolean("iscaloverint"));
                if (!EmptyUtil.isNoEmpty((Object)callInt) || !EmptyUtil.isNoEmpty((BigDecimal)callInt.getAmount())) continue;
                currentInt.put(intObject.getPkValue(), callInt);
            }
        } else {
            for (DynamicObject intObject : intObjects) {
                IntBillInfo callInt = InterestCalcHelper.callAccountInt((DynamicObject)intObject, (Date)endIntDate, (boolean)intObject.getBoolean("iscaloverint"), (boolean)false);
                if (!EmptyUtil.isNoEmpty((Object)callInt) || !EmptyUtil.isNoEmpty((BigDecimal)callInt.getAmount())) continue;
                currentInt.put(intObject.getPkValue(), callInt);
            }
        }
        return currentInt;
    }

    @Override
    protected String getIntDateField() {
        return "lastintdate";
    }

    @Override
    protected void validate(BeforeDoOperationEventArgs args, Map<Object, IntBillInfo> calcInterests) {
        super.validate(args, calcInterests);
        if (args.isCancel()) {
            return;
        }
        Map param = this.getView().getFormShowParameter().getCustomParams();
        if (param.containsKey("currentInt")) {
            Set<Object> intObjectIds = calcInterests.keySet();
            Map waiteHandleBillMap = TmcDataServiceHelper.loadFromCache((String)"ifm_intbill_batch_current", (QFilter[])new QFilter[]{new QFilter("entry.intobject", "in", intObjectIds), new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("biztype", "=", (Object)"currentint")});
            if (waiteHandleBillMap.size() > 0) {
                StringJoiner intObjectNumbers = new StringJoiner(",");
                for (Map.Entry entry : waiteHandleBillMap.entrySet()) {
                    DynamicObject waiteHandleBill = (DynamicObject)entry.getValue();
                    DynamicObjectCollection rows = waiteHandleBill.getDynamicObjectCollection("entry");
                    rows.stream().map(v -> v.getDynamicObject("intobject")).filter(v -> intObjectIds.contains(v.getPkValue())).forEach(v -> intObjectNumbers.add(v.getString("number")));
                }
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728%s\u6b63\u5728\u5904\u7406\u7684\u7ed3\u606f\u64cd\u4f5c\uff0c\u8bf7\u5148\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"NavAddNewPlugin_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), intObjectNumbers.toString()));
                args.setCancel(true);
            }
        }
    }
}

