/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.interest;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.SettleIntWriteOffHelper;

public class PreIntBillWriteOffList
extends AbstractBasePlugIn {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadPreIntBill();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"actualinstamt")) {
            this.setAfterChargeAmt();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"btnok") && this.validate()) {
            HashMap<String, Object> returnDataMap = new HashMap<String, Object>();
            List intBillIds = (List)this.getView().getFormShowParameter().getCustomParams().get("intBillIds");
            returnDataMap.put("intBillIds", JSON.toJSONString((Object)intBillIds));
            returnDataMap.put("preIntBillIds", this.getPageCache().get("preIntBillIds"));
            BigDecimal intBillActAmt = (BigDecimal)this.getModel().getValue("actualinstamt");
            BigDecimal actPreIntAmt = (BigDecimal)this.getModel().getValue("actualinstamt");
            BigDecimal writeOffAmt = intBillActAmt.compareTo(actPreIntAmt) > 0 ? actPreIntAmt : intBillActAmt;
            returnDataMap.put("writeoffamt", writeOffAmt);
            this.getView().returnDataToParent(returnDataMap);
            this.getView().close();
        }
    }

    private void loadPreIntBill() {
        String operateType = (String)this.getView().getFormShowParameter().getCustomParams().get("operateType");
        List intBillIds = (List)this.getView().getFormShowParameter().getCustomParams().get("intBillIds");
        Object[] interestBills = TmcDataServiceHelper.load((String)"ifm_currentintbill", (String)"batchnoid,currency,actualinstamt,intobject,currency,biztype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)intBillIds)});
        if (EmptyUtil.isEmpty((Object[])interestBills)) {
            return;
        }
        DynamicObject[] preIntBills = this.getPreIntBills(operateType, (DynamicObject[])interestBills);
        this.batchInsertEntry(preIntBills);
        this.setPreIntInfo(preIntBills, (DynamicObject[])interestBills, operateType);
        this.cachePreInt(preIntBills);
    }

    private DynamicObject[] getPreIntBills(String operateType, DynamicObject[] interestBills) {
        DynamicObject[] preIntBills = StringUtils.equals((CharSequence)operateType, (CharSequence)"prewriteoff") ? SettleIntWriteOffHelper.getPreIntBills((DynamicObject[])interestBills, null) : SettleIntWriteOffHelper.getWriteOffPreIntBills((DynamicObject[])interestBills);
        return preIntBills;
    }

    private void batchInsertEntry(DynamicObject[] preIntBills) {
        ArrayList billList = new ArrayList(preIntBills.length);
        for (DynamicObject preIntBill : preIntBills) {
            DynamicObject bankAcct;
            HashMap<String, Object> billMap = new HashMap<String, Object>(preIntBills.length);
            billMap.put("id", preIntBill.getPkValue());
            billMap.put("billno", preIntBill.getString("billno"));
            DynamicObject intObject = preIntBill.getDynamicObject("intobject");
            if (EmptyUtil.isNoEmpty((DynamicObject)intObject) && EmptyUtil.isNoEmpty((DynamicObject)(bankAcct = intObject.getDynamicObject("intobject")))) {
                billMap.put("bankacct", bankAcct.getString("bankaccountnumber"));
            }
            billMap.put("settlecenter", preIntBill.getDynamicObject("settlecenter").getString("name"));
            billMap.put("currency", preIntBill.getDynamicObject("currency"));
            billMap.put("preintdate", preIntBill.getDate("interestday"));
            billMap.put("actualamt", preIntBill.getBigDecimal("actualinstamt"));
            billMap.put("nowriteoffamt", preIntBill.getBigDecimal("nowriteoffamt"));
            billList.add(billMap);
        }
        TmcViewInputHelper.batchFillEntity((String)"entrys", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), billList);
    }

    private void setPreIntInfo(DynamicObject[] preIntBills, DynamicObject[] interestBills, String operateType) {
        BigDecimal intBillActAmt;
        boolean isWriteOff = StringUtils.equals((CharSequence)operateType, (CharSequence)"prewriteoff");
        this.getView().setEnable(Boolean.valueOf(isWriteOff), new String[]{"actualinstamt"});
        BigDecimal noWriteOffAmt = SettleIntWriteOffHelper.getTotalPreIntBillAmt((DynamicObject[])preIntBills);
        this.getModel().setValue("actpreinstamt", (Object)noWriteOffAmt);
        if (isWriteOff) {
            intBillActAmt = Arrays.stream(interestBills).map(v -> v.getBigDecimal("actualinstamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            intBillActAmt = noWriteOffAmt.compareTo(intBillActAmt) > 0 ? intBillActAmt : noWriteOffAmt;
        } else {
            DynamicObject[] writeOffRelations = SettleIntWriteOffHelper.getWriteOffRelations((DynamicObject[])interestBills);
            intBillActAmt = Arrays.stream(writeOffRelations).map(v -> v.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        this.getModel().setValue("actualinstamt", (Object)intBillActAmt);
        this.setAfterChargeAmt();
        DynamicObject currency = interestBills[0].getDynamicObject("currency");
        this.getModel().setValue("instcurrency", (Object)currency);
    }

    private void cachePreInt(DynamicObject[] preIntBills) {
        if (EmptyUtil.isNoEmpty((Object[])preIntBills)) {
            List preIntBillIds = Arrays.stream(preIntBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            this.getPageCache().put("preIntBillIds", JSON.toJSONString(preIntBillIds));
        }
    }

    private void setAfterChargeAmt() {
        BigDecimal actualInstAmt = (BigDecimal)this.getModel().getValue("actualinstamt");
        BigDecimal actPreInstAmt = (BigDecimal)this.getModel().getValue("actpreinstamt");
        BigDecimal afterChargeInstAmt = actPreInstAmt.compareTo(actualInstAmt) < 0 ? Constants.ZERO : actPreInstAmt.subtract(actualInstAmt);
        this.getModel().setValue("afterchargeinstamt", (Object)afterChargeInstAmt);
    }

    private boolean validate() {
        BigDecimal intBillActAmt = (BigDecimal)this.getModel().getValue("actualinstamt");
        if (null == intBillActAmt || intBillActAmt.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5355\u51b2\u9500\u91d1\u989d\u4e3a\u96f6\uff0c\u4e0d\u80fd\u63d0\u4ea4", (String)"PreIntBillWriteOffList_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

