/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.intobject;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.UseStatusEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.formplugin.intobject.IntObjectBaseEdit;

public class IntObjectEdit
extends IntObjectBaseEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit inneracct = (BasedataEdit)this.getControl("intobject");
        inneracct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit referrate = (BasedataEdit)this.getControl("referrate");
        referrate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit intinneracct = (BasedataEdit)this.getControl("intinneracct");
        intinneracct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "intobject": {
                this.innerAcctFilter(evt);
                break;
            }
            case "referrate": {
                this.referRateFilter(evt);
                break;
            }
            case "intinneracct": {
                this.intInnerAcctFilter(evt);
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        QFilter qFilter;
        DynamicObject bdAccount;
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object accountId = showParameter.getCustomParam("innerAccountId");
        if (EmptyUtil.isNoEmpty((Object)accountId) && EmptyUtil.isNoEmpty((DynamicObject)(bdAccount = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,number,name,company,inneracct,defaultcurrency", (QFilter[])(qFilter = new QFilter("inneracct", "=", accountId)).toArray())))) {
            this.getModel().setValue("intobject", bdAccount.getPkValue());
            this.setOtherValueByBdAccount(bdAccount);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.checkupdate()) {
            String enable = this.getModel().getDataEntity().getString("enable");
            if (enable.equals("0")) {
                this.getModel().setValue("status", (Object)BillStatusEnum.SAVE.getValue());
                this.getView().setEnable(Boolean.FALSE, new String[]{"intobject", "datasource"});
            } else {
                this.getView().setEnable(Boolean.FALSE, ENABLE_KEYS);
                this.getView().setVisible(Boolean.FALSE, VISIBLE_KEYS);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "disable": {
                if (!this.checkupdate()) break;
                this.getView().setEnable(Boolean.TRUE, ENABLE_KEYS);
                this.getView().setVisible(Boolean.TRUE, VISIBLE_KEYS);
                break;
            }
            case "enable": {
                this.getView().setEnable(Boolean.FALSE, ENABLE_KEYS);
                this.getView().setVisible(Boolean.FALSE, VISIBLE_KEYS);
            }
        }
    }

    private void intInnerAcctFilter(BeforeF7SelectEvent evt) {
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"intobject")) {
            evt.setCancel(true);
            return;
        }
        DynamicObject inneracct = this.getModel().getDataEntity().getDynamicObject("intobject");
        DynamicObjectCollection currencys = inneracct.getDynamicObjectCollection("currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencys)) {
            long currencyId = ((DynamicObject)currencys.get(0)).getDynamicObject("fbasedataid").getLong("id");
            QFilter filter = new QFilter("currency.fbasedataid", "=", (Object)currencyId).and(this.getFilterByFInOrg(false)).and(new QFilter("bank", "=", inneracct.getDynamicObject("bank").getPkValue())).and(TmcAccountHelper.getAccountBankFilterByOrg((Long)inneracct.getDynamicObject("company").getLong("id")));
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            sp.setCaption(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237", (String)"IntObjectEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            sp.setCustomParam("isclearcorefilter", (Object)true);
            sp.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private void referRateFilter(BeforeF7SelectEvent evt) {
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"intobject", "startintdate"})) {
            evt.setCancel(true);
            return;
        }
        DynamicObject inneracct = this.getModel().getDataEntity().getDynamicObject("intobject");
        DynamicObjectCollection currencys = inneracct.getDynamicObjectCollection("currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencys)) {
            long currencyId = ((DynamicObject)currencys.get(0)).getDynamicObject("fbasedataid").getLong("id");
            QFilter qFilter = new QFilter("currency", "=", (Object)currencyId);
            qFilter.and(new QFilter("hist_entry.e_effectivedate", "<=", this.getModel().getValue("startintdate")));
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            sp.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private void innerAcctFilter(BeforeF7SelectEvent evt) {
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        sp.setCaption(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237", (String)"IntObjectEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        sp.setCustomParam("isclearcorefilter", (Object)true);
        sp.getListFilterParameter().getQFilters().add(this.getFilterByFInOrg(true));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "intobject": {
                DynamicObject inneracct = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.setOtherValueByBdAccount(inneracct);
                break;
            }
        }
    }

    private QFilter getFilterByFInOrg(boolean isNearAcct) {
        DynamicObjectCollection inneAccts;
        List finOrgIdList = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id", (QFilter[])this.getFinOrgFilter()).stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("finorg", "in", finOrgIdList);
        if (isNearAcct) {
            qFilter.and(new QFilter("isdrawobject", "=", (Object)"0"));
            qFilter.and(new QFilter("interest", "=", (Object)"1"));
        }
        qFilter = EmptyUtil.isNoEmpty((DynamicObjectCollection)(inneAccts = QueryServiceHelper.query((String)"ifm_inneracct", (String)"id", (QFilter[])new QFilter[]{qFilter}))) ? new QFilter("inneracct", "in", inneAccts.stream().map(d -> d.getLong("id")).collect(Collectors.toSet())) : new QFilter("id", "=", (Object)0);
        return qFilter;
    }

    private QFilter[] getFinOrgFilter() {
        QFilter finOrgTypeFilter = new QFilter("finorgtype.type", "=", (Object)"1");
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String appId = this.getView().getFormShowParameter().getAppId();
        List authIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"ifm_inneracct", (String)"47150e89000000ac");
        QFilter finOrgFilter = new QFilter("org", "in", (Object)authIdList);
        return new QFilter[]{finOrgTypeFilter, finOrgFilter, this.getSettleCenterids()};
    }

    private QFilter getSettleCenterids() {
        QFilter[] filters = new QFilter[]{new QFilter("usestatus", "=", (Object)UseStatusEnum.STARTED.getValue())};
        DynamicObjectCollection settleSettings = QueryServiceHelper.query((String)"ifm_settcentersetting", (String)"id,settlecenter", (QFilter[])filters);
        HashSet<Long> settleCenterids = new HashSet<Long>(settleSettings.size());
        for (DynamicObject settleSetting : settleSettings) {
            settleCenterids.add(settleSetting.getLong("settlecenter"));
        }
        return new QFilter("id", "in", settleCenterids);
    }

    private boolean checkupdate() {
        DynamicObject intObject = BusinessDataServiceHelper.loadSingle((String)"ifm_intobject", (String)"id,inneracct,lastintdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getModel().getDataEntity().getLong("id"))});
        return EmptyUtil.isNoEmpty((DynamicObject)intObject);
    }

    private void setOtherValueByBdAccount(DynamicObject inneracct) {
        if (inneracct == null) {
            return;
        }
        this.getModel().setValue("intinneracct", (Object)inneracct);
        this.getModel().setValue("org", (Object)inneracct.getDynamicObject("company"));
        DynamicObject innertAcct = BusinessDataServiceHelper.loadSingle((Object)inneracct.getDynamicObject("inneracct").getPkValue(), (String)"ifm_inneracct", (String)"interestdate");
        Date intDate = innertAcct.getDate("interestdate");
        if (EmptyUtil.isNoEmpty((Object)intDate)) {
            this.getModel().setValue("lastintdate", (Object)intDate);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"lastintdate"});
        } else {
            this.getModel().setValue("lastintdate", this.getModel().getValue("startintdate"));
        }
        this.getModel().setValue("currency", (Object)inneracct.getDynamicObject("defaultcurrency"));
        this.getModel().setValue("name", (Object)inneracct.getString("name"));
    }
}

