/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.intobject;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.UseStatusEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.ServiceCategoryEnum;
import kd.tmc.ifm.formplugin.intobject.IntObjectBaseEdit;

public class IntObjectbatchEdit
extends IntObjectBaseEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit inneracct = (BasedataEdit)this.getControl("intobject");
        inneracct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit referrate = (BasedataEdit)this.getControl("referrate");
        referrate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit intinneracct = (BasedataEdit)this.getControl("intinneracct");
        intinneracct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "intobject": {
                this.innerAcctFilter(evt);
                break;
            }
            case "referrate": {
                this.referrateFilter(evt);
                break;
            }
            case "intinneracct": {
                this.intinnerAcctFilter(evt);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (propName) {
            case "intobject": {
                this.setOtherValueByBdAccount(changeData);
                break;
            }
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryKey = e.getEntryProp().getName();
        int currRow = e.getRowDataEntities()[0].getRowIndex();
        switch (entryKey) {
            case "entryentity": {
                this.setInitAccumByDate(currRow);
                break;
            }
        }
    }

    private QFilter getFilterByFInOrg(boolean isNearAcct) {
        DynamicObjectCollection inneAccts;
        List finOrgIdList = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id", (QFilter[])this.getFinOrgFilter()).stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("finorg", "in", finOrgIdList);
        if (isNearAcct) {
            qFilter.and(new QFilter("isdrawobject", "=", (Object)"0"));
            qFilter.and(new QFilter("interest", "=", (Object)"1"));
        }
        qFilter = EmptyUtil.isNoEmpty((DynamicObjectCollection)(inneAccts = QueryServiceHelper.query((String)"ifm_inneracct", (String)"id", (QFilter[])new QFilter[]{qFilter}))) ? new QFilter("inneracct", "in", inneAccts.stream().map(d -> d.getLong("id")).collect(Collectors.toSet())) : new QFilter("id", "=", (Object)0);
        return qFilter;
    }

    private void intinnerAcctFilter(BeforeF7SelectEvent evt) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject bankAcct = (DynamicObject)this.getModel().getValue("intobject", entryCurrentRowIndex);
        if (bankAcct == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5185\u90e8\u94f6\u884c\u8d26\u6237\u3002", (String)"IntObjectEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObjectCollection currs = bankAcct.getDynamicObjectCollection("currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currs)) {
            long currId = ((DynamicObject)currs.get(0)).getDynamicObject("fbasedataid").getLong("id");
            QFilter filter = new QFilter("currency.fbasedataid", "=", (Object)currId).and(this.getFilterByFInOrg(false)).and(new QFilter("company", "=", bankAcct.getDynamicObject("company").getPkValue())).and(new QFilter("bank", "=", bankAcct.getDynamicObject("bank").getPkValue()));
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            sp.setCaption(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237", (String)"IntObjectEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            sp.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private void referrateFilter(BeforeF7SelectEvent evt) {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        HashSet<Long> currencyIds = new HashSet<Long>(16);
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject innerAcct = (DynamicObject)this.getModel().getValue("intobject", i);
            if (innerAcct == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u4f53\u4fe1\u606f\u7b2c%s\u884c\u5185\u90e8\u94f6\u884c\u8d26\u6237\u3002", (String)"IntObjectEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), i + 1));
                evt.setCancel(true);
                currencyIds.clear();
                break;
            }
            DynamicObjectCollection currs = innerAcct.getDynamicObjectCollection("currency");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)currs)) continue;
            currencyIds.add(((DynamicObject)currs.get(0)).getDynamicObject("fbasedataid").getLong("id"));
        }
        if (currencyIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u4f53\u4fe1\u606f\u4e2d\u7684\u5185\u90e8\u94f6\u884c\u8d26\u6237\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u3002", (String)"IntObjectEdit_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            currencyIds.clear();
            return;
        }
        if (currencyIds.size() > 0) {
            QFilter filter = new QFilter("currency", "=", currencyIds.iterator().next()).and(new QFilter("servicecategory", "=", (Object)ServiceCategoryEnum.DEPOSIT.getValue()).and(new QFilter("productterm", "=", (Object)"-")));
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            sp.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private void innerAcctFilter(BeforeF7SelectEvent evt) {
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        sp.getListFilterParameter().getQFilters().add(this.getFilterByFInOrg(true));
        sp.setCaption(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237", (String)"IntObjectEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
    }

    private QFilter[] getFinOrgFilter() {
        QFilter finOrgTypeFilter = new QFilter("finorgtype.type", "=", (Object)"1");
        Long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"ifm_inneracct", (String)"47150e89000000ac");
        QFilter finOrgFilter = new QFilter("org", "in", (Object)authIdList);
        return new QFilter[]{finOrgTypeFilter, finOrgFilter, this.getSettleCenterids()};
    }

    private QFilter getSettleCenterids() {
        QFilter[] filters = new QFilter[]{new QFilter("usestatus", "=", (Object)UseStatusEnum.STARTED.getValue())};
        DynamicObjectCollection settleSettings = QueryServiceHelper.query((String)"ifm_settcentersetting", (String)"id,settlecenter", (QFilter[])filters);
        HashSet<Long> settleCenterids = new HashSet<Long>(settleSettings.size());
        for (DynamicObject settleSetting : settleSettings) {
            settleCenterids.add(settleSetting.getLong("settlecenter"));
        }
        return new QFilter("id", "in", settleCenterids);
    }

    private void setOtherValueByBdAccount(ChangeData changeData) {
        DynamicObject inneracct = (DynamicObject)changeData.getNewValue();
        if (inneracct == null) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        this.getModel().setValue("currency", (Object)inneracct.getDynamicObject("defaultcurrency"), rowIndex);
    }

    private void setInitAccumByDate(int rowIndex) {
        Object startIntDate = this.getModel().getValue("startintdate");
        Object lastIntDate = this.getModel().getValue("lastintdate");
        this.setInitAccum(startIntDate, lastIntDate, rowIndex);
    }
}

