/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.loanbill;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.DrawTypeEnum;
import kd.tmc.ifm.helper.IfmSysParamHelper;
import kd.tmc.ifm.resource.IfmBizResource;

public class IfmLoanBillEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit repayAcctBank = (BasedataEdit)this.getControl("repayacctbank");
        repayAcctBank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "repayacctbank": {
                this.repayAcctBankFilter(evt);
            }
        }
    }

    private void repayAcctBankFilter(BeforeF7SelectEvent evt) {
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"contractbillno", "org", "currency"})) {
            evt.setCancel(true);
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject settlecenter = (DynamicObject)this.getModel().getValue("settlecenter");
        QFilter filter = new QFilter("currency.fbasedataid", "=", currency.getPkValue());
        QFilter acctFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)org.getLong("id"));
        filter.and(acctFilter);
        filter.and(new QFilter("bank.id", "=", settlecenter.getPkValue()));
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        sp.getListFilterParameter().getQFilters().add(filter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "loaneracctbank": {
                DynamicObject loanAcctBank = (DynamicObject)e.getChangeSet()[0].getNewValue();
                DynamicObject repayAcctBank = (DynamicObject)this.getModel().getValue("repayacctbank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)loanAcctBank) || !EmptyUtil.isEmpty((DynamicObject)repayAcctBank)) break;
                this.getModel().setValue("repayacctbank", (Object)loanAcctBank);
                break;
            }
            case "bizdate": 
            case "drawamount": 
            case "contractbillno": {
                this.setLoanAbstract();
                break;
            }
            case "currency": {
                this.loanCurrencyChg(e);
            }
        }
    }

    private void loanCurrencyChg(PropertyChangedArgs e) {
        boolean isDiffCurrency;
        DynamicObject currency = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject oldCurrency = (DynamicObject)e.getChangeSet()[0].getOldValue();
        DynamicObject contractcny = (DynamicObject)this.getModel().getValue("contractcny");
        boolean bl = isDiffCurrency = currency != null && contractcny != null && oldCurrency != null && !currency.getPkValue().equals(oldCurrency.getPkValue());
        if (isDiffCurrency && !currency.getPkValue().equals(contractcny.getPkValue())) {
            this.getModel().setValue("repayacctbank", null);
        }
    }

    private void setLoanAbstract() {
        if (OperationStatus.VIEW == this.getView().getFormShowParameter().getStatus() || !BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
            return;
        }
        String contractbill = (String)this.getModel().getValue("contractbillno");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String loandate = sdf.format(this.getModel().getValue("bizdate"));
        String currency = this.getModel().getDataEntity().getString("currency.sign");
        BigDecimal drawamount = (BigDecimal)this.getModel().getValue("drawamount");
        String drawamountStr = "";
        if (drawamount != null) {
            drawamountStr = drawamount.setScale(this.getModel().getDataEntity().getInt("currency.amtprecision")).toPlainString();
        }
        this.getModel().setValue("abstract", (Object)String.format(ResManager.loadKDString((String)"\u5408\u540c\u5355\u636e\u53f7%1$s %2$s\u653e\u6b3e%3$s%4$s", (String)"IfmLoanBillEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), contractbill, loandate, currency, drawamountStr));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("push2bankinstbill".equals(operate.getOperateKey())) {
            args.setCancel(true);
            String billStatus = (String)this.getModel().getValue("billstatus");
            String drawType = (String)this.getModel().getValue("drawtype");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus) || DrawTypeEnum.DRAWING.getValue().equals(drawType) || DrawTypeEnum.CLOSEOUT.getValue().equals(drawType)) {
                String message = ResManager.loadKDString((String)"\u5df2\u653e\u6b3e\u6216\u5df2\u90e8\u5206\u6536\u56de\u6216\u5df2\u8fd8\u6e05\u7684\u653e\u6b3e\u5355\u53ef\u4ee5\u64cd\u4f5c\u7ed3\u606f", (String)"IfmLoanBillEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(message);
                return;
            }
            this.openIntBatchEdit();
        } else if ("push2repaybill".equals(operate.getOperateKey())) {
            DynamicObject loancontractbill = (DynamicObject)this.getModel().getValue("loancontractbill");
            IfmBizResource ifmBizResource = new IfmBizResource();
            DynamicObject contractBill = TmcDataServiceHelper.loadSingle((String)"cfm_loancontractbill", (String)"notrepayamount", (QFilter[])new QFilter[]{new QFilter("id", "=", loancontractbill.getPkValue())});
            BigDecimal notRepayAmount = contractBill.getBigDecimal("notrepayamount");
            if (EmptyUtil.isEmpty((BigDecimal)notRepayAmount)) {
                this.getView().showTipNotification(ifmBizResource.getUnRepayAmtIsNotNull());
                args.setCancel(true);
                return;
            }
        }
    }

    protected void openIntBatchEdit() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId("cfm_navigate_addnew");
        String dJson = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{this.getModel().getDataEntity()}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_loanbill"));
        boolean isPayIntByPlan = this.isPayIntByPlan(this.getModel().getDataEntity());
        parameter.setCustomParam("loanbill", (Object)dJson);
        DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("settlecenter");
        parameter.setCustomParam("settlecenter", (Object)settleCenter.getLong("id"));
        parameter.setCustomParam("loanInt", (Object)true);
        parameter.setCustomParam("fromLoanBill", (Object)true);
        parameter.setCustomParam("isPayIntByPlan", (Object)isPayIntByPlan);
        parameter.setCustomParam("formid", (Object)"ifm_intbill_batch_loan");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_FILTER"));
        StyleCss sc = new StyleCss();
        sc.setHeight("340px");
        parameter.getOpenStyle().setInlineStyleCss(sc);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_FILTER", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.setFormId("ifm_intbill_batch_loan");
            parameter.setCustomParam("navparam", evt.getReturnData());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_EXIST"));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private boolean isPayIntByPlan(DynamicObject loanBill) {
        DynamicObject org = loanBill.getDynamicObject("creditorg");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return false;
        }
        return IfmSysParamHelper.getAppBoolParameter((String)TmcAppEnum.CFM.getId(), (long)org.getLong("id"), (String)"cfm012");
    }
}

