/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.payacceptancebill;

import java.math.BigDecimal;
import java.text.Format;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.enums.AcctClassifyEnum;
import kd.tmc.fbp.common.enums.BalanceTypeEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.BizBalanceModelHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.PayAcceptBizStatusEnum;
import kd.tmc.ifm.enums.PaymentChanEnum;
import kd.tmc.ifm.enums.SettleMentTypeEnum;
import kd.tmc.ifm.enums.TransTypeEnum;
import kd.tmc.ifm.formplugin.common.ExchangeRateEdit;
import kd.tmc.ifm.helper.BankAccountBalanceHelper;

public class PayAcceptanceBillEdit
extends ExchangeRateEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.setFinOrgF7Filter();
        this.setFinAccF7Filter();
        this.setSettleTypeF7Filter();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object transType = this.getModel().getValue("transtype");
        this.getView().setVisible(Boolean.valueOf(TransTypeEnum.isAgentPay((Object)transType) || TransTypeEnum.isLinkagePAY((Object)transType)), new String[]{"flexpanelap"});
        this.setPayerInfo4Lb();
        this.setPayeeInfo4Lb();
        this.setAgentFlexname(transType);
        this.setBankBalance();
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        String key;
        super.afterDoOperation(arg);
        OperationResult operationResult = arg.getOperationResult();
        AbstractOperate op = (AbstractOperate)arg.getSource();
        switch (key = op.getOperateKey()) {
            case "refuse": {
                if (!operationResult.isSuccess()) {
                    return;
                }
                String billStatus = (String)this.getModel().getValue("billstatus");
                String bizStatus = (String)this.getModel().getValue("bizstatus");
                if (bizStatus.equals(PayAcceptBizStatusEnum.REFUSED.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9000\u5355\u7684\u5355\u636e\u65e0\u6cd5\u518d\u6b21\u9000\u5355\u3002", (String)"PayAcceptanceBillEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!billStatus.equals(BillStatusEnum.SAVE.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u9000\u5355\u3002", (String)"PayAcceptanceBillEdit_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("ifm_payacceptance_back");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "bar_refuse");
                formShowParameter.setCloseCallBack(callBack);
                this.getView().showForm(formShowParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"bar_refuse")) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            String reason = (String)returnData.get("reason");
            this.getModel().setValue("reason", (Object)reason);
            this.getModel().setValue("backdate", (Object)new Date());
            this.getModel().setValue("backuser", (Object)RequestContext.get().getUserId());
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"backbill", (String)"ifm_payacceptancebill", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u5355\u6210\u529f\u3002", (String)"TransactionBillEdit_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                this.getView().updateView();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9000\u5355\u5931\u8d25\u3002", (String)"TransactionBillEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        switch (fieldKey) {
            case "agentpayeraccount": {
                this.propChgAgentAcount((DynamicObject)changeData[0].getNewValue());
                this.setBankBalance();
                break;
            }
            case "agentfinorgcat": {
                long newId;
                DynamicObject oldValue = (DynamicObject)changeData[0].getOldValue();
                DynamicObject newValue = (DynamicObject)changeData[0].getNewValue();
                long oldId = oldValue == null ? 0L : (Long)oldValue.getPkValue();
                long l = newId = newValue == null ? 0L : (Long)newValue.getPkValue();
                if (oldId == 0L || oldId == newId) break;
                this.getModel().setValue("agentfinorg", null);
                this.getModel().setValue("agentpayeraccount", null);
                break;
            }
            case "agentfinorg": {
                long newId;
                DynamicObject oldValue = (DynamicObject)changeData[0].getOldValue();
                DynamicObject newValue = (DynamicObject)changeData[0].getNewValue();
                long oldId = oldValue == null ? 0L : (Long)oldValue.getPkValue();
                long l = newId = newValue == null ? 0L : (Long)newValue.getPkValue();
                if (oldId == 0L || oldId == newId) break;
                this.getModel().setValue("agentpayeraccount", null);
                break;
            }
            case "paymentchannel": {
                this.propChgChannel();
            }
        }
    }

    private void propChgChannel() {
        String paymentChannel = (String)this.getModel().getValue("paymentchannel");
        boolean isBei = PaymentChanEnum.BEI.getValue().equals(paymentChannel);
        this.getView().setVisible(Boolean.valueOf(isBei), new String[]{"recaccbanknameflex1"});
    }

    private void propChgAgentAcount(DynamicObject newValue) {
        if (newValue != null) {
            boolean isSetBankInterface = newValue.getBoolean("issetbankinterface");
            boolean isOpenBank = newValue.getBoolean("isopenbank");
            String chanNel = PaymentChanEnum.COUNTER.getValue();
            if (isSetBankInterface) {
                chanNel = PaymentChanEnum.BEI.getValue();
            } else if (isOpenBank) {
                chanNel = PaymentChanEnum.ONLINEBANK.getValue();
            }
            DynamicObject bankObject = newValue.getDynamicObject("bank");
            Long bankId = (Long)bankObject.getPkValue();
            QFilter qFilter = new QFilter("id", "=", (Object)bankId);
            bankObject = BusinessDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"id,bank_cate", (QFilter[])qFilter.toArray());
            DynamicObject bankCateObject = bankObject.getDynamicObject("bank_cate");
            this.getModel().beginInit();
            this.getModel().setValue("agentfinorg", (Object)bankObject);
            this.getModel().setValue("agentfinorgcat", (Object)bankCateObject);
            this.getModel().endInit();
            this.getModel().setValue("paymentchannel", (Object)chanNel);
            this.getView().updateView("agentfinorg");
            this.getView().updateView("agentfinorgcat");
        }
    }

    private void setPayerInfo4Lb() {
        String defaultUrl = "/kingdee/tmc/images/pc/icon/entrance/sky_fkf_80_80.png";
        Image orgPic = (Image)this.getControl("orgpic");
        orgPic.setUrl(defaultUrl);
        DynamicObject payerAcctBankObject = (DynamicObject)this.getModel().getValue("payeracctbank");
        DynamicObject currencyObject = (DynamicObject)this.getModel().getValue("currency");
        if (payerAcctBankObject == null || currencyObject == null) {
            return;
        }
        Long acctBankId = (Long)payerAcctBankObject.getPkValue();
        Long currencyId = (Long)currencyObject.getPkValue();
        String labCurrencySign = currencyObject.getString("sign");
        int currencyAmtprecision = currencyObject.getInt("amtprecision");
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
        fobj.getCurrencyFormat().setCurrencySymbols(labCurrencySign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(currencyAmtprecision);
        Format currencyFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
        BizBalanceModelBean balance = BizBalanceModelHelper.getRunningBalance((String)BalanceTypeEnum.BALANCE.getValue(), (long)acctBankId, (long)currencyId);
        if (balance != null && balance.getAmount() != null) {
            ((Label)this.getControl("balancev")).setText(currencyFormat.format(balance.getAmount()));
        }
    }

    private void setPayeeInfo4Lb() {
        Image payeePic = (Image)this.getControl("payeepic");
        String defaultUrl = "/kingdee/tmc/images/pc/icon/entrance/sky_skf_80_80.png";
        payeePic.setUrl(defaultUrl);
        ((Label)this.getControl("recaccbanknametext")).setText((String)this.getModel().getValue("recaccbankname"));
    }

    private void setFinOrgF7Filter() {
        BasedataEdit finOrg = (BasedataEdit)this.getControl("agentfinorg");
        finOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject bankCateObject = (DynamicObject)this.getModel().getValue("agentfinorgcat");
            if (bankCateObject != null) {
                ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                Long id = (Long)bankCateObject.get("id");
                showPara.getListFilterParameter().setFilter(new QFilter("bank_cate.id", "=", (Object)id));
            }
        });
    }

    private void setFinAccF7Filter() {
        BasedataEdit finAcc = (BasedataEdit)this.getControl("agentpayeraccount");
        finAcc.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject currencyObject;
            DynamicObject finOrg;
            QFilter accFilter = new QFilter("acctclassify", "!=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue()).and("bank.bank_cate.number", "!=", (Object)"BC-9999").and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
            DynamicObject bankCateObject = (DynamicObject)this.getModel().getValue("agentfinorgcat");
            if (bankCateObject != null) {
                accFilter.and(new QFilter("bank.bank_cate.id", "=", bankCateObject.get("id")));
            }
            if ((finOrg = (DynamicObject)this.getModel().getValue("agentfinorg")) != null) {
                accFilter.and(new QFilter("bank.id", "=", finOrg.get("id")));
            }
            accFilter.and(new QFilter("currency.fbasedataid.id", "in", (currencyObject = (DynamicObject)this.getModel().getValue("currency")) == null ? "" : currencyObject.getPkValue()));
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showPara.getListFilterParameter().setFilter(accFilter);
        });
    }

    private void setSettleTypeF7Filter() {
        BasedataEdit settleTypeControl = (BasedataEdit)this.getControl("settletype");
        settleTypeControl.addBeforeF7SelectListener(evt -> {
            DynamicObject settleType;
            DynamicObjectCollection settlementTypes;
            DynamicObject payAcct = (DynamicObject)this.getModel().getValue("agentpayeraccount");
            ListShowParameter showPara = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = showPara.getListFilterParameter().getQFilters();
            if (EmptyUtil.isNoEmpty((DynamicObject)payAcct) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(settlementTypes = payAcct.getDynamicObjectCollection("settlementtype")))) {
                QFilter filter = new QFilter("id", "in", settlementTypes.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet()));
                qFilters.add(filter);
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(settleType = (DynamicObject)this.getModel().getValue("settletype")))) {
                String type = settleType.getString("settlementtype");
                boolean isCdm = SettleMentTypeEnum.isBankOrBusiness((String)type) || SettleMentTypeEnum.isCheck((String)type) || SettleMentTypeEnum.isPromissory((String)type);
                qFilters.add(new QFilter("settlementtype", isCdm ? "in" : "not in", (Object)new String[]{"1", "2", "5", "6"}));
            }
        });
    }

    private void setAgentFlexname(Object transType) {
        if (TransTypeEnum.isLinkagePAY((Object)transType)) {
            HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
            String flexCon = ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u94f6\u884c\u8d26\u6237\u4fe1\u606f", (String)"PayAcceptanceBillEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
            props.put("text", new LocaleString(flexCon));
            this.getView().updateControlMetadata("flexpanelap", props);
        }
    }

    private void setBankBalance() {
        DynamicObject bankAccount = (DynamicObject)this.getModel().getValue("agentpayeraccount");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)bankAccount) && EmptyUtil.isNoEmpty((DynamicObject)org) && EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            String labCurrencySign = currency.getString("sign");
            int currencyAmtprecision = currency.getInt("amtprecision");
            FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
            fobj.getCurrencyFormat().setCurrencySymbols(labCurrencySign);
            fobj.getCurrencyFormat().setMinimumFractionDigits(currencyAmtprecision);
            Format currencyFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
            BigDecimal bankBalance = BankAccountBalanceHelper.getBankBalance((Long)bankAccount.getLong("id"), (Long)org.getLong("id"), (Long)currency.getLong("id"));
            if (bankBalance != null) {
                ((Label)this.getControl("curbalancev")).setText(currencyFormat.format(bankBalance));
                return;
            }
        }
        ((Label)this.getControl("curbalancev")).setText("");
    }
}

