/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.payacceptancebill;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.PayAcceptBizStatusEnum;

public class PayAcceptanceBillListPlugin
extends AbstractTmcBillBaseList {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        String key;
        super.afterDoOperation(arg);
        OperationResult operationResult = arg.getOperationResult();
        AbstractOperate op = (AbstractOperate)arg.getSource();
        switch (key = op.getOperateKey()) {
            case "refuse": {
                this.doRefuse(operationResult);
                break;
            }
            case "fillagent": {
                this.fillAgentInfo(operationResult);
            }
        }
    }

    private void fillAgentInfo(OperationResult operationResult) {
        if (!operationResult.isSuccess()) {
            return;
        }
        List<Long> selectIds = this.getSelectedIdList();
        if (null == selectIds) {
            return;
        }
        if (selectIds.size() > 1000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u80fd\u8d85\u8fc7100\u6761\u3002", (String)"PayAcceptanceBillListPlugin_7", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ifm_fillagentinfo");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("ids", selectIds);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "tblagent");
        formShowParameter.setCloseCallBack(callBack);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "tblrefuse": {
                HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
                this.refuseBack(returnData);
                break;
            }
            case "tblagent": {
                boolean result = (Boolean)closedCallBackEvent.getReturnData();
                if (!result) break;
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refreshData();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"PayAcceptanceBillListPlugin_6", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void refuseBack(Map<String, Object> returnData) {
        DynamicObject[] dynamicObjects;
        List<Long> selectIds = this.getSelectedIdList();
        String backDescr = (String)returnData.get("reason");
        QFilter filter = new QFilter("id", "in", selectIds);
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"ifm_payacceptancebill", (String)"id,billno,billstatus,reason,backdate,backuser,sourcebillid,bizstatus", (QFilter[])filter.toArray())) {
            dynamicObject.set("reason", (Object)backDescr);
            dynamicObject.set("backdate", (Object)new Date());
            dynamicObject.set("backuser", (Object)RequestContext.get().getUserId());
        }
        OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"backbill", (String)"ifm_payacceptancebill", (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u5355\u6210\u529f\u3002", (String)"PayAcceptanceBillListPlugin_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9000\u5355\u5931\u8d25\u3002", (String)"PayAcceptanceBillListPlugin_4", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refreshData();
    }

    protected List<Long> getSelectedIdList() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ArrayList<Long> idList = new ArrayList<Long>(selectedRows.size());
        if (selectedRows.isEmpty()) {
            return null;
        }
        for (ListSelectedRow listSelectedRowValue : selectedRows) {
            idList.add((Long)listSelectedRowValue.getPrimaryKeyValue());
        }
        return idList;
    }

    private void doRefuse(OperationResult operationResult) {
        if (!operationResult.isSuccess()) {
            return;
        }
        List<Long> selectIds = this.getSelectedIdList();
        if (null == selectIds) {
            return;
        }
        QFilter filter = new QFilter("id", "in", selectIds);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"ifm_payacceptancebill", (String)"billstatus,bizstatus", (QFilter[])filters);
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            String billStatus = ((DynamicObject)dynamicObjects.get(i)).getString("billstatus");
            String bizStatus = ((DynamicObject)dynamicObjects.get(i)).getString("bizstatus");
            if (bizStatus.equals(PayAcceptBizStatusEnum.REFUSED.getValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9000\u5355\u7684\u5355\u636e\u65e0\u6cd5\u518d\u6b21\u9000\u5355\u3002", (String)"PayAcceptanceBillEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (billStatus.equals(BillStatusEnum.SAVE.getValue())) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u9000\u5355\u3002", (String)"PayAcceptanceBillEdit_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ifm_payacceptance_back");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "tblrefuse");
        formShowParameter.setCloseCallBack(callBack);
        this.getView().showForm(formShowParameter);
    }
}

