/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.preint;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.CurrentBizTypeEnum;
import kd.tmc.ifm.enums.PreIntOperateTypeEnum;
import kd.tmc.ifm.formplugin.interest.AbstractIntBillBatchEdit;
import kd.tmc.ifm.helper.BatchIntHelper;

public class CurrentPreIntBillBatchEdit
extends AbstractIntBillBatchEdit
implements RowClickEventListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"entry", (CharSequence)entryGrid.getKey())) {
            int index = evt.getRow();
            if (index < 0) {
                return;
            }
            this.loanIntEntry(index);
        }
    }

    private void loanIntEntry(int index) {
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", index);
        this.getModel().setValue("intnum", (Object)entry.getString("intdetailnum"));
        if (EmptyUtil.isNoEmpty((DynamicObject)entry.getDynamicObject("intobject"))) {
            this.getModel().setValue("preloannum", entry.getDynamicObject("intobject").get("name"));
        }
        BatchIntHelper.loanIntDetailInfo((DynamicObject)entry, (AbstractFormPlugin)this, (IDataModel)this.getModel());
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        this.loanIntEntry(0);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "deleteentryloans": {
                String errMsg = this.checkLoansEntry();
                if (EmptyUtil.isNoEmpty((String)errMsg)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(errMsg);
                    return;
                }
                this.dealInterest();
                break;
            }
            case "addentryloans": {
                args.setCancel(true);
                this.openAddNewNavigateForm(this.initParams());
                break;
            }
        }
    }

    private void openAddNewNavigateForm(FormShowParameter showParameter) {
        showParameter.setFormId("ifm_navigate_pre_addnew");
        showParameter.getCustomParams().put("entity", this.getEntityName());
        showParameter.getCustomParams().put("formid", this.getEntityName());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_FILTER"));
        this.getView().showForm(showParameter);
    }

    private FormShowParameter initParams() {
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        List loanIds = entrys.stream().map(dny -> dny.getDynamicObject("intobject").getPkValue()).collect(Collectors.toList());
        showParameter.getCustomParams().put("loanIds", loanIds);
        initParams.put("settlecenter", ((DynamicObject)this.getModel().getValue("settlecenter")).getPkValue());
        initParams.put("bizdate", this.getModel().getValue("bizdate"));
        HashSet<String> orgIds = new HashSet<String>(entrys.size());
        HashSet<String> currenyIds = new HashSet<String>(entrys.size());
        for (DynamicObject dyn : entrys) {
            orgIds.add(dyn.getDynamicObject("company").getPkValue().toString());
            currenyIds.add(dyn.getDynamicObject("currency").getPkValue().toString());
        }
        initParams.put("orgs", orgIds);
        initParams.put("currencys", currenyIds);
        showParameter.getCustomParams().put("initParams", initParams);
        return showParameter;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_FILTER", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            Map navparam = (Map)evt.getReturnData();
            List<Map<String, Object>> intDetail = this.genIntDetails(navparam);
            TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), intDetail, (boolean)false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey)) {
            this.getView().updateView();
        } else if ("deleteentryloans".equals(operateKey)) {
            this.getView().invokeOperation("save");
        }
        this.loanIntEntry(0);
    }

    private void dealInterest() {
        DynamicObjectCollection batchPreIntEntrys = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        for (int i = 0; i < indexs.length; ++i) {
            Long id = ((DynamicObject)batchPreIntEntrys.get(indexs[i])).getLong("intbillid");
            if (!EmptyUtil.isNoEmpty((Long)id) || !TmcDataServiceHelper.exists((Object)id, (String)"ifm_currentintbill")) continue;
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"ifm_currentintbill", (Object[])new Object[]{id}, (OperateOption)operateOption, (boolean)true);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_currentintbill", (Object[])new Object[]{id}, (OperateOption)operateOption, (boolean)true);
        }
    }

    private String checkLoansEntry() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        if (cl.size() == indexs.length) {
            return ResManager.loadKDString((String)"\u81f3\u5c11\u6709\u4e00\u6761\u5206\u5f55", (String)"CurrentPreIntBillBatchEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if ("reverseintamt".equals(property)) {
            BigDecimal preIntAmt = (BigDecimal)e.getChangeSet()[0].getNewValue();
            this.getModel().setValue("interestamt", (Object)preIntAmt);
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        super.hyperLinkClick(evt);
        if (evt.getFieldName().equals("sumpreint")) {
            this.showSumPreInts(evt.getRowIndex());
        }
    }

    @Override
    protected void loadIntDetail() {
        JSONObject navParam = (JSONObject)this.getView().getFormShowParameter().getCustomParams().get("navparam");
        String interestType = navParam.getString("interesttype");
        String operateType = navParam.getString("operatetype");
        String endintdate = navParam.getString("endintdate");
        this.getModel().setValue("interesttype", (Object)interestType);
        this.getModel().setValue("operateType", (Object)operateType);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("startdatemap", navParam.get((Object)"startdatemap"));
        paramMap.put("interesttype", interestType);
        paramMap.put("operateType", operateType);
        paramMap.put("calcIntResult", navParam.get((Object)"calcIntResult"));
        paramMap.put("intObjects", navParam.get((Object)"intObjects"));
        paramMap.put("objecttype", navParam.get((Object)"objecttype"));
        List<Map<String, Object>> intDetail = this.genIntDetails(paramMap);
        TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), intDetail);
    }

    public List<Map<String, Object>> genIntDetails(Map<String, Object> paramMap) {
        List ids = (List)SerializationUtils.fromJsonString((String)paramMap.get("intObjects").toString(), List.class);
        String entityName = paramMap.get("objecttype").toString();
        DynamicObject[] intObjects = TmcDataServiceHelper.load((String)entityName, (String)"biztype,intobject,org,currency,name,id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        Map<Object, DynamicObject> intObjectMap = Arrays.stream(intObjects).collect(Collectors.toMap(v -> v.getDynamicObject("intobject").getPkValue(), p -> p));
        Map calcIntResult = (Map)JSON.parseObject((String)((String)paramMap.get("calcIntResult")), (TypeReference)new TypeReference<Map<Object, IntBillInfo>>(){}, (Feature[])new Feature[0]);
        ArrayList<Map<String, Object>> intDetails = new ArrayList<Map<String, Object>>(calcIntResult.size());
        Set bankAcctIds = calcIntResult.keySet();
        DynamicObject[] bankAccts = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"company,currency", (QFilter[])new QFilter("id", "in", bankAcctIds).toArray());
        Map bankAcctMap = Arrays.stream(bankAccts).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        calcIntResult.forEach((entryJson, intDetail) -> {
            DynamicObject bankAcct = (DynamicObject)bankAcctMap.get(entryJson);
            if (null != bankAcct) {
                this.fillIntDetail(bankAcct, (IntBillInfo)intDetail, (List<Map<String, Object>>)intDetails, (DynamicObject)intObjectMap.get(entryJson));
            }
        });
        return intDetails;
    }

    protected void fillIntDetail(DynamicObject bankAcct, IntBillInfo intBill, List<Map<String, Object>> dataMap, DynamicObject intObject) {
        if (EmptyUtil.isEmpty((Object)intBill) || EmptyUtil.isEmpty((BigDecimal)intBill.getAmount())) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("company", bankAcct.getDynamicObject("company"));
        data.put("inneracct", bankAcct);
        data.put("intobject", intObject);
        data.put("currency", ((DynamicObject)bankAcct.getDynamicObjectCollection("currency").get(0)).getDynamicObject("fbasedataid"));
        data.put("inttype", "currentint");
        Date beginDate = intBill.getBeginDate();
        Date endDate = intBill.getEndDate();
        data.put("startdate", beginDate);
        data.put("enddate", endDate);
        if (beginDate != null && endDate != null) {
            data.put("intdays", TermHelper.getDiffDays((Date)beginDate, (Date)endDate) + 1);
        }
        List details = intBill.getDetails();
        BigDecimal principle = details.stream().map(IntBillDetailInfo::getPrinciple).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        data.put("principle", principle);
        details.sort((arg0, arg1) -> arg1.getEndDate().compareTo(arg0.getEndDate()));
        data.put("rate", ((IntBillDetailInfo)details.get(0)).getRate());
        data.put("notpreint", intBill.getAmount());
        this.getView().setVisible(Boolean.FALSE, new String[]{"reverseintamt"});
        data.put("interestamt", intBill.getAmount());
        data.put("sumpreint", this.getTotalPreIntAmt(bankAcct));
        data.put("actualinstamt", intBill.getAmount());
        data.put("isreverse", Boolean.FALSE);
        data.put("isinterest", Boolean.FALSE);
        data.put("intdetail_tag", SerializationUtils.toJsonString((Object)intBill));
        dataMap.add(data);
    }

    private void fillIntDetail(List<DynamicObject> entrys, List<Map<String, Object>> dataMap) {
        for (DynamicObject entry : entrys) {
            HashMap<String, Object> entryMap = new HashMap<String, Object>(32);
            DynamicObject innerAcct = entry.getDynamicObject("inneracct");
            entryMap.put("inttype", entry.getString("inttype"));
            entryMap.put("startdate", entry.getDate("startdate"));
            entryMap.put("enddate", entry.getDate("enddate"));
            entryMap.put("intdays", entry.getInt("intdays"));
            entryMap.put("principle", entry.getBigDecimal("principle"));
            entryMap.put("rate", entry.getBigDecimal("rate"));
            entryMap.put("sumpreint", this.getTotalPreIntAmt(innerAcct));
            entryMap.put("notpreint", Constants.ZERO);
            entryMap.put("reverseintamt", entry.getBigDecimal("interestamt"));
            entryMap.put("interestamt", entry.getBigDecimal("interestamt"));
            entryMap.put("isreverse", Boolean.FALSE);
            entryMap.put("isinterest", Boolean.FALSE);
            entryMap.put("currency", entry.getDynamicObject("currency"));
            entryMap.put("inneracct", innerAcct);
            entryMap.put("company", entry.getDynamicObject("company"));
            entryMap.put("intdetail_tag", entry.get("intdetail_tag"));
            entryMap.put("sourceentryid", entry.getPkValue());
            dataMap.add(entryMap);
        }
    }

    protected List<DynamicObject> loadLastPreIntData(Object[] bankAccts) {
        List bankAcctIds = Arrays.stream(bankAccts).map(bankAcct -> ((DynamicObject)bankAcct).getPkValue()).collect(Collectors.toList());
        QFilter filter = new QFilter("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue());
        filter.and(new QFilter("entry.isreverse", "!=", (Object)true));
        filter.and(new QFilter("entry.isinterest", "!=", (Object)true));
        filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        filter = filter.and(new QFilter("entry.inneracct.id", "in", bankAcctIds));
        Object[] preIntBills = TmcDataServiceHelper.load((String)"ifm_intbill_batch_pre", (String)"id,inttype,startdate,enddate,intdays,principle,rate,currency,interestamt,sumpreint,notpreint,reverseintamt,inneracct,company,intdetail_tag,sourceentryid", (QFilter[])filter.toArray());
        ArrayList<DynamicObject> preIntBillEntrys = new ArrayList<DynamicObject>();
        if (EmptyUtil.isNoEmpty((Object[])preIntBills)) {
            DynamicObjectCollection entrys = new DynamicObjectCollection();
            for (Object preIntBill : preIntBills) {
                DynamicObjectCollection colls = preIntBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : colls) {
                    if (!bankAcctIds.contains(entry.getDynamicObject("inneracct").getPkValue())) continue;
                    entrys.add((Object)entry);
                }
            }
            Map<Object, List<DynamicObject>> groupByAcct = entrys.stream().collect(Collectors.groupingBy(v -> v.getDynamicObject("inneracct")));
            groupByAcct.forEach((bankAcct, preIntBillLEntrys) -> {
                preIntBillLEntrys.sort(new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject arg0, DynamicObject arg1) {
                        return arg1.getDate("enddate").compareTo(arg0.getDate("enddate"));
                    }
                });
                preIntBillEntrys.add((DynamicObject)preIntBillLEntrys.get(0));
            });
        }
        return preIntBillEntrys;
    }

    private BigDecimal getTotalPreIntAmt(DynamicObject innerAcct) {
        DynamicObject[] preIntBills = this.getSumPreIntBills(innerAcct);
        BigDecimal amount = BigDecimal.ZERO;
        for (DynamicObject preIntBill : preIntBills) {
            amount = CurrentBizTypeEnum.PREINT.getValue().equals(preIntBill.getString("biztype")) ? amount.add(preIntBill.getBigDecimal("amount")) : amount.subtract(preIntBill.getBigDecimal("amount"));
        }
        return amount;
    }

    private void showSumPreInts(int rowIndex) {
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", rowIndex);
        DynamicObject innerAcct = entry.getDynamicObject("inneracct");
        List preIntBillIds = Arrays.stream(this.getSumPreIntBills(innerAcct)).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        ListShowParameter show = new ListShowParameter();
        show.setBillFormId("ifm_currentintbill_p");
        show.getListFilterParameter().setFilter(new QFilter("id", "in", preIntBillIds));
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)show);
    }

    private DynamicObject[] getSumPreIntBills(DynamicObject bankAcct) {
        QFilter filter = new QFilter("entry.inneracct.id", "=", bankAcct.getPkValue());
        filter = filter.and(new QFilter("interesttype", "=", (Object)"currentint"));
        filter = filter.and(new QFilter("entry.intsettleid", "=", (Object)0).or(QFilter.isNull((String)"entry.intsettleid")));
        DynamicObject[] batchIntBills = TmcDataServiceHelper.load((String)"ifm_intbill_batch_pre", (String)"id,billno", (QFilter[])filter.toArray());
        Set billNoSet = Arrays.stream(batchIntBills).map(v -> v.getString("billno")).collect(Collectors.toSet());
        filter = new QFilter("inneracct.id", "=", bankAcct.getPkValue());
        filter = filter.and(new QFilter("batchno", "in", (Object)billNoSet.toArray()));
        filter = filter.and(new QFilter("biztype", "in", (Object)new String[]{"preint", "reversepreint"}));
        DynamicObject[] preIntBills = TmcDataServiceHelper.load((String)"ifm_currentintbill", (String)"biztype,amount", (QFilter[])filter.toArray());
        return preIntBills;
    }

    @Override
    protected String getEntityName() {
        return "ifm_intbill_batch_pre";
    }
}

