/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.preint;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.ifm.enums.BillTypeEnum;

public class PreIntBillBatchList
extends AbstractTmcListPlugin {
    public void setFilter(SetFilterEvent e) {
        e.setMainOrgQFilter(null);
        e.getQFilters().add(new QFilter("biztype", "=", (Object)BillTypeEnum.PREINT.getValue()));
        this.addViewParamFilter(e);
        this.addBankCenterFilter(e);
    }

    private void addViewParamFilter(SetFilterEvent e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String viewParam = (String)parameter.getCustomParams().get("viewparam");
        QFilter qfilter = StringUtils.equals((CharSequence)viewParam, (CharSequence)"ifm#loanpreint") ? new QFilter("interesttype", "=", (Object)"preint") : new QFilter("interesttype", "=", (Object)"currentint");
        e.getQFilters().add(qfilter);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        ListView source = (ListView)e.getSource();
        BillShowParameter billShowParameter = e.getParameter();
        if (billShowParameter.getFormId().startsWith("ifm_")) {
            if (OperationStatus.EDIT == e.getParameter().getStatus() || OperationStatus.VIEW == e.getParameter().getStatus()) {
                Long id = (Long)e.getParameter().getPkId();
                DynamicObject preBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"ifm_intbill_batch_pre", (String)"interesttype");
                if ("preint".equals(preBill.getString("interesttype"))) {
                    e.getParameter().setFormId("ifm_preintbill_batch_l");
                } else {
                    e.getParameter().setFormId("ifm_preintbill_batch_c");
                }
            }
        } else {
            billShowParameter.setFormId(source.getBillFormId());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        List<String> singleOps = Arrays.asList("submit", "unsubmit", "audit", "unaudit");
        Set selectEdPks = args.getListSelectedData().stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toSet());
        if (!args.isCancel() && singleOps.contains(operate.getOperateKey()) && selectEdPks.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\u3002", (String)"IntBillBatchList_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    protected String getBankCenterField() {
        return "settlecenter.id";
    }

    private void addBankCenterFilter(SetFilterEvent e) {
        Set<Long> bankIds = this.getAuthorizedBankCenterIds();
        List filters = e.getQFilters();
        for (QFilter fi : filters) {
            if (!fi.getProperty().equals(this.getBankCenterField())) continue;
            return;
        }
        if (EmptyUtil.isNoEmpty(bankIds)) {
            QFilter filter = new QFilter(this.getBankCenterField(), "in", bankIds);
            e.getQFilters().add(filter);
        }
    }

    private Set<Long> getAuthorizedBankCenterIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (EmptyUtil.isNoEmpty((String)appId)) {
            return SettleCenterHelper.hasPermissionSettleCenter((String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem());
        }
        return Collections.emptySet();
    }
}

