/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.preint;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.PreIntOperateTypeEnum;
import kd.tmc.ifm.formplugin.interest.AbstractNavAddNewPlugin;
import kd.tmc.ifm.helper.InterestCalcHelper;

public class PreIntBillNavAddNewPlugin
extends AbstractNavAddNewPlugin {
    @Override
    protected void validate(BeforeDoOperationEventArgs args, Map<Object, IntBillInfo> calcInterests) {
        String operateType = (String)this.getModel().getValue("operatetype");
        if (StringUtils.equals((CharSequence)operateType, (CharSequence)PreIntOperateTypeEnum.PREINT.getValue())) {
            this.validatePreInt(args, calcInterests);
        }
    }

    @Override
    protected Map<String, Object> getNavFilterMap() {
        String depositType;
        Map<String, Object> navFilterMap = super.getNavFilterMap();
        IDataModel model = this.getModel();
        navFilterMap.put("interesttype", "currentint");
        String operateType = (String)model.getValue("operatetype");
        if (EmptyUtil.isNoEmpty((String)operateType)) {
            navFilterMap.put("operatetype", operateType);
        }
        if (EmptyUtil.isNoEmpty((String)(depositType = (String)model.getValue("deposittype")))) {
            navFilterMap.put("deposittype", depositType);
        }
        if (EmptyUtil.isNoEmpty((String)this.getPageCache().get("startdatemap"))) {
            navFilterMap.put("startdatemap", this.getPageCache().get("startdatemap"));
        }
        navFilterMap.put("formid", "ifm_intbill_batch_pre");
        return navFilterMap;
    }

    @Override
    protected Map<Object, IntBillInfo> calcInterest() {
        Map<String, Object> filterMap = this.getIntParamMap();
        List intCalls = (List)filterMap.get("callIntData");
        HashMap<Object, IntBillInfo> interestInfo = new HashMap<Object, IntBillInfo>(16);
        Date endIntDate = (Date)filterMap.get("endintdate");
        Map<Object, DynamicObject> innerAcctMap = PreIntBillNavAddNewPlugin.getInnerAcctMap(intCalls);
        for (DynamicObject intCall : intCalls) {
            DynamicObject currency;
            Date intStartDate = InterestCalcHelper.getIntObjectStartPreIntDate((DynamicObject)intCall);
            DynamicObject innerAcct = innerAcctMap.get(intCall.getDynamicObject("intobject").getPkValue());
            IntBillInfo callInt = InterestCalcHelper.callInt((DynamicObject)innerAcct, (DynamicObject)(currency = ((DynamicObject)innerAcct.getDynamicObjectCollection("currency").get(0)).getDynamicObject("fbasedataid")), (Date)intStartDate, (Date)endIntDate, (boolean)intCall.getBoolean("iscaloverint"), (boolean)true);
            if (!EmptyUtil.isNoEmpty((Object)callInt) || callInt.getAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            interestInfo.put(innerAcct.getPkValue(), callInt);
        }
        return interestInfo;
    }

    @Override
    protected String getIntDateField() {
        return "lastpreintdate";
    }

    private static Map<Object, DynamicObject> getInnerAcctMap(List<DynamicObject> intObjects) {
        if (EmptyUtil.isEmpty(intObjects)) {
            return new HashMap<Object, DynamicObject>();
        }
        Object[] ids = intObjects.stream().map(v -> v.getDynamicObject("intobject")).filter(EmptyUtil::isNoEmpty).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] bankAccts = TmcDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
        return Arrays.stream(bankAccts).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
    }

    private Map<String, Object> getIntParamMap() {
        HashMap<String, Object> intParamMap = new HashMap<String, Object>(2);
        intParamMap.put("endintdate", this.getModel().getValue("endintdate"));
        intParamMap.put("callIntData", this.getIntObjects());
        return intParamMap;
    }

    private void validatePreInt(BeforeDoOperationEventArgs args, Map<Object, IntBillInfo> calcInterests) {
        if (null == calcInterests || calcInterests.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u9884\u63d0\u7684\u6570\u636e\u3002", (String)"PreIntBillNavAddNewPlugin_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(4);
        qfilters.add(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
        qfilters.add(new QFilter("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue()));
        ArrayList<Object> intObecjs = new ArrayList<Object>(calcInterests.keySet());
        qfilters.add(new QFilter("entry.inneracct.id", "in", intObecjs));
        this.validateOnWayBill(qfilters.toArray(new QFilter[0]), intObecjs, args);
    }

    private void validateOnWayBill(QFilter[] qfilters, List<Object> intObjs, BeforeDoOperationEventArgs args) {
        Object[] onWayBills = TmcDataServiceHelper.load((String)"ifm_intbill_batch_pre", (String)"id,entry,inneracct,entry.loannum,loanbillid", (QFilter[])qfilters);
        if (EmptyUtil.isEmpty((Object[])onWayBills)) {
            return;
        }
        String operateType = (String)this.getModel().getValue("operatetype");
        StringJoiner errorObjNumbers = new StringJoiner(",");
        for (Object onWayBill : onWayBills) {
            DynamicObjectCollection entrys = onWayBill.getDynamicObjectCollection("entry");
            entrys.stream().map(v -> v.getDynamicObject("inneracct")).filter(v -> intObjs.contains(v.getPkValue())).forEach(v -> errorObjNumbers.add(v.getString("bankaccountnumber")));
        }
        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728%1$s\u6b63\u5728\u5904\u7406\u7684%2$s\u64cd\u4f5c\uff0c\u8bf7\u5148\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"PreIntBillNavAddNewPlugin_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), errorObjNumbers.toString(), PreIntOperateTypeEnum.getName((String)operateType)));
        args.setCancel(true);
    }
}

