/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.product;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.ServiceCategoryEnum;

public class LDProductEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public static final String FINORGTYPE_TYPE = "finorgtype.type";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit rateproductEdit = (BasedataEdit)this.getControl("referrate");
        rateproductEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ceter = (BasedataEdit)this.getControl("center");
        ceter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setFields();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.checkReference();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "referrate": {
                this.setRateProductFilter(evt);
                break;
            }
            case "center": {
                this.setCenterFilter(evt);
                break;
            }
        }
    }

    public void setRateProductFilter(BeforeF7SelectEvent evt) {
        if (this.getModel().getValue("currency") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5e01\u79cd\u201d\u3002", (String)"ProductEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter showPara = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showPara.getListFilterParameter().getQFilters();
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        qFilters.add(new QFilter("currency", "=", (Object)currency.getLong("id")));
    }

    private void setCenterFilter(BeforeF7SelectEvent evt) {
        ListShowParameter showPara = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showPara.getListFilterParameter().getQFilters();
        String appId = EmptyUtil.isEmpty((String)showPara.getAppId()) ? "ifm" : showPara.getAppId();
        List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"ifm", (String)"ifm_ldproduct", (String)"47150e89000000ac");
        qFilters.add(new QFilter("org", "in", (Object)orgIdList));
        qFilters.add(new QFilter(FINORGTYPE_TYPE, "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue()));
    }

    public void afterCreateNewData(EventObject e) {
        this.setDefaultCenter();
    }

    private void setDefaultCenter() {
        long orgId;
        List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"ifm", (String)"ifm_ldproduct", (String)"47150e89000000ac");
        if (orgIdList.contains(orgId = RequestContext.get().getOrgId())) {
            QFilter clearinghouseFilter = new QFilter(FINORGTYPE_TYPE, "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
            QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
            QFilter[] qFilters = new QFilter[]{clearinghouseFilter, orgFilter};
            DynamicObject clearinghouse = BusinessDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"id,number,name", (QFilter[])qFilters);
            if (clearinghouse != null) {
                this.getModel().setValue("center", (Object)clearinghouse);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("servicecategory".equals(propName) || "currency".equals(propName)) {
            this.getModel().setValue("referrate", null);
        }
        if ("ratetype".equals(propName)) {
            this.setFields();
        }
    }

    private void setFields() {
        String rateType = (String)this.getModel().getValue("ratetype");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!InterestTypeEnum.FLOAT.getValue().equals(rateType) ? 1 : 0) != 0, (String[])new String[]{"productprice"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)InterestTypeEnum.FLOAT.getValue().equals(rateType), (String[])new String[]{"referrate", "ratesignbp", "ratefloatpoints"});
    }

    private void checkReference() {
        String number;
        DynamicObject investVarieties;
        String serviceCategory;
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus opStatus = billShowParameter.getStatus();
        if (opStatus == OperationStatus.ADDNEW) {
            return;
        }
        DynamicObject product = this.getModel().getDataEntity();
        boolean refrenced = BaseDataRefrenceHelper.isRefrenced((String)product.getDataEntityType().getName(), (Object)product.getPkValue());
        if (!refrenced && !StringUtils.equals((CharSequence)(serviceCategory = (String)this.getModel().getValue("servicecategory")), (CharSequence)ServiceCategoryEnum.LOAN.getValue()) && EmptyUtil.isNoEmpty((DynamicObject)(investVarieties = TmcDataServiceHelper.loadSingle((String)"cim_investvarieties", (String)"id", (QFilter[])new QFilter("number", "=", (Object)(number = (String)this.getModel().getValue("number"))).toArray())))) {
            refrenced = BaseDataRefrenceHelper.isRefrenced((String)investVarieties.getDataEntityType().getName(), (Object)investVarieties.getPkValue());
        }
        this.getView().setEnable(Boolean.valueOf(!refrenced), new String[]{"servicecategory"});
    }
}

