/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.product;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.FloatDirectionEnum;
import kd.tmc.ifm.enums.ItemCategoryEnum;
import kd.tmc.ifm.enums.ServiceCategoryEnum;
import org.apache.commons.lang3.StringUtils;

public class ProductEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String CURRENT_CODE = "-";
    private static final String DAY_7_CODE = "week";
    private static final String MONTH_3_CODE = "season";
    private static final String YEAR_1_CODE = "oneYear";
    private static final String YEAR_5_CODE = "fiveYear";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit referrateF7 = (BasedataEdit)this.getControl("referrate");
        referrateF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String propName = args.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)args.getFormShowParameter();
        switch (propName) {
            case "referrate": {
                if (!this.checkMustInput()) {
                    return;
                }
                Object currency = this.getModel().getValue("currency");
                Object productterm = this.getModel().getValue("productterm");
                QFilter filter = new QFilter("currency", "=", ((DynamicObject)currency).getPkValue()).and("term", "=", productterm);
                formShowParameter.getListFilterParameter().getQFilters().add(filter);
            }
        }
    }

    public void afterLoadData(EventObject e) {
        Object pageType = this.getView().getFormShowParameter().getCustomParam("pageType");
        boolean isFromChange = Objects.equals(pageType, "change");
        if (isFromChange) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
        } else {
            boolean isRef = BaseDataRefrenceHelper.isRefrenced((String)this.getModel().getDataEntityType().getName(), (Object)this.getModel().getDataEntity().getPkValue());
            if (isRef) {
                this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            }
        }
    }

    private boolean checkMustInput() {
        Object currency = this.getModel().getValue("currency");
        Object productterm = this.getModel().getValue("productterm");
        if (EmptyUtil.isEmpty((Object)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5e01\u79cd\u201d\u3002", (String)"ProductEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)productterm)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4ea7\u54c1\u671f\u9650\u201d\u3002", (String)"ProductEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject product;
        String propName = e.getProperty().getName();
        if ("servicecategory".equals(propName) || "category".equals(propName) || "productterm".equals(propName) || "currency".equals(propName)) {
            this.getModel().setValue("referrate", null);
            this.getView().updateView("referrate");
        }
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("servicecategory".equals(propName)) {
            this.fillComboItems(newValue);
            if (Objects.equals(ServiceCategoryEnum.DEPOSIT.getName(), this.getModel().getValue("servicecategory"))) {
                this.setPriceNumMustInput();
            }
        } else if ("floatrate".equals(propName)) {
            this.getModel().setValue("price_num", (Object)0);
            this.getModel().setValue("price", null);
            product = this.getModel().getDataEntity();
            if (!product.getBoolean("floatrate")) {
                this.setPriceNumMustInput();
            } else {
                this.setReferateMustInput();
            }
        } else if ("category".equals(propName)) {
            this.setProductTermByCategory(newValue);
        }
        if ((product = this.getModel().getDataEntity()).getBoolean("floatrate")) {
            this.setListPrice(propName);
        }
    }

    private void setReferateMustInput() {
        FieldEdit fieldEdit = (FieldEdit)this.getView().getControl("referrate");
        fieldEdit.setMustInput(true);
    }

    private void setPriceNumMustInput() {
        FieldEdit fieldEdit = (FieldEdit)this.getView().getControl("price_num");
        fieldEdit.setMustInput(true);
    }

    private void setProductTermByCategory(Object newValue) {
        if (Objects.equals(newValue, ItemCategoryEnum.CURRENT.getValue()) || Objects.equals(newValue, ItemCategoryEnum.AGREEMENT.getValue())) {
            this.getModel().setValue("productterm", (Object)CURRENT_CODE);
        } else if (Objects.equals(newValue, ItemCategoryEnum.NOTICE.getValue())) {
            this.getModel().setValue("productterm", (Object)DAY_7_CODE);
        } else if (Objects.equals(newValue, ItemCategoryEnum.REGULAR.getValue())) {
            this.getModel().setValue("productterm", (Object)MONTH_3_CODE);
        } else if (Objects.equals(newValue, ItemCategoryEnum.SHORT.getValue())) {
            this.getModel().setValue("productterm", (Object)YEAR_1_CODE);
        } else if (Objects.equals(newValue, ItemCategoryEnum.MEDIUM_LONG.getValue()) || Objects.equals(newValue, ItemCategoryEnum.LONG.getValue())) {
            this.getModel().setValue("productterm", (Object)YEAR_5_CODE);
        }
    }

    private void setListPrice(String propName) {
        DynamicObject product = this.getModel().getDataEntity();
        if (Objects.equals(propName, "referrate") || Objects.equals(propName, "floatdirection") || Objects.equals(propName, "floatrate") || Objects.equals(propName, "floatpoints") || Objects.equals(propName, "productterm")) {
            DynamicObject referRate = product.getDynamicObject("referrate");
            String floatDirection = product.getString("floatdirection");
            if (referRate != null && StringUtils.isNotEmpty((CharSequence)floatDirection)) {
                String listPrice;
                long floatPoints = product.getLong("floatpoints");
                if (floatPoints > 0L) {
                    String symbol = FloatDirectionEnum.UP.getValue().equals(this.getModel().getValue("floatdirection")) ? "+" : CURRENT_CODE;
                    listPrice = referRate.getString("number") + symbol + floatPoints + "bp";
                } else {
                    listPrice = referRate.getString("number");
                }
                this.getModel().setValue("price", (Object)listPrice);
            }
        }
    }

    private void fillComboItems(Object newValue) {
        ComboEdit combo = (ComboEdit)this.getControl("category");
        if (Objects.equals(newValue, ServiceCategoryEnum.DEPOSIT.getValue())) {
            combo.setComboItems(ItemCategoryEnum.transToDepositComboItems());
        } else if (Objects.equals(newValue, ServiceCategoryEnum.LOAN.getValue())) {
            combo.setComboItems(ItemCategoryEnum.transToLoanComboItems());
        }
        Object serviceCategory = this.getModel().getValue("servicecategory");
        if (Objects.equals(serviceCategory, ServiceCategoryEnum.DEPOSIT.getValue())) {
            this.getModel().setValue("category", (Object)ItemCategoryEnum.CURRENT.getValue());
        } else if (Objects.equals(serviceCategory, ServiceCategoryEnum.LOAN.getValue())) {
            this.getModel().setValue("category", (Object)ItemCategoryEnum.SHORT.getValue());
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.fillComboItems(this.getModel().getValue("servicecategory"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object newValue = this.getModel().getValue("servicecategory");
        ComboEdit combo = (ComboEdit)this.getControl("category");
        if (Objects.equals(newValue, ServiceCategoryEnum.DEPOSIT.getValue())) {
            combo.setComboItems(ItemCategoryEnum.transToDepositComboItems());
        } else if (Objects.equals(newValue, ServiceCategoryEnum.LOAN.getValue())) {
            combo.setComboItems(ItemCategoryEnum.transToLoanComboItems());
        }
    }

    private void fillEntry(int newEntryRow) {
        boolean isDataChange = this.getModel().getDataChanged();
        IDataModel model = this.getModel();
        String serviceCategory = model.getDataEntity().getString("servicecategory");
        if (Objects.equals(serviceCategory, ServiceCategoryEnum.DEPOSIT.getValue())) {
            model.setValue("e_initdepositlimit", model.getValue("initdepositlimit"), newEntryRow);
            model.setValue("e_convertunit", model.getValue("convertunit"), newEntryRow);
            model.setValue("e_price_num", model.getValue("price_num"), newEntryRow);
        } else {
            model.setValue("e_floatrate", model.getValue("floatrate"), newEntryRow);
            model.setValue("e_floatdirection", model.getValue("floatdirection"), newEntryRow);
            model.setValue("e_floatpoints", model.getValue("floatpoints"), newEntryRow);
            model.setValue("e_referrate", model.getValue("referrate"), newEntryRow);
            if (!model.getDataEntity().getBoolean("floatrate")) {
                model.setValue("e_price_num", model.getValue("price_num"), newEntryRow);
            }
        }
        model.setValue("e_interestratedays", model.getValue("interestratedays"), newEntryRow);
        model.setValue("e_price", model.getValue("price"), newEntryRow);
        model.setValue("e_effectivedate", model.getValue("effectivedate"), newEntryRow);
        model.setValue("e_comment", model.getValue("comment"), newEntryRow);
        this.getModel().setDataChanged(isDataChange);
    }
}

