/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.setting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.dync.AbstractTmcDyncListPlugin;
import org.apache.commons.lang3.StringUtils;

public class InnerAccountInitPlugin
extends AbstractTmcDyncListPlugin {
    private static final Log logger = LogFactory.getLog(InnerAccountInitPlugin.class);
    protected FilterContainerInitArgs initArgs;
    private static final String BAR_REFRESH = "bar_refresh";
    private static final String BAR_CLOSE = "bar_close";
    private static final String BAR_INIT = "bar_init";
    private static final String BAR_INIT_BACK = "bar_init_back";
    private StringBuilder errorMessage = new StringBuilder();

    public void initialize() {
        super.initialize();
        this.initData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)BAR_REFRESH, (CharSequence)itemKey)) {
            this.fillPageData();
        } else if (StringUtils.equals((CharSequence)BAR_INIT, (CharSequence)itemKey)) {
            this.accountInit();
            this.getView().updateView("entryentity");
        } else if (StringUtils.equals((CharSequence)BAR_INIT_BACK, (CharSequence)itemKey)) {
            this.accountInitBack();
            this.fillPageData();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillPageData();
    }

    protected void fillPageData() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        List qFilters = this.getQFilterFromPagCache();
        Object scId = this.getView().getFormShowParameter().getCustomParam("scId");
        QFilter qFilter = new QFilter("id", "=", scId);
        DynamicObjectCollection scObj = QueryServiceHelper.query((String)"ifm_settcentersetting", (String)"settlecenter", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)scObj)) {
            return;
        }
        qFilters.add(new QFilter("inneraccount.finorg.id", "=", (Object)((DynamicObject)scObj.get(0)).getLong("settlecenter")));
        String selectField = "id,inneraccount.id,inneraccount.number,inneraccount.name,inneraccount.openorg, inneraccount.company,currency,interestdatestart,amount,amountdate,isinit";
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)"ifm_inneraccountinit", (String)selectField, (QFilter[])qFilters.toArray(new QFilter[0]));
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]);
        vs.addField("inneraccountid", new Object[0]);
        vs.addField("bankaccountnumber", new Object[0]);
        vs.addField("bankaccountname", new Object[0]);
        vs.addField("company", new Object[0]);
        vs.addField("openorg", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("amount", new Object[0]);
        vs.addField("amountdate", new Object[0]);
        vs.addField("interestdatestart", new Object[0]);
        vs.addField("isinit", new Object[0]);
        for (DynamicObject row : dataList) {
            vs.addRow(new Object[]{row.get("id"), row.get("inneraccount.id"), row.get("inneraccount.number"), row.get("inneraccount.name"), row.get("inneraccount.company"), row.get("inneraccount.openorg"), row.get("currency"), row.get("amount"), row.get("amountdate"), row.get("interestdatestart"), row.get("isinit")});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    protected String getEntityName() {
        return "ifm_inneraccountinit";
    }

    public void filterContainerInit(FilterContainerInitEvent event) {
        FilterContainerInitArgs args;
        this.initArgs = args = new FilterContainerInitArgs(event);
        if (this.getPageCache().get("isFirstInit") == null) {
            this.getPageCache().put("isFirstInit", "true");
            this.fillPageData();
        }
    }

    public void filterSearchClickEvent(SearchClickEvent event) {
        this.fillPageData();
    }

    private void initData() {
        if (this.getPageCache().get("initData") != null) {
            return;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"ifm_inneraccountinit");
        DynamicObjectCollection innerAccountList = QueryServiceHelper.query((String)"ifm_inneracct", (String)"id,org, currency.fbasedataid", (QFilter[])new QFilter[0]);
        if (!CollectionUtils.isEmpty((Collection)innerAccountList)) {
            ArrayList<DynamicObject> unInitSetObjectList = new ArrayList<DynamicObject>();
            for (DynamicObject innerAccountObject : innerAccountList) {
                long accountId = innerAccountObject.getLong("id");
                long currencyId = innerAccountObject.getLong("currency.fbasedataid");
                QFilter accountExistFilter = new QFilter("inneraccount", "=", (Object)accountId);
                QFilter currencyExistFilter = new QFilter("currency", "=", (Object)currencyId);
                if (QueryServiceHelper.exists((String)"ifm_inneraccountinit", (QFilter[])new QFilter[]{accountExistFilter.and(currencyExistFilter)})) continue;
                DynamicObject initInfo = new DynamicObject((DynamicObjectType)entityType);
                initInfo.set("inneraccount", (Object)accountId);
                initInfo.set("currency", (Object)currencyId);
                initInfo.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                initInfo.set("scorg", innerAccountObject.get("org"));
                initInfo.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
                initInfo.set("createtime", (Object)new Date());
                unInitSetObjectList.add(initInfo);
            }
            SaveServiceHelper.save((DynamicObject[])unInitSetObjectList.toArray(new DynamicObject[0]));
        }
        this.getPageCache().put("initData", "Initialized");
    }

    private void accountInit() {
        DynamicObject[] loads;
        List<DynamicObject> selectedData = this.getSelectedData();
        if (selectedData == null) {
            return;
        }
        Object[] ids = (Long[])selectedData.stream().map(v -> v.getLong("id")).toArray(Long[]::new);
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_inneraccountinit"))) {
            for (DynamicObject selectedDatum : selectedData) {
                if (!load.get("id").equals(selectedDatum.get("id"))) continue;
                load.set("amountdate", selectedDatum.get("amountdate"));
                load.set("amount", (Object)selectedDatum.getBigDecimal("amount"));
                load.set("interestdatestart", selectedDatum.get("interestdatestart"));
            }
        }
        OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"init", (String)"ifm_inneraccountinit", (DynamicObject[])loads, (OperateOption)OperateOption.create());
        if (result != null) {
            List errorInfos = result.getAllErrorOrValidateInfo();
            for (IOperateInfo errorInfo : errorInfos) {
                this.errorMessage.append(errorInfo.getMessage()).append('\n');
            }
            if (!result.isSuccess()) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("bos_operationresult");
                parameter.setCaption(ResManager.loadKDString((String)"\u786e\u8ba4\u64cd\u4f5c", (String)"InnerAccountInitPlugin_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                parameter.getOpenStyle().setShowType(ShowType.Floating);
                if (errorInfos.size() > 0) {
                    parameter.setCustomParam("title", (Object)String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u521d\u59cb\u5316\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20", (String)"InnerAccountInitPlugin_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), selectedData.size(), result.getSuccessPkIds().size(), errorInfos.size()));
                    parameter.setCustomParam("errorMsg", (Object)this.errorMessage);
                    this.getView().showForm(parameter);
                }
                if (errorInfos.size() == 0 && result.getSuccessPkIds().size() == 0) {
                    parameter.setCustomParam("errorMsg", (Object)result.getMessage());
                    this.getView().showForm(parameter);
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6210\u529f", (String)"InnerAccountInitPlugin_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                this.fillPageData();
            }
        }
    }

    private List<DynamicObject> getSelectedData() {
        List selectedIdList = this.getSelectedIdList();
        DynamicObject dynFormObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection dataList = dynFormObj.getDynamicObjectCollection("entryentity");
        if (selectedIdList == null) {
            return null;
        }
        List<DynamicObject> selectedList = dataList.stream().filter(i -> selectedIdList.contains(i.getLong("id"))).collect(Collectors.toList());
        return selectedList;
    }

    private void accountInitBack() {
        List<DynamicObject> selectedData = this.getSelectedData();
        if (selectedData == null) {
            return;
        }
        Object[] ids = (Long[])selectedData.stream().map(v -> v.getLong("id")).toArray(Long[]::new);
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_inneraccountinit"));
        OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"initback", (String)"ifm_inneraccountinit", (DynamicObject[])loads, (OperateOption)OperateOption.create());
        if (result != null) {
            List errorInfos = result.getAllErrorOrValidateInfo();
            for (IOperateInfo errorInfo : errorInfos) {
                this.errorMessage.append(errorInfo.getMessage()).append('\n');
            }
            if (!result.isSuccess()) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("bos_operationresult");
                parameter.setCaption(ResManager.loadKDString((String)"\u786e\u8ba4\u64cd\u4f5c", (String)"InnerAccountInitPlugin_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                parameter.getOpenStyle().setShowType(ShowType.Floating);
                if (errorInfos.size() > 0) {
                    parameter.setCustomParam("title", (Object)String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u53cd\u521d\u59cb\u5316\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20", (String)"InnerAccountInitPlugin_4", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), selectedData.size(), result.getSuccessPkIds().size(), errorInfos.size()));
                    parameter.setCustomParam("errorMsg", (Object)this.errorMessage);
                    this.getView().showForm(parameter);
                }
                if (errorInfos.size() == 0 && result.getSuccessPkIds().size() == 0) {
                    parameter.setCustomParam("errorMsg", (Object)result.getMessage());
                    this.getView().showForm(parameter);
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f", (String)"InnerAccountInitPlugin_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            }
        }
        this.fillPageData();
    }
}

