/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.transhandlebill;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.ifm.enums.PaymentChanEnum;

public class TransBillChangeDateEdit
extends AbstractTmcBillEdit
implements HyperLinkClickListener {
    private static String SELECT_FIELDS = "id,billno,payeracctbank,paymentchannel,currency,actpayamt,bizdate,usage";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List ids = (List)customParams.get("ids");
        if (EmptyUtil.isNoEmpty((Object)ids)) {
            DynamicObject[] transHandlBills = TmcDataServiceHelper.load((String)"ifm_transhandlebill", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
            this.batchCreateEntry(transHandlBills);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if ("operation".equals(fieldName)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().deleteEntryRow("entryentity", entryCurrentRowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "save": {
                this.PayAccepTanceFillBySave();
            }
        }
    }

    private String checkMsg() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCount == 0) {
            return ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u3002", (String)"PayAcceptFillAgentInfoEdit_10", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
        }
        StringBuilder checkMsg = new StringBuilder();
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", i);
            String paymentChannel = rowEntity.getString("paymentchannel");
            String usage = rowEntity.getString("usage");
            if (!PaymentChanEnum.BEI.getValue().equals(paymentChannel) || !EmptyUtil.isEmpty((String)usage)) continue;
            checkMsg.append(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u8f6c\u8d26\u9644\u8a00\u5fc5\u586b", (String)"TransBillChangeDateEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[]{i + 1})).append("\n");
        }
        return checkMsg.toString();
    }

    private void PayAccepTanceFillBySave() {
        String msg = this.checkMsg();
        if (EmptyUtil.isNoEmpty((String)msg)) {
            this.getView().showTipNotification(msg, Integer.valueOf(6000));
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        Set payBillIds = entrys.stream().map(o -> o.get("billid")).collect(Collectors.toSet());
        DynamicObject[] tansBills = TmcDataServiceHelper.load((String)"ifm_transhandlebill", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", payBillIds)});
        HashMap billMap = Arrays.stream(tansBills).collect(HashMap::new, (k, v) -> k.put(v.getLong("id"), v), HashMap::putAll);
        for (DynamicObject entry : entrys) {
            DynamicObject bill = (DynamicObject)billMap.get(entry.getLong("billid"));
            bill.set("bizdate", (Object)entry.getDate("bizdate"));
            bill.set("usage", (Object)entry.getString("usage"));
        }
        SaveServiceHelper.save((DynamicObject[])tansBills);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"TransBillChangeDateEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
    }

    private void batchCreateEntry(DynamicObject[] transHandlBills) {
        if (EmptyUtil.isEmpty((Object[])transHandlBills)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("billid", new Object[0]);
        vs.addField("billno", new Object[0]);
        vs.addField("inneracct", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("amount", new Object[0]);
        vs.addField("paymentchannel", new Object[0]);
        vs.addField("bizdate", new Object[0]);
        vs.addField("usage", new Object[0]);
        vs.addField("operation", new Object[0]);
        for (DynamicObject tansBill : transHandlBills) {
            Object[] rowData = new Object[]{tansBill.getLong("id"), tansBill.getString("billno"), this.getDynamicObjId(tansBill, "payeracctbank"), this.getDynamicObjId(tansBill, "currency"), tansBill.getBigDecimal("actpayamt"), tansBill.getString("paymentchannel"), tansBill.getDate("bizdate"), tansBill.getString("usage"), ResManager.loadKDString((String)"\u5220\u9664", (String)"TransBillChangeDateEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0])};
            vs.addRow(rowData);
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put("heightLimit", false);
        this.getView().updateControlMetadata("entryentity", map);
        this.getView().updateView("entryentity");
    }

    private Object getDynamicObjId(DynamicObject payBill, String prop) {
        DynamicObject value = payBill.getDynamicObject(prop);
        return EmptyUtil.isNoEmpty((DynamicObject)value) ? value.getPkValue() : Long.valueOf(0L);
    }
}

