/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.transhandlebill;

import java.math.BigDecimal;
import java.text.Format;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.enums.BalanceTypeEnum;
import kd.tmc.fbp.common.helper.BizBalanceModelHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.PaymentChanEnum;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.enums.TransTypeEnum;
import kd.tmc.ifm.formplugin.common.ExchangeRateEdit;
import kd.tmc.ifm.helper.BankAccountBalanceHelper;
import kd.tmc.ifm.helper.TransBillHelper;

public class TransHandleBillEdit
extends ExchangeRateEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.setFinOrgF7Filter();
        this.setFinAccF7Filter();
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        String key;
        super.afterDoOperation(arg);
        AbstractOperate op = (AbstractOperate)arg.getSource();
        switch (key = op.getOperateKey()) {
            case "canclepay": {
                OperationResult operationResult = arg.getOperationResult();
                if (operationResult.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u4ed8\u6b3e\u6210\u529f\u3002", (String)"TransactionBillEdit_8", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u4ed8\u6b3e\u5931\u8d25\u3002", (String)"TransactionBillEdit_6", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "refuse": {
                if (!arg.getOperationResult().isSuccess()) {
                    return;
                }
                String billStatus = (String)this.getModel().getValue("billstatus");
                String paidStatus = (String)this.getModel().getValue("paidstatus");
                if (paidStatus.equals(TransBillPaidStatusEnum.REFUSED.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9000\u5355\u7684\u5355\u636e\u65e0\u6cd5\u518d\u6b21\u9000\u5355\u3002", (String)"PayAcceptanceBillEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!billStatus.equals(BillStatusEnum.SAVE.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u9000\u5355\u3002", (String)"PayAcceptanceBillEdit_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("ifm_payacceptance_back");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "bar_refuse");
                formShowParameter.setCloseCallBack(callBack);
                this.getView().showForm(formShowParameter);
                break;
            }
            case "confirm": {
                if (!arg.getOperationResult().isSuccess()) {
                    return;
                }
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DynamicObject ageAcc = (DynamicObject)this.getModel().getValue("agentpayeraccount");
                OperationResult result = new OperationResult();
                String transType = dataEntity.getString("transtype");
                if (TransTypeEnum.isAgentPay((Object)transType) || TransTypeEnum.isLinkagePAY((Object)transType)) {
                    if (ageAcc.getBoolean("issetbankinterface")) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u652f\u4ed8\u8d26\u6237\u5df2\u7ecf\u5f00\u901a\u94f6\u4f01\u63a5\u53e3\uff0c\u786e\u8ba4\u4ed8\u6b3e\u5c06\u4e0d\u4f1a\u53d1\u9001\u94f6\u884c\u6307\u4ee4\uff0c\u800c\u76f4\u63a5\u89c6\u4e3a\u4ed8\u6b3e\u5b8c\u6210\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"TransactionBillEdit_5", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_PAY_CALLBACK", (IFormPlugin)this));
                        return;
                    }
                    result = TmcOperateServiceHelper.execOperate((String)"confirmpay", (String)"ifm_transhandlebill", (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
                } else {
                    result = TmcOperateServiceHelper.execOperate((String)"commitifm", (String)"ifm_transhandlebill", (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
                }
                if (result.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e\u6210\u529f\u3002", (String)"TransactionBillEdit_7", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showErrorNotification(this.getMessage(result));
                break;
            }
            case "viewbankpaybill": {
                this.viewBankpayBill();
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPayerInfo4Lb();
        this.setPayeeInfo4Lb();
        String transType = (String)this.getModel().getValue("transtype");
        boolean isNeePay = TransTypeEnum.isAgentPay((Object)transType) || TransTypeEnum.isBankDeduction((Object)transType) || TransTypeEnum.isLinkagePAY((Object)transType);
        this.getView().setVisible(Boolean.valueOf(isNeePay), new String[]{"flexpanelap"});
        this.getView().setVisible(Boolean.valueOf(isNeePay), new String[]{"bar_pay"});
        ((Label)this.getControl("recaccbanknametext")).setText((String)this.getModel().getValue("recaccbankname"));
        ((Label)this.getControl("recbanknumbertext")).setText((String)this.getModel().getValue("recbanknumber"));
        this.controlByPayaccount();
        this.setAgentFlexname(transType);
        this.setBankBalance();
    }

    private void controlByPayaccount() {
        DynamicObject account = (DynamicObject)this.getModel().getValue("agentpayeraccount");
        String paymentChannel = (String)this.getModel().getValue("paymentchannel");
        boolean isBeiPay = false;
        if (EmptyUtil.isNoEmpty((DynamicObject)account)) {
            boolean isBankInteFace = account.getBoolean("issetbankinterface");
            boolean isBei = PaymentChanEnum.BEI.getValue().equals(paymentChannel);
            isBeiPay = isBankInteFace && isBei;
        }
        this.getView().setVisible(Boolean.valueOf(isBeiPay), new String[]{"recaccbanknamelb", "recbanknumberlb"});
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("CONFIRM_PAY_CALLBACK".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"confirmpay", (String)"ifm_transhandlebill", (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e\u6210\u529f\u3002", (String)"TransactionBillEdit_7", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(this.getMessage(operationResult));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"bar_refuse")) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            String reason = (String)returnData.get("reason");
            this.getModel().setValue("paidstatus", (Object)TransBillPaidStatusEnum.REFUSED.getValue());
            this.getModel().setValue("reason", (Object)reason);
            this.getModel().setValue("backdate", (Object)new Date());
            this.getModel().setValue("backuser", (Object)RequestContext.get().getUserId());
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"refusebill", (String)"ifm_transhandlebill", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u5355\u6210\u529f\u3002", (String)"TransactionBillEdit_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                this.getView().updateView();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9000\u5355\u5931\u8d25\u3002", (String)"TransactionBillEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject newValue;
        DynamicObject oldValue;
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (fieldKey.equals("agentpayeraccount")) {
            DynamicObject newValue2 = (DynamicObject)changeData[0].getNewValue();
            if (newValue2 != null) {
                DynamicObject bankObject = newValue2.getDynamicObject("bank");
                Long bankId = (Long)bankObject.getPkValue();
                QFilter qFilter = new QFilter("id", "=", (Object)bankId);
                bankObject = BusinessDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"id,bank_cate", (QFilter[])qFilter.toArray());
                DynamicObject bankCateObject = bankObject.getDynamicObject("bank_cate");
                this.getModel().beginInit();
                this.getModel().setValue("agentfinorg", (Object)bankObject);
                this.getModel().setValue("agentfinorgcat", (Object)bankCateObject);
                this.getModel().endInit();
                this.getView().updateView("agentfinorg");
                this.getView().updateView("agentfinorgcat");
            }
            this.controlByPayaccount();
        }
        if (fieldKey.equals("agentfinorgcat")) {
            long newId;
            oldValue = (DynamicObject)changeData[0].getOldValue();
            newValue = (DynamicObject)changeData[0].getNewValue();
            long oldId = oldValue == null ? 0L : (Long)oldValue.getPkValue();
            long l = newId = newValue == null ? 0L : (Long)newValue.getPkValue();
            if (oldId != newId) {
                this.getModel().setValue("agentfinorg", null);
                this.getModel().setValue("agentpayeraccount", null);
            }
        }
        if (fieldKey.equals("agentfinorg")) {
            long newId;
            oldValue = (DynamicObject)changeData[0].getOldValue();
            newValue = (DynamicObject)changeData[0].getNewValue();
            long oldId = oldValue == null ? 0L : (Long)oldValue.getPkValue();
            long l = newId = newValue == null ? 0L : (Long)newValue.getPkValue();
            if (oldId != newId) {
                this.getModel().setValue("agentpayeraccount", null);
            }
        }
        switch (fieldKey) {
            case "agentpayeraccount": {
                this.setBankBalance();
            }
        }
    }

    private void viewBankpayBill() {
        DynamicObjectCollection bankpayBills = null;
        long billId = (Long)this.getModel().getValue("id");
        if (billId > 0L) {
            QFilter filter = new QFilter("srcbilltype", "=", (Object)"ifm_transhandlebill").and(new QFilter("sourcebillid", "=", (Object)billId));
            bankpayBills = QueryServiceHelper.query((String)"bei_bankpaybill", (String)"id", (QFilter[])new QFilter[]{filter});
        }
        if (bankpayBills != null && bankpayBills.size() > 0) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(((DynamicObject)bankpayBills.get(0)).get("id"));
            showParameter.setFormId("bei_bankpaybill");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5173\u8054\u7684\u94f6\u884c\u4ed8\u6b3e\u5355\u3002", (String)"TransactionBillEdit_10", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setPayerInfo4Lb() {
        String defaultUrl = "/kingdee/tmc/images/pc/icon/entrance/sky_fkf_80_80.png";
        Image orgPic = (Image)this.getControl("orgpic");
        orgPic.setUrl(defaultUrl);
        DynamicObject payerAcctBankObject = (DynamicObject)this.getModel().getValue("payeracctbank");
        DynamicObject currencyObject = (DynamicObject)this.getModel().getValue("currency");
        if (payerAcctBankObject == null || currencyObject == null) {
            return;
        }
        Long acctBankId = (Long)payerAcctBankObject.getPkValue();
        Long currencyId = (Long)currencyObject.getPkValue();
        String labCurrencySign = currencyObject.getString("sign");
        int currencyAmtprecision = currencyObject.getInt("amtprecision");
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
        fobj.getCurrencyFormat().setCurrencySymbols(labCurrencySign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(currencyAmtprecision);
        Format currencyFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
        BizBalanceModelBean balance = BizBalanceModelHelper.getRunningBalance((String)BalanceTypeEnum.BALANCE.getValue(), (long)acctBankId, (long)currencyId);
        if (balance != null && balance.getAmount() != null) {
            ((Label)this.getControl("balancev")).setText(currencyFormat.format(balance.getAmount()));
        }
    }

    private void setPayeeInfo4Lb() {
        Image payeePic = (Image)this.getControl("payeepic");
        String defaultUrl = "/kingdee/tmc/images/pc/icon/entrance/sky_skf_80_80.png";
        payeePic.setUrl(defaultUrl);
    }

    private void setFinOrgF7Filter() {
        BasedataEdit finOrg = (BasedataEdit)this.getControl("agentfinorg");
        finOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject bankCateObject = (DynamicObject)this.getModel().getValue("agentfinorgcat");
            if (bankCateObject != null) {
                ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showPara.getListFilterParameter().getQFilters().add(new QFilter("bank_cate.id", "=", bankCateObject.get("id")));
            }
        });
    }

    private void setFinAccF7Filter() {
        BasedataEdit finAcc = (BasedataEdit)this.getControl("agentpayeraccount");
        finAcc.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject finOrg;
            QFilter accFilter = new QFilter("1", "=", (Object)1);
            DynamicObject bankCateObject = (DynamicObject)this.getModel().getValue("agentfinorgcat");
            if (bankCateObject != null) {
                accFilter.and(new QFilter("bank.bank_cate.id", "=", bankCateObject.get("id")));
            }
            if ((finOrg = (DynamicObject)this.getModel().getValue("agentfinorg")) != null) {
                accFilter.and(new QFilter("bank.id", "=", finOrg.get("id")));
            }
            DynamicObjectCollection load = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])new QFilter[]{new QFilter("bank.bank_cate.number", "=", (Object)"BC-9999").or(new QFilter("acctclassify", "=", (Object)"I"))});
            List collect = load.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
            accFilter.and(new QFilter("id", "not in", collect));
            DynamicObject currencyObject = (DynamicObject)this.getModel().getValue("currency");
            accFilter.and(new QFilter("currency.fbasedataid.id", "in", currencyObject == null ? "" : currencyObject.getPkValue()));
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showPara.getListFilterParameter().setFilter(accFilter);
        });
    }

    private void setAgentFlexname(Object transType) {
        if (TransTypeEnum.isLinkagePAY((Object)transType)) {
            HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
            String flexCon = ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u94f6\u884c\u8d26\u6237\u4fe1\u606f", (String)"PayAcceptanceBillEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
            props.put("text", new LocaleString(flexCon));
            this.getView().updateControlMetadata("flexpanelap", props);
        }
    }

    private String getMessage(OperationResult operationResult) {
        if (operationResult == null) {
            return "";
        }
        List errorInfos = TransBillHelper.getErrorInfos((OperationResult)operationResult);
        String message = operationResult.getMessage();
        if (errorInfos.size() > 0) {
            OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(0);
            message = errorInfo.getMessage();
        }
        return message;
    }

    private void setBankBalance() {
        DynamicObject bankAccount = (DynamicObject)this.getModel().getValue("agentpayeraccount");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)bankAccount) && EmptyUtil.isNoEmpty((DynamicObject)org) && EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            String labCurrencySign = currency.getString("sign");
            int currencyAmtprecision = currency.getInt("amtprecision");
            FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
            fobj.getCurrencyFormat().setCurrencySymbols(labCurrencySign);
            fobj.getCurrencyFormat().setMinimumFractionDigits(currencyAmtprecision);
            Format currencyFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
            BigDecimal bankBalance = BankAccountBalanceHelper.getBankBalance((Long)bankAccount.getLong("id"), (Long)org.getLong("id"), (Long)currency.getLong("id"));
            if (bankBalance != null) {
                ((Label)this.getControl("curbalancev")).setText(currencyFormat.format(bankBalance));
                return;
            }
        }
        ((Label)this.getControl("curbalancev")).setText("");
    }
}

