/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.transhandlebill;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.MatchStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.enums.TransTypeEnum;
import kd.tmc.ifm.helper.TransBillHelper;

public class TransHandleBillList
extends AbstractTmcBillBaseList {
    private StringBuilder errorMessage = new StringBuilder();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("CONFIRM_PAY_CALLBACK".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            Set<Long> selectIds = this.getSelectedIds();
            MainEntityType iDataEntityType = EntityMetadataCache.getDataEntityType((String)"ifm_transhandlebill");
            DynamicObject[] dynamicObjects = (DynamicObject[])BusinessDataServiceHelper.load((Object[])selectIds.toArray(), (IDataEntityType)iDataEntityType);
            OperationResult operationResult = null;
            ArrayList errorInfos = new ArrayList(10);
            for (int i = 0; i < dynamicObjects.length; ++i) {
                String transType = dynamicObjects[i].getString("transtype");
                if (!TransTypeEnum.isAgentPay((Object)transType) && !TransTypeEnum.isLinkagePAY((Object)transType) || (operationResult = TmcOperateServiceHelper.execOperate((String)"confirmpay", (String)"ifm_transhandlebill", (DynamicObject[])new DynamicObject[]{dynamicObjects[i]}, (OperateOption)OperateOption.create())).isSuccess()) continue;
                errorInfos.addAll(TransBillHelper.getErrorInfos((OperationResult)operationResult));
            }
            if (!errorInfos.isEmpty()) {
                for (IOperateInfo errorInfo : errorInfos) {
                    this.errorMessage.append(errorInfo.getMessage()).append('\n');
                }
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("bos_operationresult");
                parameter.setCaption(ResManager.loadKDString((String)"\u786e\u8ba4\u64cd\u4f5c", (String)"InnerAccountInitPlugin_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                parameter.getOpenStyle().setShowType(ShowType.Floating);
                parameter.setCustomParam("errorMsg", (Object)this.errorMessage);
                this.getView().showForm(parameter);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e\u6210\u529f\u3002", (String)"TransactionBillListPlugin_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            }
            this.refreshData();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"tblrefuse")) {
            DynamicObject[] dynamicObjects;
            Set<Long> selectIds = this.getSelectedIds();
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            String backDescr = (String)returnData.get("reason");
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"ifm_transhandlebill");
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((Object[])selectIds.toArray(), (DynamicObjectType)type)) {
                dynamicObject.set("paidstatus", (Object)TransBillPaidStatusEnum.REFUSED.getValue());
                dynamicObject.set("reason", (Object)backDescr);
                dynamicObject.set("backdate", (Object)new Date());
                dynamicObject.set("backuser", (Object)RequestContext.get().getUserId());
            }
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"refusebill", (String)"ifm_transhandlebill", (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u5355\u6210\u529f\u3002", (String)"TransactionBillListPlugin_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9000\u5355\u5931\u8d25\u3002", (String)"TransactionBillListPlugin_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            }
            this.refreshData();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        String key;
        super.afterDoOperation(arg);
        OperationResult operationResult = arg.getOperationResult();
        AbstractOperate op = (AbstractOperate)arg.getSource();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (key = op.getOperateKey()) {
            case "pay": {
                this.afterDoPay(operationResult);
                break;
            }
            case "confirm": {
                this.afterDoConfirm();
                break;
            }
            case "refuse": {
                this.afterDoRefuse();
                break;
            }
            case "cancelpay": {
                this.refreshData();
                break;
            }
            case "changedate": {
                this.changeDateOper(operationResult);
                break;
            }
            case "viewbankpaybill": {
                this.viewBankpayBill();
            }
        }
    }

    private void viewBankpayBill() {
        List selectIds = this.getSelectedIdList();
        QFilter filter = new QFilter("srcbilltype", "=", (Object)"ifm_transhandlebill").and(new QFilter("sourcebillid", "in", (Object)selectIds));
        DynamicObjectCollection bankpayBills = QueryServiceHelper.query((String)"bei_bankpaybill", (String)"id", (QFilter[])new QFilter[]{filter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)bankpayBills)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5173\u8054\u7684\u94f6\u884c\u4ed8\u6b3e\u5355\u3002", (String)"TransactionBillEdit_10", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (bankpayBills.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(((DynamicObject)bankpayBills.get(0)).get("id"));
            showParameter.setFormId("bei_bankpaybill");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId("bei_bankpaybill");
            Set bankPayIds = bankpayBills.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", bankPayIds));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            showParameter.setCustomParam("istmctracebillop", (Object)"yes");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void afterDoRefuse() {
        List selectIds = this.getSelectedIdList();
        QFilter filter = new QFilter("id", "in", (Object)selectIds);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"ifm_transhandlebill", (String)"paidstatus,billstatus,matchflag,billno", (QFilter[])filters);
        for (int i = 0; i < bills.size(); ++i) {
            String paidStatus = ((DynamicObject)bills.get(i)).getString("paidstatus");
            String billStatus = ((DynamicObject)bills.get(i)).getString("billstatus");
            String matchFlag = ((DynamicObject)bills.get(i)).getString("matchflag");
            String billNo = ((DynamicObject)bills.get(i)).getString("billno");
            if (paidStatus.equals(TransBillPaidStatusEnum.REFUSED.getValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"%s\uff1a\u5df2\u9000\u5355\u7684\u5355\u636e\u4e0d\u80fd\u9000\u5355\u3002", (String)"TransactionBillEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[]{billNo}));
                return;
            }
            if (!billStatus.equals(BillStatusEnum.SAVE.getValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"%s\uff1a\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u9000\u5355\u3002", (String)"TransactionBillEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[]{billNo}));
                return;
            }
            if (MatchStatusEnum.UNSMARTMATCH.getValue().equals(matchFlag)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s:\u5df2\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u7684\u5355\u636e\u4e0d\u80fd\u9000\u5355\u3002", (String)"TransactionBillEdit_9", (String)"tmc-ifm-formplugin", (Object[])new Object[]{billNo}));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ifm_payacceptance_back");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "tblrefuse");
        formShowParameter.setCloseCallBack(callBack);
        this.getView().showForm(formShowParameter);
    }

    private void afterDoPay(OperationResult operationResult) {
        List pks = operationResult.getSuccessPkIds();
        List validateInfo = operationResult.getAllErrorOrValidateInfo();
        StringBuilder error = new StringBuilder();
        if (validateInfo.size() > 0 && pks.size() > 0) {
            operationResult.setShowMessage(false);
            for (IOperateInfo info : validateInfo) {
                error = error.append(info.getMessage()).append('\n');
            }
            this.getView().showErrorNotification(error.toString());
        }
    }

    private void afterDoConfirm() {
        List selectIds = this.getSelectedIdList();
        MainEntityType iDataEntityType = EntityMetadataCache.getDataEntityType((String)"ifm_transhandlebill");
        DynamicObject[] transBill = (DynamicObject[])BusinessDataServiceHelper.load((Object[])selectIds.toArray(), (IDataEntityType)iDataEntityType);
        ArrayList errorInfos = new ArrayList(10);
        for (int i = 0; i < transBill.length; ++i) {
            String billStatus = transBill[i].getString("billstatus");
            String transType = transBill[i].getString("transtype");
            DynamicObject ageAcc = transBill[i].getDynamicObject("agentpayeraccount");
            OperationResult result = null;
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u786e\u8ba4\u4ed8\u6b3e\u3002", (String)"TransHandleBillList_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                return;
            }
            String paidStatus = transBill[i].getString("paidstatus");
            if (!TransBillPaidStatusEnum.WAITING.getValue().equals(paidStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u4ed8\u6b3e\u7684\u5355\u636e\u624d\u80fd\u786e\u8ba4\u4ed8\u6b3e", (String)"TransHandleBillList_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (TransTypeEnum.isAgentPay((Object)transType) || TransTypeEnum.isLinkagePAY((Object)transType)) {
                if (ageAcc.getBoolean("issetbankinterface")) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u5b58\u5728\u652f\u4ed8\u8d26\u6237\u5df2\u7ecf\u5f00\u901a\u94f6\u4f01\u63a5\u53e3\uff0c\u786e\u8ba4\u4ed8\u6b3e\u5c06\u4e0d\u4f1a\u53d1\u9001\u94f6\u884c\u6307\u4ee4\uff0c\u800c\u76f4\u63a5\u89c6\u4e3a\u4ed8\u6b3e\u5b8c\u6210\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"TransactionBillEdit_4", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_PAY_CALLBACK", (IFormPlugin)this));
                    return;
                }
                result = TmcOperateServiceHelper.execOperate((String)"confirmpay", (String)"ifm_transhandlebill", (DynamicObject[])new DynamicObject[]{transBill[i]}, (OperateOption)OperateOption.create());
            } else {
                result = TmcOperateServiceHelper.execOperate((String)"commitifm", (String)"ifm_transhandlebill", (DynamicObject[])new DynamicObject[]{transBill[i]}, (OperateOption)OperateOption.create());
            }
            if (result.isSuccess()) continue;
            errorInfos.addAll(TransBillHelper.getErrorInfos((OperationResult)result));
        }
        if (errorInfos.size() > 0) {
            for (IOperateInfo errorInfo : errorInfos) {
                this.errorMessage.append(errorInfo.getMessage()).append('\n');
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_operationresult");
            parameter.setCaption(ResManager.loadKDString((String)"\u786e\u8ba4\u64cd\u4f5c", (String)"InnerAccountInitPlugin_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            parameter.getOpenStyle().setShowType(ShowType.Floating);
            parameter.setCustomParam("errorMsg", (Object)this.errorMessage);
            this.getView().showForm(parameter);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e\u6210\u529f\u3002", (String)"TransactionBillListPlugin_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
        this.refreshData();
    }

    private void changeDateOper(OperationResult operationResult) {
        if (!operationResult.isSuccess()) {
            return;
        }
        List selectIds = this.getSelectedIdList();
        if (null == selectIds) {
            return;
        }
        if (selectIds.size() > 1000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u80fd\u8d85\u8fc71000\u6761\u3002", (String)"PayAcceptanceBillListPlugin_5", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ifm_changedate");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("ids", (Object)selectIds);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "tblagent");
        formShowParameter.setCloseCallBack(callBack);
        this.getView().showForm(formShowParameter);
    }

    protected Set<Long> getSelectedIds() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        HashSet<Long> ids = new HashSet<Long>(selectedRows.size());
        if (selectedRows.isEmpty()) {
            return null;
        }
        for (ListSelectedRow listSelectedRowValue : selectedRows) {
            ids.add((Long)listSelectedRowValue.getPrimaryKeyValue());
        }
        return ids;
    }

    private void refreshData() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refreshData();
    }
}

