/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.mq;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.mq.TmcMQParam;
import kd.tmc.fbp.common.mq.TmcMQTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.mservice.transdetail.TransDetailService;

public class IfmMQConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(IfmMQConsumer.class);
    private static final IAppCache APP_CACHE = AppCache.get((String)TmcAppEnum.IFM.getValue());
    private static final Integer MAX_RETRY_COUNT = 10;

    public void onMessage(Object param, String messageId, boolean resend, MessageAcker acker) {
        logger.info("mq message: {}", (Object)SerializationUtils.toJsonString((Object)param));
        TmcMQParam msgParam = (TmcMQParam)param;
        String msgType = msgParam.getType();
        if (EmptyUtil.isEmpty((String)msgType)) {
            acker.ack(messageId);
            return;
        }
        TmcMQTypeEnum mqTypeEnum = TmcMQTypeEnum.getEnum((String)msgType);
        if (mqTypeEnum != null) {
            switch (mqTypeEnum) {
                case ASYNC_DEL_TRANSDETAIL: {
                    this.doTransDetailDel(msgParam, acker, messageId);
                    break;
                }
                case AUTO_ASYNC_DEL_RECPAY: {
                    this.doRecPayDel(msgParam, acker, messageId);
                    break;
                }
            }
        }
        acker.ack(messageId);
        APP_CACHE.remove(this.getCacheKey(msgParam));
        logger.info("mq message\uff1a{} execute completed", (Object)messageId);
    }

    private void doTransDetailDel(TmcMQParam msgParam, MessageAcker acker, String messageId) {
        try {
            Map param = (Map)msgParam.getParam();
            Object[] transDetailIds = (Object[])param.get("transdetailids");
            boolean isPay = (Boolean)param.get("ispay");
            TransDetailService.revertTransDetail((Object[])transDetailIds, (boolean)isPay);
        }
        catch (Exception e) {
            this.setRetry(msgParam, acker, messageId);
            throw e;
        }
    }

    private void doRecPayDel(TmcMQParam msgParam, MessageAcker acker, String messageId) {
        try {
            Object recPayIds;
            Map param = (Map)msgParam.getParam();
            Object transBillIds = param.get("transbillids");
            if (EmptyUtil.isNoEmpty(transBillIds)) {
                String ifmEntityName = (String)param.get("ifmentityname");
                TransDetailService.deleteTransBill((Object[])((Object[])transBillIds), (boolean)StringUtils.equals((CharSequence)ifmEntityName, (CharSequence)"ifm_transhandlebill"));
            }
            if (EmptyUtil.isNoEmpty(recPayIds = param.get("recpayids"))) {
                String casEntityName = (String)param.get("casentityname");
                TransDetailService.deleteCasPayRecBill((Object[])((Object[])recPayIds), (boolean)StringUtils.equals((CharSequence)casEntityName, (CharSequence)"cas_paybill"));
            }
        }
        catch (Exception e) {
            this.setRetry(msgParam, acker, messageId);
            logger.error("IfmMQConsumer mq message execute error\uff1a{}", (Object)e.getMessage());
        }
    }

    private void setRetry(TmcMQParam msgParam, MessageAcker acker, String messageId) {
        String cacheKey = this.getCacheKey(msgParam);
        Integer retryCount = (Integer)APP_CACHE.get(cacheKey, Integer.class);
        Integer n = retryCount = EmptyUtil.isEmpty((Integer)retryCount) ? Integer.valueOf(0) : retryCount;
        if (retryCount.compareTo(MAX_RETRY_COUNT) < 0) {
            logger.info("mq message\uff1a{}\uff0cparam\uff1a{} retry {} time", new Object[]{messageId, cacheKey, retryCount});
            acker.deny(messageId);
            retryCount = retryCount + 1;
            APP_CACHE.put(cacheKey, (Object)retryCount);
        } else {
            APP_CACHE.remove(cacheKey);
            acker.discard(messageId);
            logger.info("mq message\uff1a{}\uff0cparam\uff1a{} execute exceed maximum\uff1a{}", new Object[]{messageId, cacheKey, MAX_RETRY_COUNT});
        }
    }

    private String getCacheKey(Object msgParam) {
        return String.join((CharSequence)"IfmMQConsumer#%s", SerializationUtils.toJsonString((Object)msgParam));
    }
}

