/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.accountfrozen;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.InnerAccountFrozenStatusEnum;
import kd.tmc.ifm.enums.InnerAccountFrozenTypeEnum;
import kd.tmc.ifm.helper.InnerAccountBalanceHelper;

public class InnerAccountFrozenUnAuditService
extends AbstractTmcBizOppService {
    private static final String SELECT_PROPERTIES = "id,acctstatus";
    private static final String ACCT_STATUS = "acctstatus";

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("frozenenddate");
        selector.add("account");
        selector.add("account.number");
        selector.add("account.acctstatus");
        selector.add("settlecenter");
        selector.add("applydate");
        selector.add("auditdate");
        selector.add("frozentype");
        selector.add("frozenamount");
        selector.add("totalfrozenamount");
        selector.add("frozenstatus");
        selector.add("autothawbillid");
        return selector;
    }

    public void process(DynamicObject[] dataEntitys) throws KDException {
        block6: for (DynamicObject dataEntity : dataEntitys) {
            String frozenType = dataEntity.getString("frozentype");
            DynamicObject frozenAccountDo = dataEntity.getDynamicObject("account");
            BigDecimal frozenAmount = dataEntity.getBigDecimal("frozenamount");
            Long accountId = frozenAccountDo.getLong("id");
            String accountNumber = frozenAccountDo.getString("number");
            InnerAccountFrozenTypeEnum frozenTypeEnum = InnerAccountFrozenTypeEnum.getByValue((String)frozenType);
            switch (frozenTypeEnum) {
                case ACCOUNT_FROZEN: {
                    dataEntity.set("frozenstatus", (Object)InnerAccountFrozenStatusEnum.FREEZING.getValue());
                    this.syncInnerAcctStatusForUnAudit(accountId, frozenType);
                    this.syncAccountBanksAcctStatusForUnAudit(accountNumber, frozenTypeEnum);
                    continue block6;
                }
                case ACCOUNT_THAW: {
                    dataEntity.set("frozenstatus", (Object)InnerAccountFrozenStatusEnum.THAWING.getValue());
                    this.syncInnerAcctStatusForUnAudit(accountId, frozenType);
                    this.syncAccountBanksAcctStatusForUnAudit(accountNumber, frozenTypeEnum);
                    continue block6;
                }
                case AMOUNT_FROZEN: {
                    dataEntity.set("frozenstatus", (Object)InnerAccountFrozenStatusEnum.FREEZING.getValue());
                    BigDecimal totalFrozenAmount = dataEntity.getBigDecimal("totalfrozenamount").subtract(frozenAmount);
                    dataEntity.set("totalfrozenamount", (Object)totalFrozenAmount);
                    continue block6;
                }
                case AMOUNT_THAW: {
                    dataEntity.set("frozenstatus", (Object)InnerAccountFrozenStatusEnum.THAWING.getValue());
                    BigDecimal totalFrozenAmount = dataEntity.getBigDecimal("totalfrozenamount").add(frozenAmount);
                    dataEntity.set("totalfrozenamount", (Object)totalFrozenAmount);
                    continue block6;
                }
            }
        }
    }

    private void syncInnerAcctStatusForUnAudit(Long accountId, String frozenType) {
        DynamicObject[] innerAccts = BusinessDataServiceHelper.load((String)"ifm_inneracct", (String)SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountId)});
        if (InnerAccountFrozenTypeEnum.ACCOUNT_FROZEN.getValue().equals(frozenType)) {
            for (DynamicObject innerAcct : innerAccts) {
                innerAcct.set(ACCT_STATUS, (Object)"normal");
            }
            SaveServiceHelper.save((DynamicObject[])innerAccts);
        } else if (InnerAccountFrozenTypeEnum.ACCOUNT_THAW.getValue().equals(frozenType)) {
            for (DynamicObject innerAcct : innerAccts) {
                innerAcct.set(ACCT_STATUS, (Object)"frozen");
            }
            SaveServiceHelper.save((DynamicObject[])innerAccts);
        }
    }

    private void syncAccountBanksAcctStatusForUnAudit(String bankAccountNumber, InnerAccountFrozenTypeEnum frozenType) {
        Object[] accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)bankAccountNumber)});
        if (EmptyUtil.isEmpty((Object[])accountBanks)) {
            return;
        }
        String acctStatus = null;
        switch (frozenType) {
            case ACCOUNT_FROZEN: {
                acctStatus = BankAcctStatusEnum.NORMAL.getValue();
                break;
            }
            case ACCOUNT_THAW: {
                acctStatus = BankAcctStatusEnum.FREEZE.getValue();
                break;
            }
        }
        if (acctStatus != null) {
            for (Object accountBank : accountBanks) {
                accountBank.set(ACCT_STATUS, (Object)acctStatus);
            }
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])accountBanks);
            }
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject innerAcct = dataEntity.getDynamicObject("account");
            InnerAccountBalanceHelper.updateValidBalanceByInnerAcctId((Long)innerAcct.getLong("id"), (Date)dataEntity.getDate("applydate"));
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        block3: for (DynamicObject dataEntity : dataEntities) {
            String frozenType = dataEntity.getString("frozentype");
            InnerAccountFrozenTypeEnum frozenTypeEnum = InnerAccountFrozenTypeEnum.getByValue((String)frozenType);
            switch (frozenTypeEnum) {
                case ACCOUNT_THAW: 
                case AMOUNT_THAW: {
                    this.clearAutoThawBillid(dataEntity);
                    continue block3;
                }
            }
        }
    }

    private void clearAutoThawBillid(DynamicObject dataEntity) {
        DynamicObject frozenAccount;
        Long autothawBillid = (Long)dataEntity.get("autothawbillid");
        if (autothawBillid != null && autothawBillid > 0L && (frozenAccount = BusinessDataServiceHelper.loadSingle((Object)autothawBillid, (String)"ifm_accountfrozen")) != null) {
            frozenAccount.set("autothawbillid", null);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{frozenAccount});
        }
    }
}

