/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.bizdeal;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandleParam;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandler;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandlerChain;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.opservice.bizdeal.audit.BizDealApplyOutParam;
import kd.tmc.ifm.business.opservice.bizdeal.audit.ContractChangeApplyBizDealHandler;
import kd.tmc.ifm.business.opservice.bizdeal.audit.ExtendApplyBizDealHandler;
import kd.tmc.ifm.business.opservice.bizdeal.audit.FinApplyBizDealHandler;
import kd.tmc.ifm.business.opservice.bizdeal.audit.IntApplyBizDealHandler;
import kd.tmc.ifm.business.opservice.bizdeal.audit.LoanApplyBizDealHandler;
import kd.tmc.ifm.business.opservice.bizdeal.audit.LoanBillChangeApplyBizDealHandler;
import kd.tmc.ifm.business.opservice.bizdeal.audit.RepayApplyBizDealHandler;
import kd.tmc.ifm.helper.IfmBillCommonHelper;
import kd.tmc.ifm.helper.TransDetailHelper;
import kd.tmc.ifm.mservice.consistency.helper.IfmConsistencyServiceHelper;

public class BizDealCenterAuditService
extends AbstractTmcBizOppService {
    protected final BusinessHandleParam handleParam = new BusinessHandleParam(null, (Object)new BizDealApplyOutParam());
    private BusinessHandlerChain handlerChain = new BusinessHandlerChain().setHandleParam(this.handleParam);

    public BizDealCenterAuditService() {
        this.handlerChain.addHandler(new BusinessHandler[]{new FinApplyBizDealHandler()}).addHandler(new BusinessHandler[]{new ExtendApplyBizDealHandler()}).addHandler(new BusinessHandler[]{new LoanApplyBizDealHandler()}).addHandler(new BusinessHandler[]{new RepayApplyBizDealHandler()}).addHandler(new BusinessHandler[]{new IntApplyBizDealHandler()}).addHandler(new BusinessHandler[]{new ContractChangeApplyBizDealHandler()}).addHandler(new BusinessHandler[]{new LoanBillChangeApplyBizDealHandler()});
    }

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("businessstatus");
        selector.add("applitype");
        selector.add("sourcebillno");
        selector.add("sourcebillid");
        selector.add("iscallint");
        selector.add("creditor");
        selector.add("contractbillno");
        selector.add("contractamt");
        selector.add("amount");
        selector.add("iscycleloan");
        selector.add("repayaccount");
        selector.add("accountbank");
        selector.add("actinterest");
        selector.add("gcontract");
        selector.add("gratio");
        selector.add("gamount");
        selector.add("gexchrate");
        selector.add("gcomment");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bizDealBill : dataEntities) {
            bizDealBill.set("businessstatus", (Object)"B");
            this.handlerChain.doProcess(bizDealBill);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        if (IfmBillCommonHelper.isRelateAppSet((String)TmcAppEnum.CFM.getValue())) {
            OperationResult result;
            BizDealApplyOutParam outParam = (BizDealApplyOutParam)this.handleParam.getOutParam();
            if (EmptyUtil.isNoEmpty(outParam.getLoanBillList())) {
                result = TmcOperateServiceHelper.execOperate((String)"genrecbill", (String)"cfm_loanbill", (Object[])outParam.getLoanBillList().toArray(), (OperateOption)OperateOption.create(), (boolean)true);
                IfmConsistencyServiceHelper.asyncPush((String)"loanBill_autoPush", (String)"loanBillPushRecService", (List)result.getSuccessPkIds());
            }
            if (EmptyUtil.isNoEmpty(outParam.getRepayBillList())) {
                result = TmcOperateServiceHelper.execOperate((String)"caspaysaveandpush", (String)"cfm_repaymentbill", (Object[])outParam.getRepayBillList().toArray(), (OperateOption)OperateOption.create(), (boolean)true);
                IfmConsistencyServiceHelper.asyncPush((String)"repayment_autoPushPay", (String)"rePaymenBillPushPayService", (List)result.getSuccessPkIds());
            }
            if (EmptyUtil.isNoEmpty(outParam.getIntBillList())) {
                result = TmcOperateServiceHelper.execOperate((String)"genpaybill", (String)"cfm_interestbill", (Object[])outParam.getIntBillList().toArray(), (OperateOption)OperateOption.create(), (boolean)true);
                IfmConsistencyServiceHelper.asyncPush((String)"intBill_asyncPushPay", (String)"interestBillPushPayService", (List)result.getSuccessPkIds());
            }
            if (EmptyUtil.isNoEmpty(outParam.getPayBankCheckFlags())) {
                TransDetailHelper.matchPayBillByBankCheckFlag(outParam.getPayBankCheckFlags());
            }
            if (EmptyUtil.isNoEmpty(outParam.getRecBankCheckFlags())) {
                TransDetailHelper.matchRecBillByBankCheckFlag(outParam.getRecBankCheckFlags());
            }
        }
    }
}

