/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.bizdeal;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.InnerLoanAppliTypeEnum;

public class BizDealCenterChargeBackService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("businessstatus");
        selector.add("applitype");
        selector.add("sourcebillno");
        selector.add("sourcebillid");
        selector.add("iscallint");
        selector.add("creditor");
        selector.add("contractbillno");
        selector.add("contractamt");
        selector.add("amount");
        selector.add("iscycleloan");
        selector.add("repayaccount");
        selector.add("accountbank");
        selector.add("actinterest");
        selector.add("dealopinion");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> currlist = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<DynamicObject> upStreamlist = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject billDyn : dataEntities) {
            String appliType = billDyn.getString("applitype");
            this.dealCurrentBill(billDyn, appliType);
            this.dealUpStreamBill(billDyn, appliType, upStreamlist);
            if (!InnerLoanAppliTypeEnum.contract_change_apply.getValue().equals(appliType)) {
                TmcBotpHelper.deleteRation((String)"ifm_bizdealbill", (Long)billDyn.getLong("sourcebillid"), (Long)billDyn.getLong("id"));
            }
            currlist.add(billDyn);
        }
        SaveServiceHelper.update((DynamicObject[])currlist.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])upStreamlist.toArray(new DynamicObject[0]));
    }

    private void dealCurrentBill(DynamicObject billDyn, String appliType) {
        billDyn.set("businessstatus", (Object)"D");
        if (InnerLoanAppliTypeEnum.fin_apply.getValue().equals(appliType)) {
            billDyn.set("contractbillno", null);
        }
    }

    private void dealUpStreamBill(DynamicObject billDyn, String appliType, List<DynamicObject> upStreamlist) {
        long srcBillId = billDyn.getLong("sourcebillid");
        QFilter qFilter = new QFilter("id", "=", (Object)srcBillId);
        DynamicObject resultDyn = BusinessDataServiceHelper.loadSingle((String)this.getEntityNameFromAppliType(appliType), (String)this.getUpdateColumnFromAppliType(appliType), (QFilter[])qFilter.toArray());
        if (InnerLoanAppliTypeEnum.fin_apply.getValue().equals(appliType)) {
            resultDyn.set("businessstatus", (Object)"5");
            resultDyn.set("bitbackinfo", (Object)billDyn.getString("dealopinion"));
        } else if (InnerLoanAppliTypeEnum.contract_change_apply.getValue().equals(appliType)) {
            resultDyn.set("confirmstatus", (Object)"yetreturn");
            resultDyn.set("bizstatus", (Object)"3");
            resultDyn.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        } else if (InnerLoanAppliTypeEnum.loan_change_apply.getValue().equals(appliType)) {
            resultDyn.set("bizstatus", (Object)"5");
            resultDyn.set("settlestatus", (Object)"bitback");
            resultDyn.set("confirmstatus", (Object)"yetreturn");
            resultDyn.set("bitbackinfo", (Object)billDyn.getString("dealopinion"));
        } else {
            resultDyn.set("settlestatus", (Object)"bitback");
            resultDyn.set("bitbackinfo", (Object)billDyn.getString("dealopinion"));
            if (InnerLoanAppliTypeEnum.repay_apply.getValue().equals(appliType) && billDyn.getBoolean("iscallint")) {
                DynamicObject intBill = BusinessDataServiceHelper.loadSingle((String)"cfm_interestbill", (String)this.getUpdateColumnFromAppliType(appliType), (QFilter[])new QFilter[]{new QFilter("repaymentid", "=", (Object)srcBillId)});
                if (intBill != null) {
                    intBill.set("settlestatus", (Object)"bitback");
                    intBill.set("bitbackinfo", (Object)billDyn.getString("dealopinion"));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{intBill});
                }
            } else if (InnerLoanAppliTypeEnum.extend_apply.getValue().equals(appliType)) {
                resultDyn.set("confirmstatus", (Object)"yetreturn");
            }
        }
        upStreamlist.add(resultDyn);
    }

    private String getEntityNameFromAppliType(String appliType) {
        String entityName = "";
        switch (appliType) {
            case "fin_apply": {
                entityName = "cfm_loan_apply";
                break;
            }
            case "loan_apply": {
                entityName = "cfm_loanbill";
                break;
            }
            case "repay_apply": {
                entityName = "cfm_repaymentbill";
                break;
            }
            case "int_apply": {
                entityName = "cfm_interestbill";
                break;
            }
            case "extend_apply": {
                entityName = "ifm_contractextendbill";
                break;
            }
            case "contract_change_apply": {
                entityName = "cfm_contract_apply";
                break;
            }
            case "loan_change_apply": {
                entityName = "cfm_apply_loanbill";
                break;
            }
        }
        return entityName;
    }

    private String getUpdateColumnFromAppliType(String appliType) {
        String updateColumnStr = "";
        updateColumnStr = "fin_apply".equals(appliType) ? "businessstatus,bitbackinfo" : ("loan_apply".equals(appliType) ? "settlestatus,drawtype,bitbackinfo" : ("contract_change_apply".equals(appliType) ? "confirmstatus,bizstatus,billstatus" : ("extend_apply".equals(appliType) ? "settlestatus,confirmstatus,bitbackinfo" : ("loan_change_apply".equals(appliType) ? "settlestatus,confirmstatus,bizstatus,bitbackinfo" : "settlestatus,bitbackinfo"))));
        return updateColumnStr;
    }
}

