/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.bizdeal;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BizDealStatusEnum;
import kd.tmc.ifm.enums.SettleCenterStatusEnum;
import kd.tmc.ifm.helper.BizDealHelper;

public class BizDealCenterUnAuditService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(BizDealCenterUnAuditService.class);
    private static final String LOANAPPLYSTATUS_HANDLING = "2";

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("businessstatus");
        selector.add("applitype");
        selector.add("sourcebillid");
        selector.add("contractbillno");
        selector.add("iscallint");
        selector.add("contractamt");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        block16: for (DynamicObject billDyn : dataEntities) {
            billDyn.set("businessstatus", (Object)BizDealStatusEnum.UNDEAL.getValue());
            String appliType = billDyn.getString("applitype");
            logger.info("BizDealCenterUnAudit appliType:" + appliType);
            QFilter qFilter = new QFilter("id", "=", (Object)billDyn.getLong("sourcebillid"));
            switch (appliType) {
                case "fin_apply": {
                    this.dealFinApply(billDyn, qFilter);
                    continue block16;
                }
                case "extend_apply": {
                    this.dealExtendApply(billDyn);
                    continue block16;
                }
                case "loan_apply": {
                    this.dealLoanApply(billDyn, qFilter);
                    continue block16;
                }
                case "repay_apply": {
                    this.dealRepayApply(billDyn, qFilter);
                    continue block16;
                }
                case "int_apply": {
                    this.dealIntApply(billDyn, qFilter);
                    continue block16;
                }
                case "loan_change_apply": {
                    this.dealLoanBillApply(qFilter);
                    continue block16;
                }
            }
        }
    }

    private void dealExtendApply(DynamicObject billDyn) {
        long sourceBillId = billDyn.getLong("sourcebillid");
        TmcOperateServiceHelper.execOperate((String)"cancelconfirm", (String)"ifm_contractextendbill", (Object[])new Object[]{sourceBillId}, (OperateOption)OperateOption.create());
        DynamicObject extendBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"ifm_contractextendbill");
        extendBill.set("settlestatus", (Object)SettleCenterStatusEnum.SUBMIT.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extendBill});
    }

    private void dealIntApply(DynamicObject bizDyn, QFilter qFilter) {
        DynamicObject intBill = BusinessDataServiceHelper.loadSingle((String)"ifm_interestbill", (String)"id,settlestatus,bankcheckflag", (QFilter[])qFilter.toArray());
        TmcOperateServiceHelper.execOperate((String)"cancelconfirm", (String)"ifm_interestbill", (Object[])new Object[]{intBill.getLong("id")}, (OperateOption)OperateOption.create());
        intBill.set("settlestatus", (Object)SettleCenterStatusEnum.SUBMIT.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{intBill});
        TmcBotpHelper.deleteRation((String)"ifm_interestbill", (Long)bizDyn.getLong("id"), (Long)bizDyn.getLong("sourcebillid"));
        BizDealHelper.asyncDelRecPayInfo((Object[])new Object[]{intBill.getPkValue()}, (boolean)true);
    }

    private void dealRepayApply(DynamicObject bizDyn, QFilter qFilter) {
        DynamicObject repayBill = BizDealHelper.updateSrcBillInfo((String)"cfm_repaymentbill", (String)"settlestatus,billno,bankcheckflag,id,loans,loans.e_ispayinst,loans.e_loanbill", (QFilter)qFilter);
        this.writeBackContractInfo(repayBill, "ifm_repaymentbill");
        String billno = repayBill.getString("billno");
        logger.info("repay begin deleteInnerSettlePayRec:" + billno);
        DynamicObjectCollection entrys = repayBill.getDynamicObjectCollection("loans");
        for (DynamicObject repayEntry : entrys) {
            DynamicObject[] intBills;
            boolean ispayinst = repayEntry.getBoolean("e_ispayinst");
            if (!ispayinst) continue;
            logger.info("repay: isPayInst" + billno + ispayinst);
            DynamicObject loanBill = repayEntry.getDynamicObject("e_loanbill");
            QFilter instFilter = new QFilter("repaymentid", "=", repayBill.getPkValue()).and(new QFilter("sourcebillid", "=", loanBill.getPkValue()));
            for (DynamicObject intBill : intBills = BusinessDataServiceHelper.load((String)"ifm_interestbill", (String)"id,settlestatus,bankcheckflag,billno", (QFilter[])instFilter.toArray())) {
                intBill.set("settlestatus", (Object)SettleCenterStatusEnum.HIDE.getValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{intBill});
                logger.info("repay:" + billno + "instBill begin deleteInnerSettlePayRec:" + intBill.getString("billno"));
                BizDealHelper.deleteInnerSettlePayRec((DynamicObject)intBill, (String)"ifm_transhandlebill");
                TmcBotpHelper.deleteRation((String)"ifm_interestbill", (Long)loanBill.getLong("id"), (Long)intBill.getLong("id"));
                logger.info("repay:" + billno + "instBill end deleteInnerSettlePayRec:" + intBill.getString("billno"));
            }
        }
        TmcBotpHelper.deleteRation((String)"ifm_repaymentbill", (Long)bizDyn.getLong("id"), (Long)bizDyn.getLong("sourcebillid"));
        BizDealHelper.asyncDelRecPayInfo((Object[])new Object[]{repayBill.getPkValue()}, (boolean)true);
        logger.info("repay end deleteInnerSettlePayRec:" + billno);
    }

    private void dealLoanApply(DynamicObject bizDeal, QFilter qFilter) {
        DynamicObject loanBill = BizDealHelper.updateSrcBillInfo((String)"cfm_loanbill", (String)"settlestatus,drawtype,bankcheckflag", (QFilter)qFilter);
        this.writeBackContractInfo(loanBill, "ifm_loanbill");
        GuaranteeUseHelper.cancelGuaranteeUse(Collections.singletonList(loanBill.getLong("id")));
        loanBill = BusinessDataServiceHelper.loadSingle((Object)loanBill.getPkValue(), (String)"ifm_loanbill");
        QFilter lastVersionQFilter = new QFilter("bizid", "=", loanBill.getPkValue());
        lastVersionQFilter.and("bizentity", "=", (Object)"ifm_loanbill");
        DynamicObject lastVersionObj = TmcDataServiceHelper.loadSingle((String)"fcs_changehistory", (String)"billinfo_tag", (QFilter[])lastVersionQFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)lastVersionObj)) {
            DynamicObject lastVersionLoanBill = BillChangeHistoryHelper.deserializeBillInfo((DynamicObject)lastVersionObj);
            loanBill.getDynamicObjectCollection("entry_gcontract").clear();
            GuaranteeUseHelper.copyGContractInfo((DynamicObject)loanBill, (DynamicObject)lastVersionLoanBill);
            DeleteServiceHelper.delete((String)"fcs_changehistory", (QFilter[])lastVersionQFilter.toArray());
            GuaranteeUseHelper.saveGuaranteeUse((DynamicObject[])new DynamicObject[]{loanBill}, (String[])new String[0]);
        }
        TmcBotpHelper.deleteRation((String)"ifm_loanbill", (Long)bizDeal.getLong("id"), (Long)bizDeal.getLong("sourcebillid"));
        BizDealHelper.asyncDelRecPayInfo((Object[])new Object[]{loanBill.getPkValue()}, (boolean)false);
    }

    private void dealFinApply(DynamicObject bizDeal, QFilter qFilter) {
        DynamicObject loanApply;
        Map targetMap = BFTrackerServiceHelper.findTargetBills((String)bizDeal.getDataEntityType().getName(), (Long[])new Long[]{bizDeal.getLong("id")});
        if (targetMap.size() != 0 && targetMap.get("ifm_loancontractbill") != null) {
            HashSet contractIdSet = (HashSet)targetMap.get("ifm_loancontractbill");
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_loancontractbill", (Object[])contractIdSet.toArray(), (OperateOption)OperateOption.create());
        }
        if ((loanApply = BusinessDataServiceHelper.loadSingle((String)"cfm_loan_apply", (String)"businessstatus", (QFilter[])qFilter.toArray())) != null) {
            loanApply.set("businessstatus", (Object)LOANAPPLYSTATUS_HANDLING);
            SaveServiceHelper.update((DynamicObject)loanApply);
        }
        bizDeal.set("contractbillno", null);
        bizDeal.set("contractamt", null);
    }

    private void writeBackContractInfo(DynamicObject billDyn, String entityName) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("comefrom", "bizdealbill");
        TmcOperateServiceHelper.execOperate((String)"cancelconfirm", (String)entityName, (Object[])new Object[]{billDyn.getLong("id")}, (OperateOption)option);
    }

    private void dealLoanBillApply(QFilter qFilter) {
        DynamicObject applyBill = TmcDataServiceHelper.loadSingle((String)"cfm_apply_loanbill", (QFilter[])qFilter.toArray());
        applyBill.set("bizstatus", (Object)LOANAPPLYSTATUS_HANDLING);
        applyBill.set("settlestatus", (Object)"submit");
        applyBill.set("confirmstatus", (Object)"waitconfirm");
        SaveServiceHelper.update((DynamicObject)applyBill);
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cfm", (String)"LoanBillApplyService", (String)"writeBackLoanBill", (Object[])new Object[]{new DynamicObject[]{applyBill}});
    }
}

