/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.bizdeal.audit;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.common.chain.AbstractBusinessHandler;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandleParam;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.ifm.enums.InnerLoanAppliTypeEnum;

public class FinApplyBizDealHandler
extends AbstractBusinessHandler {
    private static final String LOANAPPLYSTATUS_DONE = "4";

    public void doProcess(DynamicObject bizBill, BusinessHandleParam param) {
        DynamicObject[] loanContractArr = TmcBotpHelper.push((DynamicObject)bizBill, (String)"ifm_loancontractbill");
        if (loanContractArr.length == 0) {
            return;
        }
        this.copyGContract(bizBill, loanContractArr[0]);
        String contractBillNo = CodeRuleServiceHelper.readNumber((String)"ifm_loancontractbill", (DynamicObject)loanContractArr[0], (String)loanContractArr[0].getDynamicObject("org").getPkValue().toString());
        loanContractArr[0].set("billno", (Object)contractBillNo);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarning", "true");
        OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)"ifm_loancontractbill", (DynamicObject[])loanContractArr, (OperateOption)operateOption);
        Object[] idArr = submitResult.getSuccessPkIds().toArray();
        if (submitResult.isSuccess()) {
            GuaranteeUseHelper.saveGuaranteeUse((DynamicObject[])loanContractArr, (String[])new String[0]);
            OperationResult auditResult = TmcOperateServiceHelper.execOperate((String)"audit", (String)"ifm_loancontractbill", (Object[])idArr, (OperateOption)operateOption);
            if (!auditResult.isSuccess()) {
                TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"ifm_loancontractbill", (Object[])idArr, (OperateOption)operateOption);
                TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_loancontractbill", (Object[])idArr, (OperateOption)operateOption);
                throw new KDBizException(String.join((CharSequence)";", ((OperateErrorInfo)((ValidateResult)auditResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
            }
        } else {
            throw new KDBizException(String.join((CharSequence)";", ((OperateErrorInfo)((ValidateResult)submitResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
        }
        bizBill.set("contractbillno", (Object)contractBillNo);
        bizBill.set("contractamt", (Object)bizBill.getBigDecimal("amount"));
        DynamicObject loanApply = TmcDataServiceHelper.loadSingle((Object)bizBill.getLong("sourcebillid"), (String)"cfm_loan_apply", (String)"businessstatus");
        if (loanApply != null) {
            loanApply.set("businessstatus", (Object)LOANAPPLYSTATUS_DONE);
            SaveServiceHelper.update((DynamicObject)loanApply);
        }
    }

    private void copyGContract(DynamicObject bizDeal, DynamicObject targetBill) {
        for (DynamicObject guaranteeUse : bizDeal.getDynamicObjectCollection("entry_gcontract")) {
            DynamicObject newRow = targetBill.getDynamicObjectCollection("entry_gcontract").addNew();
            newRow.set("gcontract", guaranteeUse.get("gcontract"));
            newRow.set("gratio", guaranteeUse.get("gratio"));
            newRow.set("gamount", guaranteeUse.get("gamount"));
            newRow.set("gexchrate", guaranteeUse.get("gexchrate"));
            newRow.set("gcomment", guaranteeUse.get("gcomment"));
        }
    }

    public boolean doFilter(DynamicObject bizBill, BusinessHandleParam param) {
        return InnerLoanAppliTypeEnum.isFinApply((String)bizBill.getString("applitype"));
    }
}

