/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.bizdeal.audit;

import java.io.IOException;
import java.util.Collections;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.metadata.util.GzipUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.common.chain.AbstractBusinessHandler;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandleParam;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.opservice.bizdeal.audit.BizDealApplyOutParam;
import kd.tmc.ifm.enums.InnerLoanAppliTypeEnum;

public class LoanApplyBizDealHandler
extends AbstractBusinessHandler {
    private static final Log logger = LogFactory.getLog(LoanApplyBizDealHandler.class);

    public void doProcess(DynamicObject bizDeal, BusinessHandleParam param) {
        DynamicObject recTransBill;
        Long sourceBillId = bizDeal.getLong("sourcebillid");
        DynamicObject loanBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"ifm_loanbill");
        if (loanBill.getBoolean("isrelcash") && EmptyUtil.isEmpty((String)loanBill.getString("eassrcid"))) {
            TmcOperateServiceHelper.execOperate((String)"push2rectransbill", (String)"ifm_loanbill", (Object[])new Object[]{sourceBillId}, (OperateOption)OperateOption.create());
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(recTransBill = QueryServiceHelper.queryOne((String)"ifm_rectransbill", (String)"bankcheckflag", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)sourceBillId)})))) {
            loanBill.set("bankcheckflag", (Object)recTransBill.getString("bankcheckflag"));
            BizDealApplyOutParam outParam = (BizDealApplyOutParam)param.getOutParam();
            outParam.getRecBankCheckFlags().add(recTransBill.getString("bankcheckflag"));
            outParam.getLoanBillList().add(sourceBillId);
        }
        loanBill.set("settlestatus", (Object)"accept");
        loanBill.set("settlecenter", (Object)bizDeal.getDynamicObject("creditor").getLong("id"));
        loanBill.set("bizdealno", (Object)bizDeal.getString("billno"));
        loanBill.set("iscycleloan", (Object)bizDeal.getBoolean("iscycleloan"));
        DynamicObject repayAcct = bizDeal.getDynamicObject("repayaccount");
        if (EmptyUtil.isEmpty((DynamicObject)repayAcct)) {
            repayAcct = bizDeal.getDynamicObject("accountbank");
        }
        loanBill.set("repayacctbank", (Object)(repayAcct != null ? repayAcct.getLong("id") : 0L));
        SaveServiceHelper.update((DynamicObject)loanBill);
        this.dealLoanApplyGContract(bizDeal, loanBill);
        TmcOperateServiceHelper.execOperate((String)"businessconfirm", (String)"ifm_loanbill", (Object[])new Object[]{loanBill.getLong("id")}, (OperateOption)OperateOption.create());
    }

    private void dealLoanApplyGContract(DynamicObject bizDeal, DynamicObject loanBill) {
        DynamicObject historyObj = TmcDataServiceHelper.newDynamicObject((String)"fcs_changehistory");
        historyObj.set("bizid", loanBill.getPkValue());
        historyObj.set("bizentity", (Object)"ifm_loanbill");
        GuaranteeUseHelper.setGContractInfo((DynamicObject)loanBill, (Long)loanBill.getLong("id"));
        String serialize = SerializationUtils.serializeToBase64((Object)loanBill);
        try {
            historyObj.set("billinfo_tag", (Object)GzipUtils.compress((String)serialize, (String)"UTF-8"));
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{historyObj});
        loanBill.getDynamicObjectCollection("entry_gcontract").clear();
        this.copyGContract(bizDeal, loanBill);
        GuaranteeUseHelper.saveGuaranteeUse((DynamicObject[])new DynamicObject[]{loanBill}, (String[])new String[0]);
        GuaranteeUseHelper.confirmGuaranteeUse(Collections.singletonList(loanBill.getLong("id")));
    }

    private void copyGContract(DynamicObject bizDeal, DynamicObject targetBill) {
        for (DynamicObject guaranteeUse : bizDeal.getDynamicObjectCollection("entry_gcontract")) {
            DynamicObject newRow = targetBill.getDynamicObjectCollection("entry_gcontract").addNew();
            newRow.set("gcontract", guaranteeUse.get("gcontract"));
            newRow.set("gratio", guaranteeUse.get("gratio"));
            newRow.set("gamount", guaranteeUse.get("gamount"));
            newRow.set("gexchrate", guaranteeUse.get("gexchrate"));
            newRow.set("gcomment", guaranteeUse.get("gcomment"));
        }
    }

    public boolean doFilter(DynamicObject bizBill, BusinessHandleParam param) {
        return InnerLoanAppliTypeEnum.isLoanApply((String)bizBill.getString("applitype"));
    }
}

