/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.bizdeal.audit;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.common.chain.AbstractBusinessHandler;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandleParam;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.opservice.bizdeal.audit.BizDealApplyOutParam;
import kd.tmc.ifm.enums.InnerLoanAppliTypeEnum;
import kd.tmc.ifm.helper.BizDealHelper;

public class RepayApplyBizDealHandler
extends AbstractBusinessHandler {
    private static final Log logger = LogFactory.getLog(RepayApplyBizDealHandler.class);

    public void doProcess(DynamicObject bizDeal, BusinessHandleParam param) {
        Long sourceBillId = bizDeal.getLong("sourcebillid");
        DynamicObject repay = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"ifm_repaymentbill");
        repay.set("settlestatus", (Object)"accept");
        repay.set("settlecenter", (Object)bizDeal.getDynamicObject("creditor").getLong("id"));
        repay.set("bizdealno", (Object)bizDeal.getString("billno"));
        repay.set("iscycleloan", (Object)bizDeal.getBoolean("iscycleloan"));
        SaveServiceHelper.update((DynamicObject)repay);
        String billno = repay.getString("billno");
        logger.info("repay  begin pushInnerSettlePayBill:" + billno);
        BizDealHelper.pushInnerSettlePayBill((DynamicObject)repay);
        logger.info("repay  end pushInnerSettlePayBill:" + billno);
        String bankCheckFlag = repay.getString("bankcheckflag");
        if (EmptyUtil.isNoEmpty((String)bankCheckFlag)) {
            BizDealApplyOutParam outParam = (BizDealApplyOutParam)param.getOutParam();
            outParam.getPayBankCheckFlags().add(bankCheckFlag);
            outParam.getRepayBillList().add(repay.getLong("id"));
        }
        DynamicObjectCollection entrys = repay.getDynamicObjectCollection("loans");
        for (DynamicObject repayEntry : entrys) {
            DynamicObject[] intBills;
            boolean ispayinst = repayEntry.getBoolean("e_ispayinst");
            logger.info("repay: isPayInst" + billno + ispayinst);
            if (!ispayinst) continue;
            DynamicObject loanBill = repayEntry.getDynamicObject("e_loanbill");
            QFilter instFilter = new QFilter("repaymentid", "=", repay.getPkValue()).and(new QFilter("sourcebillid", "=", loanBill.getPkValue()));
            List rateIdList = QueryServiceHelper.queryPrimaryKeys((String)"cfm_interestbill", (QFilter[])instFilter.toArray(), null, (int)-1);
            if (!EmptyUtil.isNoEmpty((Object)rateIdList)) continue;
            for (DynamicObject intBill : intBills = BusinessDataServiceHelper.load((Object[])rateIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ifm_interestbill"))) {
                intBill.set("settlestatus", (Object)"accept");
                intBill.set("settlecenter", (Object)bizDeal.getDynamicObject("creditor").getLong("id"));
                intBill.set("iscycleloan", (Object)bizDeal.getBoolean("iscycleloan"));
                intBill.set("bizdealno", (Object)bizDeal.getString("billno"));
                SaveServiceHelper.update((DynamicObject)intBill);
                BizDealHelper.genBatchIntBill((Long)intBill.getLong("id"), (String)"1", (String)"cfm");
                TmcBotpHelper.saveRelation((String)"ifm_loanbill", (Long)loanBill.getLong("id"), (String)"ifm_interestbill", (Long)intBill.getLong("id"));
            }
        }
        TmcOperateServiceHelper.execOperate((String)"businessconfirm", (String)"ifm_repaymentbill", (Object[])new Object[]{repay.getLong("id")}, (OperateOption)OperateOption.create());
    }

    public boolean doFilter(DynamicObject bizBill, BusinessHandleParam param) {
        return InnerLoanAppliTypeEnum.isRepayApply((String)bizBill.getString("applitype"));
    }
}

