/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.crosspay;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class CrossPaySubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("iscrosspay");
        selector.add("crosstrantype");
        selector.add("recaddress");
        selector.add("paymentterm");
        selector.add("recemail");
        selector.add("reccountry");
        selector.add("recprovince");
        selector.add("reccity");
        selector.add("recbankaddress");
        selector.add("recswiftcode");
        selector.add("recroutingnum");
        selector.add("recothercode");
        selector.add("instructmsg");
        selector.add("auditparam");
        selector.add("transtypes");
        selector.add("paymethod");
        selector.add("serlevel");
        selector.add("checktype");
        selector.add("sendway");
        selector.add("checkuse");
        selector.add("settlementmethod");
        selector.add("mobile");
        selector.add("paymentfps");
        selector.add("paymentareacode");
        selector.add("inforpayment");
        selector.add("informrecemail");
        selector.add("proxybebank");
        selector.add("proxybebankname");
        selector.add("proxybebanksc");
        selector.add("proxybebankad");
        selector.add("proxybebankcountry");
        selector.add("proxybebankactno");
        selector.add("proxybebankactname");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            boolean isCrossPay = dataEntity.getBoolean("iscrosspay");
            HashMap<String, Boolean> recInfoViewMap = new HashMap<String, Boolean>();
            if (isCrossPay) {
                this.clearHideInfo(dataEntity, recInfoViewMap);
            }
            this.defaultRecInfo(dataEntity, recInfoViewMap);
        }
    }

    private void clearHideInfo(DynamicObject dataEntity, Map<String, Boolean> recInfoViewMap) {
        DynamicObject crossTranType = dataEntity.getDynamicObject("crosstrantype");
        if (null == crossTranType) {
            return;
        }
        crossTranType = TmcDataServiceHelper.loadSingle((Object)crossTranType.getPkValue(), (String)"bei_crosstrantype");
        DynamicObjectCollection entries = crossTranType.getDynamicObjectCollection("entry");
        Map<String, String> fieldsMap = this.getFieldMap(dataEntity);
        for (DynamicObject entry : entries) {
            String fieldKey = entry.getString("fieldkey");
            String string = fieldKey = "transtype".equals(fieldKey) ? "transtypes" : fieldKey;
            if (!fieldsMap.containsKey(fieldKey)) continue;
            boolean issee = entry.getBoolean("issee");
            List<String> recInfos = Arrays.asList("reccountry", "recprovince", "reccity");
            if (recInfos.contains(fieldKey)) {
                recInfoViewMap.put(fieldKey, issee);
            }
            if (issee) continue;
            dataEntity.set(fieldKey, null);
        }
    }

    private Map<String, String> getFieldMap(DynamicObject info) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        DataEntityPropertyCollection properties = info.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof EntryProp) {
                EntryProp p = (EntryProp)property;
                DataEntityPropertyCollection entryProps = p.getDynamicCollectionItemPropertyType().getProperties();
                entryProps.forEach(prop -> fieldMap.put(prop.getName(), "entry"));
                continue;
            }
            fieldMap.put(property.getName(), "head");
        }
        return fieldMap;
    }

    private void defaultRecInfo(DynamicObject info, Map<String, Boolean> recInfoViewMap) {
        DynamicObject payeeBank = info.getDynamicObject("payeebank");
        if (null != payeeBank) {
            payeeBank = TmcDataServiceHelper.loadSingleFromCache((Object)payeeBank.getPkValue(), (String)"bd_bebank");
            Boolean isShow = recInfoViewMap.get("reccountry");
            if (null == isShow || !isShow.booleanValue()) {
                info.set("reccountry", payeeBank.getDynamicObject("country").getPkValue());
            }
            DynamicObject city = payeeBank.getDynamicObject("city");
            isShow = recInfoViewMap.get("recprovince");
            if (null == isShow || !isShow.booleanValue()) {
                DynamicObject province = payeeBank.getDynamicObject("province");
                if (null != province) {
                    info.set("recprovince", (Object)province.getString("name"));
                } else if (null != city) {
                    info.set("recprovince", (Object)city.getString("name"));
                }
            }
            if (!(null != (isShow = recInfoViewMap.get("recprovince")) && isShow.booleanValue() || null == city)) {
                info.set("reccity", (Object)city.getString("name"));
            }
        }
    }
}

