/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.deduction;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.DeductionTypeEnum;
import kd.tmc.ifm.enums.PayStatusEnum;
import kd.tmc.ifm.enums.RecTransPayStatusEnum;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.helper.DeductionPayHelper;
import kd.tmc.ifm.helper.TransBillHelper;

public class DeductionAuditService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] datas) throws KDException {
        Object[] deductionIds;
        Object[] refundIds = Arrays.stream(datas).filter(o -> DeductionTypeEnum.CENTER_REFUND.getValue().equals(o.getString("deductiontype"))).map(DataEntityBase::getPkValue).toArray();
        if (EmptyUtil.isNoEmpty((Object[])refundIds)) {
            TmcOperateServiceHelper.execOperate((String)"pushtorectransbill", (String)"ifm_deduction", (Object[])refundIds, (OperateOption)OperateOption.create());
        }
        if (EmptyUtil.isNoEmpty((Object[])(deductionIds = Arrays.stream(datas).filter(o -> !DeductionTypeEnum.CENTER_REFUND.getValue().equals(o.getString("deductiontype"))).map(DataEntityBase::getPkValue).toArray()))) {
            TmcOperateServiceHelper.execOperate((String)"pushandsave", (String)"ifm_deduction", (Object[])deductionIds, (OperateOption)OperateOption.create());
        }
        for (DynamicObject bill : datas) {
            String type = bill.getString("deductiontype");
            boolean isRefund = DeductionTypeEnum.CENTER_REFUND.getValue().equals(type);
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            boolean isAuto = TransBillHelper.isAutoPaid((DynamicObject)bill) || isRefund;
            for (DynamicObject row : entryEntity) {
                row.set("paystatus", (Object)(isAuto ? PayStatusEnum.SUCCEED.getValue() : PayStatusEnum.DOING.getValue()));
            }
            if (!isAuto) continue;
            bill.set("realamount", (Object)bill.getBigDecimal("receiveamount"));
        }
        DeductionPayHelper.payStatusWriteBack((DynamicObject[])datas);
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        Object[] bills;
        Object[] transHandlRecIds;
        Object[] bills2;
        Object[] transHandlIds;
        Object[] tranBills;
        super.handlerException(dataEntities);
        List ids = Arrays.stream(dataEntities).filter(o -> !DeductionTypeEnum.CENTER_AGENT.getValue().equals(o.getString("deductiontype")) || TransBillHelper.isPassivePay((DynamicObject)o.getDynamicObject("paymentidentify"), (String)o.getString("deductiontype"))).map(t -> t.getLong("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(ids) && EmptyUtil.isNoEmpty((Object[])(tranBills = TmcDataServiceHelper.load((String)"ifm_transhandlebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)"ifm_deduction"), new QFilter("sourcebillid", "in", ids), new QFilter("paidstatus", "=", (Object)TransBillPaidStatusEnum.PAID.getValue())})))) {
            TmcOperateServiceHelper.execOperate((String)"canclepay", (String)"ifm_transhandlebill", (Object[])Arrays.stream(tranBills).map(DataEntityBase::getPkValue).toArray(), (OperateOption)OperateOption.create());
        }
        if (EmptyUtil.isNoEmpty((Object[])(transHandlIds = Arrays.stream(dataEntities).filter(o -> DeductionTypeEnum.CENTER_AGENT.getValue().equals(o.getString("deductiontype")) && !TransBillHelper.isPassivePay((DynamicObject)o.getDynamicObject("paymentidentify"), (String)o.getString("deductiontype"))).map(DataEntityBase::getPkValue).toArray())) && EmptyUtil.isNoEmpty((Object[])(bills2 = TmcDataServiceHelper.load((String)"ifm_transhandlebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", (Object)transHandlIds), new QFilter("sourcebilltype", "=", (Object)"ifm_deduction"), new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()), new QFilter("paidstatus", "=", (Object)TransBillPaidStatusEnum.WAITING.getValue())})))) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_transhandlebill", (Object[])Arrays.stream(bills2).map(o -> o.getPkValue()).toArray(), (OperateOption)OperateOption.create());
        }
        if (EmptyUtil.isNoEmpty((Object[])(transHandlRecIds = Arrays.stream(dataEntities).filter(o -> DeductionTypeEnum.CENTER_REFUND.getValue().equals(o.getString("deductiontype")) && !TransBillHelper.isPassivePay((DynamicObject)o.getDynamicObject("paymentidentify"), (String)o.getString("deductiontype"))).map(DataEntityBase::getPkValue).toArray())) && EmptyUtil.isNoEmpty((Object[])(bills = TmcDataServiceHelper.load((String)"ifm_rectransbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", (Object)transHandlRecIds), new QFilter("sourcebilltype", "=", (Object)"ifm_deduction"), new QFilter("paidstatus", "=", (Object)RecTransPayStatusEnum.PAID.getValue())})))) {
            TmcOperateServiceHelper.execOperate((String)"canclepay", (String)"ifm_rectransbill", (Object[])Arrays.stream(bills).map(o -> o.getPkValue()).toArray(), (OperateOption)OperateOption.create());
        }
    }
}

