/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.deduction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.DeductionTypeEnum;
import kd.tmc.ifm.enums.PayStatusEnum;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.helper.DeductionPayHelper;
import kd.tmc.ifm.helper.JournalBookHelper;
import kd.tmc.ifm.helper.TransBillHelper;

public class DeductionUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("entryentity");
        selector.add("sourcebillid");
        selector.add("sourcebilltype");
        selector.add("paystatus");
        selector.add("sourceentryid");
        selector.add("receiveamount");
        selector.add("payamount");
        selector.add("returncomment");
        selector.add("realamount");
        selector.add("deductiontype");
        selector.add("payeetype");
        selector.add("paybankaccount");
        selector.add("paybank");
        selector.add("scorg");
        selector.add("receivecompany");
        selector.add("receiveaccount");
        selector.add("center");
        selector.add("payee");
        selector.add("payeeaccountbank");
        selector.add("payeename");
        selector.add("payeebanknum");
        selector.add("paymentidentify");
        return selector;
    }

    public void process(DynamicObject[] bills) throws KDException {
        ArrayList<Long> ids = new ArrayList<Long>(bills.length);
        ArrayList<Object> tranBillIds = new ArrayList<Object>(bills.length);
        ArrayList<Object> recTranBillIds = new ArrayList<Object>(bills.length);
        for (DynamicObject bill : bills) {
            String type = bill.getString("deductiontype");
            boolean isBank = TransBillHelper.isPassivePay((DynamicObject)bill.getDynamicObject("paymentidentify"), (String)type);
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entryEntity) {
                row.set("paystatus", (Object)PayStatusEnum.WAIT.getValue());
            }
            if (TransBillHelper.isAutoPaid((DynamicObject)bill)) {
                bill.set("realamount", (Object)BigDecimal.ZERO);
                tranBillIds.addAll(this.getBillIds("ifm_transhandlebill", bill.getPkValue()));
                if (isBank) {
                    ids.add(bill.getLong("id"));
                }
            }
            if (!DeductionTypeEnum.CENTER_REFUND.getValue().equals(type)) continue;
            bill.set("realamount", (Object)BigDecimal.ZERO);
            recTranBillIds.addAll(this.getBillIds("ifm_rectransbill", bill.getPkValue()));
        }
        if (EmptyUtil.isNoEmpty(tranBillIds)) {
            TmcOperateServiceHelper.execOperate((String)"canclepay", (String)"ifm_transhandlebill", (Object[])tranBillIds.toArray(), (OperateOption)OperateOption.create());
        }
        if (EmptyUtil.isNoEmpty(recTranBillIds)) {
            TmcOperateServiceHelper.execOperate((String)"canclepay", (String)"ifm_rectransbill", (Object[])recTranBillIds.toArray(), (OperateOption)OperateOption.create());
        }
        if (ids.size() > 0) {
            JournalBookHelper.cancelJournal((String)"ifm_deduction", ids);
        }
        DeductionPayHelper.payStatusWriteBack((DynamicObject[])bills);
    }

    private List<Object> getBillIds(String entryName, Object id) {
        DynamicObject[] transhandleBills = TmcDataServiceHelper.load((String)entryName, (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)"ifm_deduction"), new QFilter("sourcebillid", "=", id), new QFilter("paidstatus", "!=", (Object)TransBillPaidStatusEnum.REFUSED.getValue())});
        return Arrays.stream(transhandleBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
    }
}

