/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.inneracct;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class InnerAcctAuditService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(InnerAcctAuditService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("name");
        selector.add("open_date");
        selector.add("mgrstratg");
        selector.add("currency_mgrfee");
        selector.add("mgrfee");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        Object[] pkValues = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray(Object[]::new);
        TmcOperateServiceHelper.execOperate((String)"push_bankacct", (String)"ifm_inneracct", (Object[])pkValues, (OperateOption)OperateOption.create(), (boolean)true);
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.handlerException(dataEntities);
        this.rollbackData(dataEntities);
    }

    private void rollbackData(DynamicObject[] dataEntities) {
        HashSet<Long> innerAcctIds = new HashSet<Long>(Arrays.asList(this.mapPkValues(dataEntities)));
        this.deleteAccountBanks(innerAcctIds);
    }

    private void deleteAccountBanks(Set<Long> innerAcctBillIds) {
        Set<Long> accountBankIds = this.getTargetBill("ifm_inneracct", innerAcctBillIds.toArray(new Long[0]), "am_accountbank");
        if (!CollectionUtils.isEmpty(accountBankIds)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isneedvalidate", String.valueOf(false));
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"am_accountbank", (Object[])accountBankIds.toArray(), (OperateOption)operateOption, (boolean)true);
        }
    }

    private Long[] mapPkValues(DynamicObject[] dataEntities) {
        Long[] pkValues = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            pkValues[i] = (Long)dataEntities[i].getPkValue();
        }
        return pkValues;
    }

    public Set<Long> getTargetBill(String currEntity, Long[] currEntityIds, String targetEntityName) {
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)currEntity, (Long[])currEntityIds);
        return (Set)targetBills.get(targetEntityName);
    }
}

