/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.inneracct;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.ifm.enums.InnerAcctStatusEnum;
import kd.tmc.ifm.helper.InnerAcctHelper;

public class InnerAcctUnCloseService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("acctstatus");
        selector.add("closedate");
        selector.add("closereason");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        boolean fromAcceptance = this.getOperationVariable().containsKey("fromacceptance");
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("acctstatus", (Object)(fromAcceptance ? BankAcctStatusEnum.CLOSING.getValue() : InnerAcctStatusEnum.NORMAL.getValue()));
            dataEntity.set("closedate", (Object)"");
            ILocaleString localeString = dataEntity.getLocaleString("closereason");
            this.clearLocaleString(localeString);
            dataEntity.set("closereason", (Object)localeString);
        }
        this.updateBankAccount(dataEntities);
    }

    private void updateBankAccount(DynamicObject[] dataEntities) {
        List pkValues = Arrays.stream(dataEntities).map(d -> (Long)d.getPkValue()).collect(Collectors.toList());
        InnerAcctHelper.updateIntObjectStatus(pkValues, (BaseEnableEnum)BaseEnableEnum.ENABLE);
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"am_accountbank", (String)String.join((CharSequence)",", "id", "acctstatus", "closedate", "closereason", "issetbankinterface", "inneracct"), (QFilter[])new QFilter("inneracct", "in", pkValues).toArray());
        boolean fromAcceptance = this.getOperationVariable().containsKey("fromacceptance");
        for (DynamicObject accountBank : accountBanks) {
            accountBank.set("acctstatus", (Object)(fromAcceptance ? BankAcctStatusEnum.CLOSING.getValue() : InnerAcctStatusEnum.NORMAL.getValue()));
            accountBank.set("closedate", (Object)"");
            ILocaleString localeString = accountBank.getLocaleString("closereason");
            this.clearLocaleString(localeString);
            accountBank.set("closereason", (Object)localeString);
        }
        try (TXHandle tx = TX.requiresNew((String)"accountbank.save");){
            SaveServiceHelper.save((DynamicObject[])accountBanks);
        }
    }

    private void clearLocaleString(ILocaleString iLocaleString) {
        iLocaleString.setLocaleValue_zh_CN("");
        iLocaleString.setLocaleValue_zh_TW("");
    }
}

